/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import java.util.Hashtable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import sun.management.snmp.jvmmib.JvmClassLoadingMBean;
import sun.management.snmp.jvmmib.JvmClassLoadingMeta;
import sun.management.snmp.jvmmib.JvmCompilationMBean;
import sun.management.snmp.jvmmib.JvmCompilationMeta;
import sun.management.snmp.jvmmib.JvmMemoryMBean;
import sun.management.snmp.jvmmib.JvmMemoryMeta;
import sun.management.snmp.jvmmib.JvmOSMBean;
import sun.management.snmp.jvmmib.JvmOSMeta;
import sun.management.snmp.jvmmib.JvmRuntimeMBean;
import sun.management.snmp.jvmmib.JvmRuntimeMeta;
import sun.management.snmp.jvmmib.JvmThreadingMBean;
import sun.management.snmp.jvmmib.JvmThreadingMeta;

public abstract class JVM_MANAGEMENT_MIB
extends SnmpMib
implements Serializable {
    static final long serialVersionUID = 6895037919735816732L;
    private boolean isInitialized = false;
    protected SnmpStandardObjectServer objectserver;
    protected final Hashtable<String, SnmpMibTable> metadatas = new Hashtable();

    public JVM_MANAGEMENT_MIB() {
        this.mibName = "JVM_MANAGEMENT_MIB";
    }

    @Override
    public void init() throws IllegalAccessException {
        if (this.isInitialized) {
            return;
        }
        try {
            this.populate(null, null);
        }
        catch (IllegalAccessException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new Error(x.getMessage());
        }
        this.isInitialized = true;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.isInitialized) {
            throw new InstanceAlreadyExistsException();
        }
        this.server = server;
        this.populate(server, name);
        this.isInitialized = true;
        return name;
    }

    public void populate(MBeanServer server, ObjectName name) throws Exception {
        if (this.isInitialized) {
            return;
        }
        if (this.objectserver == null) {
            this.objectserver = new SnmpStandardObjectServer();
        }
        this.initJvmOS(server);
        this.initJvmCompilation(server);
        this.initJvmRuntime(server);
        this.initJvmThreading(server);
        this.initJvmMemory(server);
        this.initJvmClassLoading(server);
        this.isInitialized = true;
    }

    protected void initJvmOS(MBeanServer server) throws Exception {
        JvmOSMeta meta;
        String oid = this.getGroupOid("JvmOS", "1.3.6.1.4.1.42.2.145.3.163.1.1.6");
        ObjectName objname = null;
        if (server != null) {
            objname = this.getGroupObjectName("JvmOS", oid, this.mibName + ":name=sun.management.snmp.jvmmib.JvmOS");
        }
        if ((meta = this.createJvmOSMetaNode("JvmOS", oid, objname, server)) != null) {
            meta.registerTableNodes(this, server);
            JvmOSMBean group = (JvmOSMBean)this.createJvmOSMBean("JvmOS", oid, objname, server);
            meta.setInstance(group);
            this.registerGroupNode("JvmOS", oid, objname, meta, group, server);
        }
    }

    protected JvmOSMeta createJvmOSMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmOSMeta(this, this.objectserver);
    }

    protected abstract Object createJvmOSMBean(String var1, String var2, ObjectName var3, MBeanServer var4);

    protected void initJvmCompilation(MBeanServer server) throws Exception {
        JvmCompilationMeta meta;
        String oid = this.getGroupOid("JvmCompilation", "1.3.6.1.4.1.42.2.145.3.163.1.1.5");
        ObjectName objname = null;
        if (server != null) {
            objname = this.getGroupObjectName("JvmCompilation", oid, this.mibName + ":name=sun.management.snmp.jvmmib.JvmCompilation");
        }
        if ((meta = this.createJvmCompilationMetaNode("JvmCompilation", oid, objname, server)) != null) {
            meta.registerTableNodes(this, server);
            JvmCompilationMBean group = (JvmCompilationMBean)this.createJvmCompilationMBean("JvmCompilation", oid, objname, server);
            meta.setInstance(group);
            this.registerGroupNode("JvmCompilation", oid, objname, meta, group, server);
        }
    }

    protected JvmCompilationMeta createJvmCompilationMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmCompilationMeta(this, this.objectserver);
    }

    protected abstract Object createJvmCompilationMBean(String var1, String var2, ObjectName var3, MBeanServer var4);

    protected void initJvmRuntime(MBeanServer server) throws Exception {
        JvmRuntimeMeta meta;
        String oid = this.getGroupOid("JvmRuntime", "1.3.6.1.4.1.42.2.145.3.163.1.1.4");
        ObjectName objname = null;
        if (server != null) {
            objname = this.getGroupObjectName("JvmRuntime", oid, this.mibName + ":name=sun.management.snmp.jvmmib.JvmRuntime");
        }
        if ((meta = this.createJvmRuntimeMetaNode("JvmRuntime", oid, objname, server)) != null) {
            meta.registerTableNodes(this, server);
            JvmRuntimeMBean group = (JvmRuntimeMBean)this.createJvmRuntimeMBean("JvmRuntime", oid, objname, server);
            meta.setInstance(group);
            this.registerGroupNode("JvmRuntime", oid, objname, meta, group, server);
        }
    }

    protected JvmRuntimeMeta createJvmRuntimeMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmRuntimeMeta(this, this.objectserver);
    }

    protected abstract Object createJvmRuntimeMBean(String var1, String var2, ObjectName var3, MBeanServer var4);

    protected void initJvmThreading(MBeanServer server) throws Exception {
        JvmThreadingMeta meta;
        String oid = this.getGroupOid("JvmThreading", "1.3.6.1.4.1.42.2.145.3.163.1.1.3");
        ObjectName objname = null;
        if (server != null) {
            objname = this.getGroupObjectName("JvmThreading", oid, this.mibName + ":name=sun.management.snmp.jvmmib.JvmThreading");
        }
        if ((meta = this.createJvmThreadingMetaNode("JvmThreading", oid, objname, server)) != null) {
            meta.registerTableNodes(this, server);
            JvmThreadingMBean group = (JvmThreadingMBean)this.createJvmThreadingMBean("JvmThreading", oid, objname, server);
            meta.setInstance(group);
            this.registerGroupNode("JvmThreading", oid, objname, meta, group, server);
        }
    }

    protected JvmThreadingMeta createJvmThreadingMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmThreadingMeta(this, this.objectserver);
    }

    protected abstract Object createJvmThreadingMBean(String var1, String var2, ObjectName var3, MBeanServer var4);

    protected void initJvmMemory(MBeanServer server) throws Exception {
        JvmMemoryMeta meta;
        String oid = this.getGroupOid("JvmMemory", "1.3.6.1.4.1.42.2.145.3.163.1.1.2");
        ObjectName objname = null;
        if (server != null) {
            objname = this.getGroupObjectName("JvmMemory", oid, this.mibName + ":name=sun.management.snmp.jvmmib.JvmMemory");
        }
        if ((meta = this.createJvmMemoryMetaNode("JvmMemory", oid, objname, server)) != null) {
            meta.registerTableNodes(this, server);
            JvmMemoryMBean group = (JvmMemoryMBean)this.createJvmMemoryMBean("JvmMemory", oid, objname, server);
            meta.setInstance(group);
            this.registerGroupNode("JvmMemory", oid, objname, meta, group, server);
        }
    }

    protected JvmMemoryMeta createJvmMemoryMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmMemoryMeta(this, this.objectserver);
    }

    protected abstract Object createJvmMemoryMBean(String var1, String var2, ObjectName var3, MBeanServer var4);

    protected void initJvmClassLoading(MBeanServer server) throws Exception {
        JvmClassLoadingMeta meta;
        String oid = this.getGroupOid("JvmClassLoading", "1.3.6.1.4.1.42.2.145.3.163.1.1.1");
        ObjectName objname = null;
        if (server != null) {
            objname = this.getGroupObjectName("JvmClassLoading", oid, this.mibName + ":name=sun.management.snmp.jvmmib.JvmClassLoading");
        }
        if ((meta = this.createJvmClassLoadingMetaNode("JvmClassLoading", oid, objname, server)) != null) {
            meta.registerTableNodes(this, server);
            JvmClassLoadingMBean group = (JvmClassLoadingMBean)this.createJvmClassLoadingMBean("JvmClassLoading", oid, objname, server);
            meta.setInstance(group);
            this.registerGroupNode("JvmClassLoading", oid, objname, meta, group, server);
        }
    }

    protected JvmClassLoadingMeta createJvmClassLoadingMetaNode(String groupName, String groupOid, ObjectName groupObjname, MBeanServer server) {
        return new JvmClassLoadingMeta(this, this.objectserver);
    }

    protected abstract Object createJvmClassLoadingMBean(String var1, String var2, ObjectName var3, MBeanServer var4);

    @Override
    public void registerTableMeta(String name, SnmpMibTable meta) {
        if (this.metadatas == null) {
            return;
        }
        if (name == null) {
            return;
        }
        this.metadatas.put(name, meta);
    }

    @Override
    public SnmpMibTable getRegisteredTableMeta(String name) {
        if (this.metadatas == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        return this.metadatas.get(name);
    }

    public SnmpStandardObjectServer getStandardObjectServer() {
        if (this.objectserver == null) {
            this.objectserver = new SnmpStandardObjectServer();
        }
        return this.objectserver;
    }
}

