/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpGauge;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardMetaServer;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmClassesVerboseLevel;
import sun.management.snmp.jvmmib.JvmClassLoadingMBean;

public class JvmClassLoadingMeta
extends SnmpMibGroup
implements Serializable,
SnmpStandardMetaServer {
    static final long serialVersionUID = 5722857476941218568L;
    protected JvmClassLoadingMBean node;
    protected SnmpStandardObjectServer objectserver = null;

    public JvmClassLoadingMeta(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        this.objectserver = objserv;
        try {
            this.registerObject(4L);
            this.registerObject(3L);
            this.registerObject(2L);
            this.registerObject(1L);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SnmpValue get(long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 4: {
                return new SnmpInt(this.node.getJvmClassesVerboseLevel());
            }
            case 3: {
                return new SnmpCounter64(this.node.getJvmClassesUnloadedCount());
            }
            case 2: {
                return new SnmpCounter64(this.node.getJvmClassesTotalLoadedCount());
            }
            case 1: {
                return new SnmpGauge(this.node.getJvmClassesLoadedCount());
            }
        }
        throw new SnmpStatusException(225);
    }

    @Override
    public SnmpValue set(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 4: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.setJvmClassesVerboseLevel(new EnumJvmClassesVerboseLevel(((SnmpInt)x).toInteger()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmClassesVerboseLevel());
                }
                throw new SnmpStatusException(7);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
        }
        throw new SnmpStatusException(17);
    }

    @Override
    public void check(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 4: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.checkJvmClassesVerboseLevel(new EnumJvmClassesVerboseLevel(((SnmpInt)x).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            default: {
                throw new SnmpStatusException(17);
            }
        }
    }

    protected void setInstance(JvmClassLoadingMBean var) {
        this.node = var;
    }

    @Override
    public void get(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.get(this, req, depth);
    }

    @Override
    public void set(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.set(this, req, depth);
    }

    @Override
    public void check(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.check(this, req, depth);
    }

    @Override
    public boolean isVariable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isReadable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean skipVariable(long var, Object data, int pduVersion) {
        switch ((int)var) {
            case 2: 
            case 3: {
                if (pduVersion != 0) break;
                return true;
            }
        }
        return super.skipVariable(var, data, pduVersion);
    }

    public String getAttributeName(long id) throws SnmpStatusException {
        switch ((int)id) {
            case 4: {
                return "JvmClassesVerboseLevel";
            }
            case 3: {
                return "JvmClassesUnloadedCount";
            }
            case 2: {
                return "JvmClassesTotalLoadedCount";
            }
            case 1: {
                return "JvmClassesLoadedCount";
            }
        }
        throw new SnmpStatusException(225);
    }

    @Override
    public boolean isTable(long arc) {
        switch ((int)arc) {
            default: 
        }
        return false;
    }

    @Override
    public SnmpMibTable getTable(long arc) {
        return null;
    }

    public void registerTableNodes(SnmpMib mib, MBeanServer server) {
    }
}

