/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import sun.management.snmp.jvmmib.JvmMemGCEntryMBean;
import sun.management.snmp.jvmmib.JvmMemGCEntryMeta;

public class JvmMemGCTableMeta
extends SnmpMibTable
implements Serializable {
    static final long serialVersionUID = -8843296871149264612L;
    private JvmMemGCEntryMeta node;
    protected SnmpStandardObjectServer objectserver;

    public JvmMemGCTableMeta(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib);
        this.objectserver = objserv;
    }

    protected JvmMemGCEntryMeta createJvmMemGCEntryMetaNode(String snmpEntryName, String tableName, SnmpMib mib, MBeanServer server) {
        return new JvmMemGCEntryMeta(mib, this.objectserver);
    }

    @Override
    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (this.factory == null) {
            throw new SnmpStatusException(6);
        }
        this.factory.createNewEntry(req, rowOid, depth, this);
    }

    @Override
    public boolean isRegistrationRequired() {
        return false;
    }

    public void registerEntryNode(SnmpMib mib, MBeanServer server) {
        this.node = this.createJvmMemGCEntryMetaNode("JvmMemGCEntry", "JvmMemGCTable", mib, server);
    }

    @Override
    public synchronized void addEntry(SnmpOid rowOid, ObjectName objname, Object entry) throws SnmpStatusException {
        if (!(entry instanceof JvmMemGCEntryMBean)) {
            throw new ClassCastException("Entries for Table \"JvmMemGCTable\" must implement the \"JvmMemGCEntryMBean\" interface.");
        }
        super.addEntry(rowOid, objname, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        JvmMemGCEntryMBean entry = (JvmMemGCEntryMBean)this.getEntry(rowOid);
        JvmMemGCTableMeta jvmMemGCTableMeta = this;
        synchronized (jvmMemGCTableMeta) {
            this.node.setInstance(entry);
            this.node.get(req, depth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (req.getSize() == 0) {
            return;
        }
        JvmMemGCEntryMBean entry = (JvmMemGCEntryMBean)this.getEntry(rowOid);
        JvmMemGCTableMeta jvmMemGCTableMeta = this;
        synchronized (jvmMemGCTableMeta) {
            this.node.setInstance(entry);
            this.node.set(req, depth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (req.getSize() == 0) {
            return;
        }
        JvmMemGCEntryMBean entry = (JvmMemGCEntryMBean)this.getEntry(rowOid);
        JvmMemGCTableMeta jvmMemGCTableMeta = this;
        synchronized (jvmMemGCTableMeta) {
            this.node.setInstance(entry);
            this.node.check(req, depth);
        }
    }

    @Override
    public void validateVarEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        this.node.validateVarId(var, data);
    }

    @Override
    public boolean isReadableEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        return this.node.isReadable(var);
    }

    @Override
    public long getNextVarEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        long nextvar = this.node.getNextVarId(var, data);
        while (!this.isReadableEntryId(rowOid, nextvar, data)) {
            nextvar = this.node.getNextVarId(nextvar, data);
        }
        return nextvar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean skipEntryVariable(SnmpOid rowOid, long var, Object data, int pduVersion) {
        try {
            JvmMemGCEntryMBean entry = (JvmMemGCEntryMBean)this.getEntry(rowOid);
            JvmMemGCTableMeta jvmMemGCTableMeta = this;
            synchronized (jvmMemGCTableMeta) {
                this.node.setInstance(entry);
                return this.node.skipVariable(var, data, pduVersion);
            }
        }
        catch (SnmpStatusException x) {
            return false;
        }
    }
}

