/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpGauge;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardMetaServer;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmMemoryGCCall;
import sun.management.snmp.jvmmib.EnumJvmMemoryGCVerboseLevel;
import sun.management.snmp.jvmmib.JvmMemGCTableMeta;
import sun.management.snmp.jvmmib.JvmMemManagerTableMeta;
import sun.management.snmp.jvmmib.JvmMemMgrPoolRelTableMeta;
import sun.management.snmp.jvmmib.JvmMemPoolTableMeta;
import sun.management.snmp.jvmmib.JvmMemoryMBean;

public class JvmMemoryMeta
extends SnmpMibGroup
implements Serializable,
SnmpStandardMetaServer {
    private static final long serialVersionUID = 9047644262627149214L;
    protected JvmMemoryMBean node;
    protected SnmpStandardObjectServer objectserver = null;
    protected JvmMemMgrPoolRelTableMeta tableJvmMemMgrPoolRelTable = null;
    protected JvmMemPoolTableMeta tableJvmMemPoolTable = null;
    protected JvmMemGCTableMeta tableJvmMemGCTable = null;
    protected JvmMemManagerTableMeta tableJvmMemManagerTable = null;

    public JvmMemoryMeta(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        this.objectserver = objserv;
        try {
            this.registerObject(120L);
            this.registerObject(23L);
            this.registerObject(22L);
            this.registerObject(21L);
            this.registerObject(110L);
            this.registerObject(20L);
            this.registerObject(13L);
            this.registerObject(12L);
            this.registerObject(3L);
            this.registerObject(11L);
            this.registerObject(2L);
            this.registerObject(101L);
            this.registerObject(10L);
            this.registerObject(1L);
            this.registerObject(100L);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SnmpValue get(long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 120: {
                throw new SnmpStatusException(224);
            }
            case 23: {
                return new SnmpCounter64(this.node.getJvmMemoryNonHeapMaxSize());
            }
            case 22: {
                return new SnmpCounter64(this.node.getJvmMemoryNonHeapCommitted());
            }
            case 21: {
                return new SnmpCounter64(this.node.getJvmMemoryNonHeapUsed());
            }
            case 110: {
                throw new SnmpStatusException(224);
            }
            case 20: {
                return new SnmpCounter64(this.node.getJvmMemoryNonHeapInitSize());
            }
            case 13: {
                return new SnmpCounter64(this.node.getJvmMemoryHeapMaxSize());
            }
            case 12: {
                return new SnmpCounter64(this.node.getJvmMemoryHeapCommitted());
            }
            case 3: {
                return new SnmpInt(this.node.getJvmMemoryGCCall());
            }
            case 11: {
                return new SnmpCounter64(this.node.getJvmMemoryHeapUsed());
            }
            case 2: {
                return new SnmpInt(this.node.getJvmMemoryGCVerboseLevel());
            }
            case 101: {
                throw new SnmpStatusException(224);
            }
            case 10: {
                return new SnmpCounter64(this.node.getJvmMemoryHeapInitSize());
            }
            case 1: {
                return new SnmpGauge(this.node.getJvmMemoryPendingFinalCount());
            }
            case 100: {
                throw new SnmpStatusException(224);
            }
        }
        throw new SnmpStatusException(225);
    }

    @Override
    public SnmpValue set(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 120: {
                throw new SnmpStatusException(17);
            }
            case 23: {
                throw new SnmpStatusException(17);
            }
            case 22: {
                throw new SnmpStatusException(17);
            }
            case 21: {
                throw new SnmpStatusException(17);
            }
            case 110: {
                throw new SnmpStatusException(17);
            }
            case 20: {
                throw new SnmpStatusException(17);
            }
            case 13: {
                throw new SnmpStatusException(17);
            }
            case 12: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.setJvmMemoryGCCall(new EnumJvmMemoryGCCall(((SnmpInt)x).toInteger()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmMemoryGCCall());
                }
                throw new SnmpStatusException(7);
            }
            case 11: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.setJvmMemoryGCVerboseLevel(new EnumJvmMemoryGCVerboseLevel(((SnmpInt)x).toInteger()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmMemoryGCVerboseLevel());
                }
                throw new SnmpStatusException(7);
            }
            case 101: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 100: {
                throw new SnmpStatusException(17);
            }
        }
        throw new SnmpStatusException(17);
    }

    @Override
    public void check(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 120: {
                throw new SnmpStatusException(17);
            }
            case 23: {
                throw new SnmpStatusException(17);
            }
            case 22: {
                throw new SnmpStatusException(17);
            }
            case 21: {
                throw new SnmpStatusException(17);
            }
            case 110: {
                throw new SnmpStatusException(17);
            }
            case 20: {
                throw new SnmpStatusException(17);
            }
            case 13: {
                throw new SnmpStatusException(17);
            }
            case 12: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.checkJvmMemoryGCCall(new EnumJvmMemoryGCCall(((SnmpInt)x).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 11: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.checkJvmMemoryGCVerboseLevel(new EnumJvmMemoryGCVerboseLevel(((SnmpInt)x).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 101: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 100: {
                throw new SnmpStatusException(17);
            }
            default: {
                throw new SnmpStatusException(17);
            }
        }
    }

    protected void setInstance(JvmMemoryMBean var) {
        this.node = var;
    }

    @Override
    public void get(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.get(this, req, depth);
    }

    @Override
    public void set(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.set(this, req, depth);
    }

    @Override
    public void check(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.check(this, req, depth);
    }

    @Override
    public boolean isVariable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isReadable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean skipVariable(long var, Object data, int pduVersion) {
        switch ((int)var) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (pduVersion != 0) break;
                return true;
            }
        }
        return super.skipVariable(var, data, pduVersion);
    }

    public String getAttributeName(long id) throws SnmpStatusException {
        switch ((int)id) {
            case 120: {
                throw new SnmpStatusException(224);
            }
            case 23: {
                return "JvmMemoryNonHeapMaxSize";
            }
            case 22: {
                return "JvmMemoryNonHeapCommitted";
            }
            case 21: {
                return "JvmMemoryNonHeapUsed";
            }
            case 110: {
                throw new SnmpStatusException(224);
            }
            case 20: {
                return "JvmMemoryNonHeapInitSize";
            }
            case 13: {
                return "JvmMemoryHeapMaxSize";
            }
            case 12: {
                return "JvmMemoryHeapCommitted";
            }
            case 3: {
                return "JvmMemoryGCCall";
            }
            case 11: {
                return "JvmMemoryHeapUsed";
            }
            case 2: {
                return "JvmMemoryGCVerboseLevel";
            }
            case 101: {
                throw new SnmpStatusException(224);
            }
            case 10: {
                return "JvmMemoryHeapInitSize";
            }
            case 1: {
                return "JvmMemoryPendingFinalCount";
            }
            case 100: {
                throw new SnmpStatusException(224);
            }
        }
        throw new SnmpStatusException(225);
    }

    @Override
    public boolean isTable(long arc) {
        switch ((int)arc) {
            case 120: {
                return true;
            }
            case 110: {
                return true;
            }
            case 101: {
                return true;
            }
            case 100: {
                return true;
            }
        }
        return false;
    }

    @Override
    public SnmpMibTable getTable(long arc) {
        switch ((int)arc) {
            case 120: {
                return this.tableJvmMemMgrPoolRelTable;
            }
            case 110: {
                return this.tableJvmMemPoolTable;
            }
            case 101: {
                return this.tableJvmMemGCTable;
            }
            case 100: {
                return this.tableJvmMemManagerTable;
            }
        }
        return null;
    }

    public void registerTableNodes(SnmpMib mib, MBeanServer server) {
        this.tableJvmMemMgrPoolRelTable = this.createJvmMemMgrPoolRelTableMetaNode("JvmMemMgrPoolRelTable", "JvmMemory", mib, server);
        if (this.tableJvmMemMgrPoolRelTable != null) {
            this.tableJvmMemMgrPoolRelTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmMemMgrPoolRelTable", this.tableJvmMemMgrPoolRelTable);
        }
        this.tableJvmMemPoolTable = this.createJvmMemPoolTableMetaNode("JvmMemPoolTable", "JvmMemory", mib, server);
        if (this.tableJvmMemPoolTable != null) {
            this.tableJvmMemPoolTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmMemPoolTable", this.tableJvmMemPoolTable);
        }
        this.tableJvmMemGCTable = this.createJvmMemGCTableMetaNode("JvmMemGCTable", "JvmMemory", mib, server);
        if (this.tableJvmMemGCTable != null) {
            this.tableJvmMemGCTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmMemGCTable", this.tableJvmMemGCTable);
        }
        this.tableJvmMemManagerTable = this.createJvmMemManagerTableMetaNode("JvmMemManagerTable", "JvmMemory", mib, server);
        if (this.tableJvmMemManagerTable != null) {
            this.tableJvmMemManagerTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmMemManagerTable", this.tableJvmMemManagerTable);
        }
    }

    protected JvmMemMgrPoolRelTableMeta createJvmMemMgrPoolRelTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmMemMgrPoolRelTableMeta(mib, this.objectserver);
    }

    protected JvmMemPoolTableMeta createJvmMemPoolTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmMemPoolTableMeta(mib, this.objectserver);
    }

    protected JvmMemGCTableMeta createJvmMemGCTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmMemGCTableMeta(mib, this.objectserver);
    }

    protected JvmMemManagerTableMeta createJvmMemManagerTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmMemManagerTableMeta(mib, this.objectserver);
    }
}

