/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpString;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardMetaServer;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.JvmRTBootClassPathTableMeta;
import sun.management.snmp.jvmmib.JvmRTClassPathTableMeta;
import sun.management.snmp.jvmmib.JvmRTInputArgsTableMeta;
import sun.management.snmp.jvmmib.JvmRTLibraryPathTableMeta;
import sun.management.snmp.jvmmib.JvmRuntimeMBean;

public class JvmRuntimeMeta
extends SnmpMibGroup
implements Serializable,
SnmpStandardMetaServer {
    static final long serialVersionUID = 1994595220765880109L;
    protected JvmRuntimeMBean node;
    protected SnmpStandardObjectServer objectserver = null;
    protected JvmRTLibraryPathTableMeta tableJvmRTLibraryPathTable = null;
    protected JvmRTClassPathTableMeta tableJvmRTClassPathTable = null;
    protected JvmRTBootClassPathTableMeta tableJvmRTBootClassPathTable = null;
    protected JvmRTInputArgsTableMeta tableJvmRTInputArgsTable = null;

    public JvmRuntimeMeta(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        this.objectserver = objserv;
        try {
            this.registerObject(23L);
            this.registerObject(22L);
            this.registerObject(21L);
            this.registerObject(9L);
            this.registerObject(20L);
            this.registerObject(8L);
            this.registerObject(7L);
            this.registerObject(6L);
            this.registerObject(5L);
            this.registerObject(4L);
            this.registerObject(3L);
            this.registerObject(12L);
            this.registerObject(11L);
            this.registerObject(2L);
            this.registerObject(1L);
            this.registerObject(10L);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SnmpValue get(long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 23: {
                throw new SnmpStatusException(224);
            }
            case 22: {
                throw new SnmpStatusException(224);
            }
            case 21: {
                throw new SnmpStatusException(224);
            }
            case 9: {
                return new SnmpInt(this.node.getJvmRTBootClassPathSupport());
            }
            case 20: {
                throw new SnmpStatusException(224);
            }
            case 8: {
                return new SnmpString(this.node.getJvmRTManagementSpecVersion());
            }
            case 7: {
                return new SnmpString(this.node.getJvmRTSpecVersion());
            }
            case 6: {
                return new SnmpString(this.node.getJvmRTSpecVendor());
            }
            case 5: {
                return new SnmpString(this.node.getJvmRTSpecName());
            }
            case 4: {
                return new SnmpString(this.node.getJvmRTVMVersion());
            }
            case 3: {
                return new SnmpString(this.node.getJvmRTVMVendor());
            }
            case 12: {
                return new SnmpCounter64(this.node.getJvmRTStartTimeMs());
            }
            case 11: {
                return new SnmpCounter64(this.node.getJvmRTUptimeMs());
            }
            case 2: {
                return new SnmpString(this.node.getJvmRTVMName());
            }
            case 1: {
                return new SnmpString(this.node.getJvmRTName());
            }
            case 10: {
                return new SnmpInt(this.node.getJvmRTInputArgsCount());
            }
        }
        throw new SnmpStatusException(225);
    }

    @Override
    public SnmpValue set(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 23: {
                throw new SnmpStatusException(17);
            }
            case 22: {
                throw new SnmpStatusException(17);
            }
            case 21: {
                throw new SnmpStatusException(17);
            }
            case 9: {
                throw new SnmpStatusException(17);
            }
            case 20: {
                throw new SnmpStatusException(17);
            }
            case 8: {
                throw new SnmpStatusException(17);
            }
            case 7: {
                throw new SnmpStatusException(17);
            }
            case 6: {
                throw new SnmpStatusException(17);
            }
            case 5: {
                throw new SnmpStatusException(17);
            }
            case 4: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 12: {
                throw new SnmpStatusException(17);
            }
            case 11: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
        }
        throw new SnmpStatusException(17);
    }

    @Override
    public void check(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 23: {
                throw new SnmpStatusException(17);
            }
            case 22: {
                throw new SnmpStatusException(17);
            }
            case 21: {
                throw new SnmpStatusException(17);
            }
            case 9: {
                throw new SnmpStatusException(17);
            }
            case 20: {
                throw new SnmpStatusException(17);
            }
            case 8: {
                throw new SnmpStatusException(17);
            }
            case 7: {
                throw new SnmpStatusException(17);
            }
            case 6: {
                throw new SnmpStatusException(17);
            }
            case 5: {
                throw new SnmpStatusException(17);
            }
            case 4: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 12: {
                throw new SnmpStatusException(17);
            }
            case 11: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
        }
        throw new SnmpStatusException(17);
    }

    protected void setInstance(JvmRuntimeMBean var) {
        this.node = var;
    }

    @Override
    public void get(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.get(this, req, depth);
    }

    @Override
    public void set(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.set(this, req, depth);
    }

    @Override
    public void check(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.check(this, req, depth);
    }

    @Override
    public boolean isVariable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isReadable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean skipVariable(long var, Object data, int pduVersion) {
        switch ((int)var) {
            case 11: 
            case 12: {
                if (pduVersion != 0) break;
                return true;
            }
        }
        return super.skipVariable(var, data, pduVersion);
    }

    public String getAttributeName(long id) throws SnmpStatusException {
        switch ((int)id) {
            case 23: {
                throw new SnmpStatusException(224);
            }
            case 22: {
                throw new SnmpStatusException(224);
            }
            case 21: {
                throw new SnmpStatusException(224);
            }
            case 9: {
                return "JvmRTBootClassPathSupport";
            }
            case 20: {
                throw new SnmpStatusException(224);
            }
            case 8: {
                return "JvmRTManagementSpecVersion";
            }
            case 7: {
                return "JvmRTSpecVersion";
            }
            case 6: {
                return "JvmRTSpecVendor";
            }
            case 5: {
                return "JvmRTSpecName";
            }
            case 4: {
                return "JvmRTVMVersion";
            }
            case 3: {
                return "JvmRTVMVendor";
            }
            case 12: {
                return "JvmRTStartTimeMs";
            }
            case 11: {
                return "JvmRTUptimeMs";
            }
            case 2: {
                return "JvmRTVMName";
            }
            case 1: {
                return "JvmRTName";
            }
            case 10: {
                return "JvmRTInputArgsCount";
            }
        }
        throw new SnmpStatusException(225);
    }

    @Override
    public boolean isTable(long arc) {
        switch ((int)arc) {
            case 23: {
                return true;
            }
            case 22: {
                return true;
            }
            case 21: {
                return true;
            }
            case 20: {
                return true;
            }
        }
        return false;
    }

    @Override
    public SnmpMibTable getTable(long arc) {
        switch ((int)arc) {
            case 23: {
                return this.tableJvmRTLibraryPathTable;
            }
            case 22: {
                return this.tableJvmRTClassPathTable;
            }
            case 21: {
                return this.tableJvmRTBootClassPathTable;
            }
            case 20: {
                return this.tableJvmRTInputArgsTable;
            }
        }
        return null;
    }

    public void registerTableNodes(SnmpMib mib, MBeanServer server) {
        this.tableJvmRTLibraryPathTable = this.createJvmRTLibraryPathTableMetaNode("JvmRTLibraryPathTable", "JvmRuntime", mib, server);
        if (this.tableJvmRTLibraryPathTable != null) {
            this.tableJvmRTLibraryPathTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmRTLibraryPathTable", this.tableJvmRTLibraryPathTable);
        }
        this.tableJvmRTClassPathTable = this.createJvmRTClassPathTableMetaNode("JvmRTClassPathTable", "JvmRuntime", mib, server);
        if (this.tableJvmRTClassPathTable != null) {
            this.tableJvmRTClassPathTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmRTClassPathTable", this.tableJvmRTClassPathTable);
        }
        this.tableJvmRTBootClassPathTable = this.createJvmRTBootClassPathTableMetaNode("JvmRTBootClassPathTable", "JvmRuntime", mib, server);
        if (this.tableJvmRTBootClassPathTable != null) {
            this.tableJvmRTBootClassPathTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmRTBootClassPathTable", this.tableJvmRTBootClassPathTable);
        }
        this.tableJvmRTInputArgsTable = this.createJvmRTInputArgsTableMetaNode("JvmRTInputArgsTable", "JvmRuntime", mib, server);
        if (this.tableJvmRTInputArgsTable != null) {
            this.tableJvmRTInputArgsTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmRTInputArgsTable", this.tableJvmRTInputArgsTable);
        }
    }

    protected JvmRTLibraryPathTableMeta createJvmRTLibraryPathTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmRTLibraryPathTableMeta(mib, this.objectserver);
    }

    protected JvmRTClassPathTableMeta createJvmRTClassPathTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmRTClassPathTableMeta(mib, this.objectserver);
    }

    protected JvmRTBootClassPathTableMeta createJvmRTBootClassPathTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmRTBootClassPathTableMeta(mib, this.objectserver);
    }

    protected JvmRTInputArgsTableMeta createJvmRTInputArgsTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmRTInputArgsTableMeta(mib, this.objectserver);
    }
}

