/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.SnmpCounter;
import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpGauge;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardMetaServer;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmThreadContentionMonitoring;
import sun.management.snmp.jvmmib.EnumJvmThreadCpuTimeMonitoring;
import sun.management.snmp.jvmmib.JvmThreadInstanceTableMeta;
import sun.management.snmp.jvmmib.JvmThreadingMBean;

public class JvmThreadingMeta
extends SnmpMibGroup
implements Serializable,
SnmpStandardMetaServer {
    static final long serialVersionUID = 5223833578005322854L;
    protected JvmThreadingMBean node;
    protected SnmpStandardObjectServer objectserver = null;
    protected JvmThreadInstanceTableMeta tableJvmThreadInstanceTable = null;

    public JvmThreadingMeta(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        this.objectserver = objserv;
        try {
            this.registerObject(6L);
            this.registerObject(5L);
            this.registerObject(4L);
            this.registerObject(3L);
            this.registerObject(2L);
            this.registerObject(1L);
            this.registerObject(10L);
            this.registerObject(7L);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SnmpValue get(long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 6: {
                return new SnmpInt(this.node.getJvmThreadCpuTimeMonitoring());
            }
            case 5: {
                return new SnmpInt(this.node.getJvmThreadContentionMonitoring());
            }
            case 4: {
                return new SnmpCounter64(this.node.getJvmThreadTotalStartedCount());
            }
            case 3: {
                return new SnmpCounter(this.node.getJvmThreadPeakCount());
            }
            case 2: {
                return new SnmpGauge(this.node.getJvmThreadDaemonCount());
            }
            case 1: {
                return new SnmpGauge(this.node.getJvmThreadCount());
            }
            case 10: {
                throw new SnmpStatusException(224);
            }
            case 7: {
                return new SnmpCounter64(this.node.getJvmThreadPeakCountReset());
            }
        }
        throw new SnmpStatusException(225);
    }

    @Override
    public SnmpValue set(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 6: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.setJvmThreadCpuTimeMonitoring(new EnumJvmThreadCpuTimeMonitoring(((SnmpInt)x).toInteger()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmThreadCpuTimeMonitoring());
                }
                throw new SnmpStatusException(7);
            }
            case 5: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.setJvmThreadContentionMonitoring(new EnumJvmThreadContentionMonitoring(((SnmpInt)x).toInteger()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmThreadContentionMonitoring());
                }
                throw new SnmpStatusException(7);
            }
            case 4: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
            case 7: {
                if (x instanceof SnmpCounter64) {
                    this.node.setJvmThreadPeakCountReset(((SnmpCounter64)x).toLong());
                    return new SnmpCounter64(this.node.getJvmThreadPeakCountReset());
                }
                throw new SnmpStatusException(7);
            }
        }
        throw new SnmpStatusException(17);
    }

    @Override
    public void check(SnmpValue x, long var, Object data) throws SnmpStatusException {
        switch ((int)var) {
            case 6: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.checkJvmThreadCpuTimeMonitoring(new EnumJvmThreadCpuTimeMonitoring(((SnmpInt)x).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 5: {
                if (x instanceof SnmpInt) {
                    try {
                        this.node.checkJvmThreadContentionMonitoring(new EnumJvmThreadContentionMonitoring(((SnmpInt)x).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 4: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
            case 7: {
                if (x instanceof SnmpCounter64) {
                    this.node.checkJvmThreadPeakCountReset(((SnmpCounter64)x).toLong());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            default: {
                throw new SnmpStatusException(17);
            }
        }
    }

    protected void setInstance(JvmThreadingMBean var) {
        this.node = var;
    }

    @Override
    public void get(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.get(this, req, depth);
    }

    @Override
    public void set(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.set(this, req, depth);
    }

    @Override
    public void check(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        this.objectserver.check(this, req, depth);
    }

    @Override
    public boolean isVariable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isReadable(long arc) {
        switch ((int)arc) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean skipVariable(long var, Object data, int pduVersion) {
        switch ((int)var) {
            case 4: 
            case 7: {
                if (pduVersion != 0) break;
                return true;
            }
        }
        return super.skipVariable(var, data, pduVersion);
    }

    public String getAttributeName(long id) throws SnmpStatusException {
        switch ((int)id) {
            case 6: {
                return "JvmThreadCpuTimeMonitoring";
            }
            case 5: {
                return "JvmThreadContentionMonitoring";
            }
            case 4: {
                return "JvmThreadTotalStartedCount";
            }
            case 3: {
                return "JvmThreadPeakCount";
            }
            case 2: {
                return "JvmThreadDaemonCount";
            }
            case 1: {
                return "JvmThreadCount";
            }
            case 10: {
                throw new SnmpStatusException(224);
            }
            case 7: {
                return "JvmThreadPeakCountReset";
            }
        }
        throw new SnmpStatusException(225);
    }

    @Override
    public boolean isTable(long arc) {
        switch ((int)arc) {
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public SnmpMibTable getTable(long arc) {
        switch ((int)arc) {
            case 10: {
                return this.tableJvmThreadInstanceTable;
            }
        }
        return null;
    }

    public void registerTableNodes(SnmpMib mib, MBeanServer server) {
        this.tableJvmThreadInstanceTable = this.createJvmThreadInstanceTableMetaNode("JvmThreadInstanceTable", "JvmThreading", mib, server);
        if (this.tableJvmThreadInstanceTable != null) {
            this.tableJvmThreadInstanceTable.registerEntryNode(mib, server);
            mib.registerTableMeta("JvmThreadInstanceTable", this.tableJvmThreadInstanceTable);
        }
    }

    protected JvmThreadInstanceTableMeta createJvmThreadInstanceTableMetaNode(String tableName, String groupName, SnmpMib mib, MBeanServer server) {
        return new JvmThreadInstanceTableMeta(mib, this.objectserver);
    }
}

