/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class MibLogger {
    final Logger logger;
    final String className;

    static String getClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return MibLogger.getClassName(clazz.getComponentType()) + "[]";
        }
        String fullname = clazz.getName();
        int lastpoint = fullname.lastIndexOf(46);
        int len = fullname.length();
        if (lastpoint < 0 || lastpoint >= len) {
            return fullname;
        }
        return fullname.substring(lastpoint + 1, len);
    }

    static String getLoggerName(Class<?> clazz) {
        if (clazz == null) {
            return "sun.management.snmp.jvminstr";
        }
        Package p = clazz.getPackage();
        if (p == null) {
            return "sun.management.snmp.jvminstr";
        }
        String pname = p.getName();
        if (pname == null) {
            return "sun.management.snmp.jvminstr";
        }
        return pname;
    }

    public MibLogger(Class<?> clazz) {
        this(MibLogger.getLoggerName(clazz), MibLogger.getClassName(clazz));
    }

    public MibLogger(Class<?> clazz, String postfix) {
        this(MibLogger.getLoggerName(clazz) + (postfix == null ? "" : "." + postfix), MibLogger.getClassName(clazz));
    }

    public MibLogger(String className) {
        this("sun.management.snmp.jvminstr", className);
    }

    public MibLogger(String loggerName, String className) {
        Logger l = null;
        try {
            l = Logger.getLogger(loggerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger = l;
        this.className = className;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public boolean isTraceOn() {
        Logger l = this.getLogger();
        if (l == null) {
            return false;
        }
        return l.isLoggable(Level.FINE);
    }

    public boolean isDebugOn() {
        Logger l = this.getLogger();
        if (l == null) {
            return false;
        }
        return l.isLoggable(Level.FINEST);
    }

    public boolean isInfoOn() {
        Logger l = this.getLogger();
        if (l == null) {
            return false;
        }
        return l.isLoggable(Level.INFO);
    }

    public boolean isConfigOn() {
        Logger l = this.getLogger();
        if (l == null) {
            return false;
        }
        return l.isLoggable(Level.CONFIG);
    }

    public void config(String func, String msg) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.CONFIG, this.className, func, msg);
        }
    }

    public void config(String func, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.CONFIG, this.className, func, t.toString(), t);
        }
    }

    public void config(String func, String msg, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.CONFIG, this.className, func, msg, t);
        }
    }

    public void error(String func, String msg) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.SEVERE, this.className, func, msg);
        }
    }

    public void info(String func, String msg) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.INFO, this.className, func, msg);
        }
    }

    public void info(String func, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.INFO, this.className, func, t.toString(), t);
        }
    }

    public void info(String func, String msg, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.INFO, this.className, func, msg, t);
        }
    }

    public void warning(String func, String msg) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.WARNING, this.className, func, msg);
        }
    }

    public void warning(String func, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.WARNING, this.className, func, t.toString(), t);
        }
    }

    public void warning(String func, String msg, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.WARNING, this.className, func, msg, t);
        }
    }

    public void trace(String func, String msg) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.FINE, this.className, func, msg);
        }
    }

    public void trace(String func, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.FINE, this.className, func, t.toString(), t);
        }
    }

    public void trace(String func, String msg, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.FINE, this.className, func, msg, t);
        }
    }

    public void debug(String func, String msg) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.FINEST, this.className, func, msg);
        }
    }

    public void debug(String func, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.FINEST, this.className, func, t.toString(), t);
        }
    }

    public void debug(String func, String msg, Throwable t) {
        Logger l = this.getLogger();
        if (l != null) {
            l.logp(Level.FINEST, this.className, func, msg, t);
        }
    }
}

