/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.util;

import com.sun.jmx.snmp.SnmpOid;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import sun.management.snmp.util.SnmpTableHandler;

public class SnmpCachedData
implements SnmpTableHandler {
    public static final Comparator<SnmpOid> oidComparator = new Comparator<SnmpOid>(){

        @Override
        public int compare(SnmpOid o1, SnmpOid o2) {
            return o1.compareTo(o2);
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            return o1.equals(o2);
        }
    };
    public final long lastUpdated;
    public final SnmpOid[] indexes;
    public final Object[] datas;

    public SnmpCachedData(long lastUpdated, SnmpOid[] indexes, Object[] datas) {
        this.lastUpdated = lastUpdated;
        this.indexes = indexes;
        this.datas = datas;
    }

    public SnmpCachedData(long lastUpdated, TreeMap<SnmpOid, Object> indexMap) {
        this(lastUpdated, indexMap, true);
    }

    public SnmpCachedData(long lastUpdated, TreeMap<SnmpOid, Object> indexMap, boolean b) {
        int size = indexMap.size();
        this.lastUpdated = lastUpdated;
        this.indexes = new SnmpOid[size];
        this.datas = new Object[size];
        if (b) {
            indexMap.keySet().toArray(this.indexes);
            indexMap.values().toArray(this.datas);
        } else {
            indexMap.values().toArray(this.datas);
        }
    }

    public final int find(SnmpOid index) {
        return Arrays.binarySearch(this.indexes, index, oidComparator);
    }

    @Override
    public Object getData(SnmpOid index) {
        int pos = this.find(index);
        if (pos < 0 || pos >= this.datas.length) {
            return null;
        }
        return this.datas[pos];
    }

    @Override
    public SnmpOid getNext(SnmpOid index) {
        if (index == null) {
            if (this.indexes.length > 0) {
                return this.indexes[0];
            }
            return null;
        }
        int pos = this.find(index);
        if (pos > -1) {
            if (pos < this.indexes.length - 1) {
                return this.indexes[pos + 1];
            }
            return null;
        }
        int insertion = -pos - 1;
        if (insertion > -1 && insertion < this.indexes.length) {
            return this.indexes[insertion];
        }
        return null;
    }

    @Override
    public boolean contains(SnmpOid index) {
        int pos = this.find(index);
        return pos > -1 && pos < this.indexes.length;
    }
}

