/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.util;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpListTableCache;

public abstract class SnmpNamedListTableCache
extends SnmpListTableCache {
    protected TreeMap<String, SnmpOid> names = new TreeMap();
    protected long last = 0L;
    boolean wrapped = false;
    static final MibLogger log = new MibLogger(SnmpNamedListTableCache.class);

    protected abstract String getKey(Object var1, List<?> var2, int var3, Object var4);

    protected SnmpOid makeIndex(Object context, List<?> rawDatas, int rank, Object item) {
        if (++this.last > 0xFFFFFFFFL) {
            log.debug("makeIndex", "Index wrapping...");
            this.last = 0L;
            this.wrapped = true;
        }
        if (!this.wrapped) {
            return new SnmpOid(this.last);
        }
        int i = 1;
        while ((long)i < 0xFFFFFFFFL) {
            if (++this.last > 0xFFFFFFFFL) {
                this.last = 1L;
            }
            SnmpOid testOid = new SnmpOid(this.last);
            if (this.names == null) {
                return testOid;
            }
            if (!this.names.containsValue(testOid)) {
                if (context == null) {
                    return testOid;
                }
                if (!((Map)context).containsValue(testOid)) {
                    return testOid;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    protected SnmpOid getIndex(Object context, List<?> rawDatas, int rank, Object item) {
        SnmpOid result;
        String key = this.getKey(context, rawDatas, rank, item);
        SnmpOid index = this.names == null || key == null ? null : this.names.get(key);
        SnmpOid snmpOid = result = index != null ? index : this.makeIndex(context, rawDatas, rank, item);
        if (context != null && key != null && result != null) {
            Map map = (Map)Util.cast(context);
            map.put(key, result);
        }
        log.debug("getIndex", "key=" + key + ", index=" + result);
        return result;
    }

    @Override
    protected SnmpCachedData updateCachedDatas(Object context, List<?> rawDatas) {
        TreeMap ctxt = new TreeMap();
        SnmpCachedData result = super.updateCachedDatas(context, rawDatas);
        this.names = ctxt;
        return result;
    }

    protected abstract List<?> loadRawDatas(Map<Object, Object> var1);

    protected abstract String getRawDatasKey();

    protected List<?> getRawDatas(Map<Object, Object> userData, String key) {
        List<?> rawDatas = null;
        if (userData != null) {
            rawDatas = (List<?>)userData.get(key);
        }
        if (rawDatas == null && (rawDatas = this.loadRawDatas(userData)) != null && userData != null) {
            userData.put(key, rawDatas);
        }
        return rawDatas;
    }

    @Override
    protected SnmpCachedData updateCachedDatas(Object context) {
        Map userData = context instanceof Map ? (Map)Util.cast(context) : null;
        List<?> rawDatas = this.getRawDatas(userData, this.getRawDatasKey());
        log.debug("updateCachedDatas", "rawDatas.size()=" + (rawDatas == null ? "<no data>" : "" + rawDatas.size()));
        TreeMap ctxt = new TreeMap();
        SnmpCachedData result = super.updateCachedDatas(ctxt, rawDatas);
        this.names = ctxt;
        return result;
    }
}

