/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    public static byte[] readExactlyNBytes(InputStream is, int length) throws IOException {
        byte[] data = IOUtils.readNBytesOrEOF(is, length);
        if (data.length < length) {
            throw new EOFException();
        }
        return data;
    }

    public static byte[] readNBytesOrEOF(InputStream is, int len) throws IOException {
        int n;
        if (len < 0) {
            throw new IOException("length cannot be negative: " + len);
        }
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while ((n = is.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    public static byte[] readFully(InputStream is, int length, boolean readAll) throws IOException {
        int cc;
        byte[] output = new byte[]{};
        if (length == -1) {
            length = Integer.MAX_VALUE;
        }
        for (int pos = 0; pos < length; pos += cc) {
            int bytesToRead;
            if (pos >= output.length) {
                bytesToRead = Math.min(length - pos, output.length + 1024);
                if (output.length < pos + bytesToRead) {
                    output = Arrays.copyOf(output, pos + bytesToRead);
                }
            } else {
                bytesToRead = output.length - pos;
            }
            if ((cc = is.read(output, pos, bytesToRead)) >= 0) continue;
            if (readAll && length != Integer.MAX_VALUE) {
                throw new EOFException("Detect premature EOF");
            }
            if (output.length == pos) break;
            output = Arrays.copyOf(output, pos);
            break;
        }
        return output;
    }

    public static byte[] readNBytes(InputStream is, int length) throws IOException {
        if (length < 0) {
            throw new IOException("length cannot be negative: " + length);
        }
        return IOUtils.readFully(is, length, true);
    }
}

