/*
 * Decompiled with CFR 0.152.
 */
package sun.net.util;

import java.net.URL;
import java.nio.CharBuffer;
import java.util.Arrays;
import sun.security.action.GetPropertyAction;

public class IPAddressUtil {
    private static final int INADDR4SZ = 4;
    private static final int INADDR16SZ = 16;
    private static final int INT16SZ = 2;
    private static final long L_IPV6_DELIMS = 0L;
    private static final long H_IPV6_DELIMS = 0x28000000L;
    private static final long L_GEN_DELIMS = -8935000888854970368L;
    private static final long H_GEN_DELIMS = 671088641L;
    private static final long L_AUTH_DELIMS = 0x400000000000000L;
    private static final long H_AUTH_DELIMS = 671088641L;
    private static final long L_COLON = 0x400000000000000L;
    private static final long H_COLON = 0L;
    private static final long L_SLASH = 0x800000000000L;
    private static final long H_SLASH = 0L;
    private static final long L_BACKSLASH = 0L;
    private static final long H_BACKSLASH = 0x10000000L;
    private static final long L_NON_PRINTABLE = 0xFFFFFFFFL;
    private static final long H_NON_PRINTABLE = Long.MIN_VALUE;
    private static final long L_EXCLUDE = -8935000884560003073L;
    private static final long H_EXCLUDE = -9223372035915251711L;
    private static final char[] OTHERS = new char[]{'\u2047', '\u2048', '\u2049', '\u2100', '\u2101', '\u2105', '\u2106', '\u2a74', '\ufe55', '\ufe56', '\ufe5f', '\ufe6b', '\uff03', '\uff0f', '\uff1a', '\uff1f', '\uff20'};
    private static final int HEXADECIMAL = 16;
    private static final int DECIMAL = 10;
    private static final int OCTAL = 8;
    private static final int[] SUPPORTED_RADIXES = new int[]{16, 8, 10};
    private static final long CANT_PARSE_IN_RADIX = -1L;
    private static final long TERMINAL_PARSE_ERROR = -2L;
    private static final String ALLOW_AMBIGUOUS_IPADDRESS_LITERALS_SP = "jdk.net.allowAmbiguousIPAddressLiterals";
    private static final boolean ALLOW_AMBIGUOUS_IPADDRESS_LITERALS_SP_VALUE = Boolean.valueOf(GetPropertyAction.privilegedGetProperty("jdk.net.allowAmbiguousIPAddressLiterals", "false"));

    public static byte[] textToNumericFormatV4(String src) {
        byte[] res = new byte[4];
        long tmpValue = 0L;
        int currByte = 0;
        boolean newOctet = true;
        int len = src.length();
        if (len == 0 || len > 15) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == '.') {
                if (newOctet || tmpValue < 0L || tmpValue > 255L || currByte == 3) {
                    return null;
                }
                res[currByte++] = (byte)(tmpValue & 0xFFL);
                tmpValue = 0L;
                newOctet = true;
                continue;
            }
            int digit = IPAddressUtil.digit(c, 10);
            if (digit < 0) {
                return null;
            }
            tmpValue *= 10L;
            tmpValue += (long)digit;
            newOctet = false;
        }
        if (newOctet || tmpValue < 0L || tmpValue >= 1L << (4 - currByte) * 8) {
            return null;
        }
        switch (currByte) {
            case 0: {
                res[0] = (byte)(tmpValue >> 24 & 0xFFL);
            }
            case 1: {
                res[1] = (byte)(tmpValue >> 16 & 0xFFL);
            }
            case 2: {
                res[2] = (byte)(tmpValue >> 8 & 0xFFL);
            }
            case 3: {
                res[3] = (byte)(tmpValue >> 0 & 0xFFL);
            }
        }
        return res;
    }

    public static byte[] validateNumericFormatV4(String src) {
        byte[] parsedBytes = IPAddressUtil.textToNumericFormatV4(src);
        if (!ALLOW_AMBIGUOUS_IPADDRESS_LITERALS_SP_VALUE && parsedBytes == null && IPAddressUtil.isBsdParsableV4(src)) {
            throw new IllegalArgumentException("Invalid IP address literal: " + src);
        }
        return parsedBytes;
    }

    public static byte[] textToNumericFormatV6(String src) {
        if (src.length() < 2) {
            return null;
        }
        char[] srcb = src.toCharArray();
        byte[] dst = new byte[16];
        int srcb_length = srcb.length;
        int pc = src.indexOf("%");
        if (pc == srcb_length - 1) {
            return null;
        }
        if (pc != -1) {
            srcb_length = pc;
        }
        int colonp = -1;
        int i = 0;
        int j = 0;
        if (srcb[i] == ':' && srcb[++i] != ':') {
            return null;
        }
        int curtok = i;
        boolean saw_xdigit = false;
        int val = 0;
        while (i < srcb_length) {
            char ch;
            int chval;
            if ((chval = IPAddressUtil.digit(ch = srcb[i++], 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return null;
                }
                saw_xdigit = true;
                continue;
            }
            if (ch == ':') {
                curtok = i;
                if (!saw_xdigit) {
                    if (colonp != -1) {
                        return null;
                    }
                    colonp = j;
                    continue;
                }
                if (i == srcb_length) {
                    return null;
                }
                if (j + 2 > 16) {
                    return null;
                }
                dst[j++] = (byte)(val >> 8 & 0xFF);
                dst[j++] = (byte)(val & 0xFF);
                saw_xdigit = false;
                val = 0;
                continue;
            }
            if (ch == '.' && j + 4 <= 16) {
                String ia4 = src.substring(curtok, srcb_length);
                int dot_count = 0;
                int index = 0;
                while ((index = ia4.indexOf(46, index)) != -1) {
                    ++dot_count;
                    ++index;
                }
                if (dot_count != 3) {
                    return null;
                }
                byte[] v4addr = IPAddressUtil.textToNumericFormatV4(ia4);
                if (v4addr == null) {
                    return null;
                }
                for (int k = 0; k < 4; ++k) {
                    dst[j++] = v4addr[k];
                }
                saw_xdigit = false;
                break;
            }
            return null;
        }
        if (saw_xdigit) {
            if (j + 2 > 16) {
                return null;
            }
            dst[j++] = (byte)(val >> 8 & 0xFF);
            dst[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            int n = j - colonp;
            if (j == 16) {
                return null;
            }
            for (i = 1; i <= n; ++i) {
                dst[16 - i] = dst[colonp + n - i];
                dst[colonp + n - i] = 0;
            }
            j = 16;
        }
        if (j != 16) {
            return null;
        }
        byte[] newdst = IPAddressUtil.convertFromIPv4MappedAddress(dst);
        if (newdst != null) {
            return newdst;
        }
        return dst;
    }

    public static boolean isIPv4LiteralAddress(String src) {
        return IPAddressUtil.textToNumericFormatV4(src) != null;
    }

    public static boolean isIPv6LiteralAddress(String src) {
        return IPAddressUtil.textToNumericFormatV6(src) != null;
    }

    public static byte[] convertFromIPv4MappedAddress(byte[] addr) {
        if (IPAddressUtil.isIPv4MappedAddress(addr)) {
            byte[] newAddr = new byte[4];
            System.arraycopy(addr, 12, newAddr, 0, 4);
            return newAddr;
        }
        return null;
    }

    private static boolean isIPv4MappedAddress(byte[] addr) {
        if (addr.length < 16) {
            return false;
        }
        return addr[0] == 0 && addr[1] == 0 && addr[2] == 0 && addr[3] == 0 && addr[4] == 0 && addr[5] == 0 && addr[6] == 0 && addr[7] == 0 && addr[8] == 0 && addr[9] == 0 && addr[10] == -1 && addr[11] == -1;
    }

    public static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    public static int scan(String s, long lowMask, long highMask) {
        int len;
        int i = -1;
        if (s == null || (len = s.length()) == 0) {
            return -1;
        }
        boolean match = false;
        while (++i < len && !(match = IPAddressUtil.match(s.charAt(i), lowMask, highMask))) {
        }
        if (match) {
            return i;
        }
        return -1;
    }

    public static int scan(String s, long lowMask, long highMask, char[] others) {
        char c;
        int len;
        int i = -1;
        if (s == null || (len = s.length()) == 0) {
            return -1;
        }
        boolean match = false;
        char c0 = others[0];
        while (++i < len && !(match = IPAddressUtil.match(c = s.charAt(i), lowMask, highMask))) {
            if (c < c0 || Arrays.binarySearch(others, c) <= -1) continue;
            match = true;
            break;
        }
        if (match) {
            return i;
        }
        return -1;
    }

    private static String describeChar(char c) {
        if (c < ' ' || c == '\u007f') {
            if (c == '\n') {
                return "LF";
            }
            if (c == '\r') {
                return "CR";
            }
            return "control char (code=" + c + ")";
        }
        if (c == '\\') {
            return "'\\'";
        }
        return "'" + c + "'";
    }

    private static String checkUserInfo(String str) {
        int index = IPAddressUtil.scan(str, -9223231260711714817L, -9223372035915251711L);
        if (index >= 0) {
            return "Illegal character found in user-info: " + IPAddressUtil.describeChar(str.charAt(index));
        }
        return null;
    }

    private static String checkHost(String str) {
        if (str.startsWith("[") && str.endsWith("]")) {
            if (IPAddressUtil.isIPv6LiteralAddress(str = str.substring(1, str.length() - 1))) {
                int index = str.indexOf(37);
                if (index >= 0 && (index = IPAddressUtil.scan(str = str.substring(index), 0xFFFFFFFFL, -9223372036183687168L)) >= 0) {
                    return "Illegal character found in IPv6 scoped address: " + IPAddressUtil.describeChar(str.charAt(index));
                }
                return null;
            }
            return "Unrecognized IPv6 address format";
        }
        int index = IPAddressUtil.scan(str, -8935000884560003073L, -9223372035915251711L);
        if (index >= 0) {
            return "Illegal character found in host: " + IPAddressUtil.describeChar(str.charAt(index));
        }
        return null;
    }

    private static String checkAuth(String str) {
        int index = IPAddressUtil.scan(str, -9223231260711714817L, -9223372036586340352L);
        if (index >= 0) {
            return "Illegal character found in authority: " + IPAddressUtil.describeChar(str.charAt(index));
        }
        return null;
    }

    public static String checkAuthority(URL url) {
        if (url == null) {
            return null;
        }
        String u = url.getUserInfo();
        String s = IPAddressUtil.checkUserInfo(u);
        if (s != null) {
            return s;
        }
        String h = url.getHost();
        s = IPAddressUtil.checkHost(h);
        if (s != null) {
            return s;
        }
        if (h == null && u == null) {
            return IPAddressUtil.checkAuth(url.getAuthority());
        }
        return null;
    }

    public static String checkExternalForm(URL url) {
        if (url == null) {
            return null;
        }
        String s = url.getUserInfo();
        int index = IPAddressUtil.scan(s, 0x8000FFFFFFFFL, Long.MIN_VALUE);
        if (index >= 0) {
            return "Illegal character found in authority: " + IPAddressUtil.describeChar(s.charAt(index));
        }
        s = IPAddressUtil.checkHostString(url.getHost());
        if (s != null) {
            return s;
        }
        return null;
    }

    public static String checkHostString(String host) {
        if (host == null) {
            return null;
        }
        int index = IPAddressUtil.scan(host, 0x8000FFFFFFFFL, Long.MIN_VALUE, OTHERS);
        if (index >= 0) {
            return "Illegal character found in host: " + IPAddressUtil.describeChar(host.charAt(index));
        }
        return null;
    }

    public static int digit(char ch, int radix) {
        if (ALLOW_AMBIGUOUS_IPADDRESS_LITERALS_SP_VALUE) {
            return Character.digit(ch, radix);
        }
        return IPAddressUtil.parseAsciiDigit(ch, radix);
    }

    public static boolean isBsdParsableV4(String input) {
        char firstSymbol = input.charAt(0);
        if (IPAddressUtil.parseAsciiDigit(firstSymbol, 10) == -1) {
            return false;
        }
        char lastSymbol = input.charAt(input.length() - 1);
        if (lastSymbol == '.' || IPAddressUtil.parseAsciiHexDigit(lastSymbol) == -1) {
            return false;
        }
        CharBuffer charBuffer = CharBuffer.wrap(input);
        int fieldNumber = 0;
        while (charBuffer.hasRemaining()) {
            long fieldValue = -1L;
            for (int radix : SUPPORTED_RADIXES) {
                fieldValue = IPAddressUtil.parseV4FieldBsd(radix, charBuffer, fieldNumber);
                if (fieldValue >= 0L) {
                    ++fieldNumber;
                    break;
                }
                if (fieldValue != -2L) continue;
                return false;
            }
            if (fieldValue >= 0L) continue;
            return false;
        }
        return true;
    }

    private static long parseV4FieldBsd(int radix, CharBuffer buffer, int fieldNumber) {
        long maxValue;
        int initialPos = buffer.position();
        long val = 0L;
        int digitsCount = 0;
        if (!IPAddressUtil.checkPrefix(buffer, radix)) {
            val = -1L;
        }
        boolean dotSeen = false;
        while (buffer.hasRemaining() && val != -1L && !dotSeen) {
            char c = buffer.get();
            if (c == '.') {
                dotSeen = true;
                if (fieldNumber == 3) {
                    return -2L;
                }
                if (digitsCount == 0) {
                    return -2L;
                }
                if (val <= 255L) continue;
                return -2L;
            }
            int dv = IPAddressUtil.parseAsciiDigit(c, radix);
            if (dv >= 0) {
                ++digitsCount;
                val *= (long)radix;
                val += (long)dv;
                continue;
            }
            return -2L;
        }
        if (val == -1L) {
            buffer.position(initialPos);
        } else if (!dotSeen && val > (maxValue = (1L << (4 - fieldNumber) * 8) - 1L)) {
            return -2L;
        }
        return val;
    }

    private static boolean checkPrefix(CharBuffer buffer, int radix) {
        switch (radix) {
            case 8: {
                return IPAddressUtil.isOctalFieldStart(buffer);
            }
            case 10: {
                return IPAddressUtil.isDecimalFieldStart(buffer);
            }
            case 16: {
                return IPAddressUtil.isHexFieldStart(buffer);
            }
        }
        throw new AssertionError((Object)"Not supported radix");
    }

    private static boolean isOctalFieldStart(CharBuffer cb) {
        boolean isOctalPrefix;
        if (cb.remaining() < 2) {
            return false;
        }
        int position = cb.position();
        char first = cb.get();
        char second = cb.get();
        boolean bl = isOctalPrefix = first == '0' && second != '.';
        if (isOctalPrefix) {
            cb.position(position + 1);
        }
        return isOctalPrefix;
    }

    private static boolean isDecimalFieldStart(CharBuffer cb) {
        return cb.hasRemaining();
    }

    private static boolean isHexFieldStart(CharBuffer cb) {
        if (cb.remaining() < 2) {
            return false;
        }
        char first = cb.get();
        char second = cb.get();
        return first == '0' && (second == 'x' || second == 'X');
    }

    private static int parseAsciiDigit(char c, int radix) {
        assert (radix == 8 || radix == 10 || radix == 16);
        if (radix == 16) {
            return IPAddressUtil.parseAsciiHexDigit(c);
        }
        int val = c - 48;
        return val < 0 || val >= radix ? -1 : val;
    }

    private static int parseAsciiHexDigit(char digit) {
        char c = Character.toLowerCase(digit);
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return IPAddressUtil.parseAsciiDigit(c, 10);
    }
}

