/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.net.URL;
import java.security.AccessController;
import sun.net.www.http.KeepAliveCache;

class KeepAliveKey {
    private static boolean useKeyExtension = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sap.jvm.UseHttpKeepAliveCacheKeyExtension"));
    private String protocol = null;
    private String host = null;
    private int port = 0;
    private Object obj = null;
    private Object customObj = null;

    public KeepAliveKey(URL url, Object obj) {
        this.protocol = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        this.obj = obj;
        if (useKeyExtension) {
            this.customObj = KeepAliveCache.connectionID.get();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeepAliveKey)) {
            return false;
        }
        KeepAliveKey kae = (KeepAliveKey)obj;
        return this.host.equals(kae.host) && this.port == kae.port && this.protocol.equals(kae.protocol) && this.obj == kae.obj && this.customObj == kae.customObj;
    }

    public int hashCode() {
        int hashCode = (this.protocol + this.host + this.port).hashCode();
        if (this.obj != null) {
            hashCode += this.obj.hashCode();
        }
        if (this.customObj != null) {
            hashCode += this.customObj.hashCode();
        }
        return hashCode;
    }
}

