/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.URL;
import java.security.cert.X509Certificate;

public final class HttpCallerInfo {
    public final URL url;
    public final String host;
    public final String protocol;
    public final String prompt;
    public final String scheme;
    public final int port;
    public final InetAddress addr;
    public final Authenticator.RequestorType authType;
    public final X509Certificate serverCert;

    public HttpCallerInfo(HttpCallerInfo old, String scheme) {
        this.url = old.url;
        this.host = old.host;
        this.protocol = old.protocol;
        this.prompt = old.prompt;
        this.port = old.port;
        this.addr = old.addr;
        this.authType = old.authType;
        this.scheme = scheme;
        this.serverCert = old.serverCert;
    }

    public HttpCallerInfo(URL url) {
        this(url, null);
    }

    public HttpCallerInfo(URL url, X509Certificate serverCert) {
        InetAddress ia;
        this.url = url;
        this.serverCert = serverCert;
        this.prompt = "";
        this.host = url.getHost();
        int p = url.getPort();
        this.port = p == -1 ? url.getDefaultPort() : p;
        try {
            ia = InetAddress.getByName(url.getHost());
        }
        catch (Exception e) {
            ia = null;
        }
        this.addr = ia;
        this.protocol = url.getProtocol();
        this.authType = Authenticator.RequestorType.SERVER;
        this.scheme = "";
    }

    public HttpCallerInfo(URL url, String host, int port) {
        this(url, host, port, null);
    }

    public HttpCallerInfo(URL url, String host, int port, X509Certificate serverCert) {
        this.url = url;
        this.host = host;
        this.port = port;
        this.serverCert = serverCert;
        this.prompt = "";
        this.addr = null;
        this.protocol = url.getProtocol();
        this.authType = Authenticator.RequestorType.PROXY;
        this.scheme = "";
    }
}

