/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarFileFactory;

public class JarURLConnection
extends java.net.JarURLConnection {
    private static final boolean debug = false;
    private static final JarFileFactory factory = JarFileFactory.getInstance();
    private URL jarFileURL = this.getJarFileURL();
    private Permission permission;
    private URLConnection jarFileURLConnection = this.jarFileURL.openConnection();
    private String entryName = this.getEntryName();
    private JarEntry jarEntry;
    private JarFile jarFile;
    private String contentType;

    public JarURLConnection(URL url, Handler handler) throws MalformedURLException, IOException {
        super(url);
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            boolean useCaches = this.getUseCaches();
            String entryName = this.entryName;
            URL url = this.getJarFileURL();
            JarFile jarFile = this.jarFile = entryName == null ? factory.get(url, useCaches) : factory.getOrCreate(url, useCaches);
            if (entryName != null) {
                this.jarEntry = (JarEntry)this.jarFile.getEntry(entryName);
                if (this.jarEntry == null) {
                    try {
                        factory.closeIfNotCached(url, this.jarFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new FileNotFoundException("JAR entry " + entryName + " not found in " + this.jarFile.getName());
                }
            }
            if (useCaches && entryName != null) {
                useCaches = factory.cacheIfAbsent(url, this.jarFile);
            }
            if (useCaches) {
                boolean oldUseCaches = this.jarFileURLConnection.getUseCaches();
                this.jarFileURLConnection = factory.getConnection(this.jarFile);
                this.jarFileURLConnection.setUseCaches(oldUseCaches);
            }
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        InputStream result = null;
        if (this.entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
        }
        result = this.jarFile.getInputStream(this.jarEntry);
        if (result != null) {
            result = new JarURLInputStream(result);
        }
        return result;
    }

    @Override
    public int getContentLength() {
        long result = this.getContentLengthLong();
        if (result > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)result;
    }

    @Override
    public long getContentLengthLong() {
        long result = -1L;
        try {
            this.connect();
            result = this.jarEntry == null ? this.jarFileURLConnection.getContentLengthLong() : this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Object getContent() throws IOException {
        Object result = null;
        this.connect();
        result = this.entryName == null ? this.jarFile : super.getContent();
        return result;
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream in = this.jarFile.getInputStream(this.jarEntry);
                    this.contentType = JarURLConnection.guessContentTypeFromStream(new BufferedInputStream(in));
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = JarURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    @Override
    public String getHeaderField(String name) {
        return this.jarFileURLConnection.getHeaderField(name);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.jarFileURLConnection.setRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return this.jarFileURLConnection.getRequestProperty(key);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.jarFileURLConnection.addRequestProperty(key, value);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.jarFileURLConnection.getRequestProperties();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.jarFileURLConnection.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.jarFileURLConnection.setUseCaches(usecaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.jarFileURLConnection.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.jarFileURLConnection.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }

    class JarURLInputStream
    extends FilterInputStream {
        JarURLInputStream(InputStream src) {
            super(src);
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (!JarURLConnection.this.getUseCaches()) {
                    JarURLConnection.this.jarFile.close();
                }
            }
        }
    }
}

