/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.AsynchronousChannelProvider;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class DefaultAsynchronousChannelProvider {
    private DefaultAsynchronousChannelProvider() {
    }

    private static AsynchronousChannelProvider createProvider(String cn) {
        Class<?> c;
        try {
            c = Class.forName(cn);
        }
        catch (ClassNotFoundException x) {
            throw new AssertionError((Object)x);
        }
        try {
            return (AsynchronousChannelProvider)c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException x) {
            throw new AssertionError((Object)x);
        }
    }

    public static AsynchronousChannelProvider create() {
        String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (osname.equals("SunOS")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.SolarisAsynchronousChannelProvider");
        }
        if (osname.equals("Linux")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.LinuxAsynchronousChannelProvider");
        }
        if (osname.contains("OS X")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.BsdAsynchronousChannelProvider");
        }
        if (osname.equals("AIX")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.AixAsynchronousChannelProvider");
        }
        if (osname.equals("HP-UX")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.HpuxAsynchronousChannelProvider");
        }
        if (osname.equals("OS400")) {
            return DefaultAsynchronousChannelProvider.createProvider("sun.nio.ch.AS400AsynchronousChannelProvider");
        }
        throw new InternalError("platform not recognized");
    }
}

