/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.ch.PollSelectorProvider;
import sun.security.action.GetPropertyAction;

public class DefaultSelectorProvider {
    private static boolean fallbackToPollSelectorProvider = false;

    private DefaultSelectorProvider() {
    }

    private static SelectorProvider createProvider(String cn) {
        Class<?> c;
        try {
            c = Class.forName(cn);
        }
        catch (ClassNotFoundException x) {
            throw new AssertionError((Object)x);
        }
        try {
            return (SelectorProvider)c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException x) {
            throw new AssertionError((Object)x);
        }
    }

    public static SelectorProvider create() {
        if (fallbackToPollSelectorProvider) {
            return new PollSelectorProvider();
        }
        String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (osname.equals("SunOS")) {
            return DefaultSelectorProvider.createProvider("sun.nio.ch.DevPollSelectorProvider");
        }
        if (osname.equals("HP-UX")) {
            return DefaultSelectorProvider.createProvider("sun.nio.ch.DevPollSelectorProvider");
        }
        if (osname.equals("Linux")) {
            String archname = AccessController.doPrivileged(new GetPropertyAction("os.arch"));
            if ("ia64".equals(archname) || "ppc64".equals(archname) || "zArch_64".equals(archname)) {
                String osversion = AccessController.doPrivileged(new GetPropertyAction("os.version"));
                String[] vers = osversion.split("\\.", 0);
                if (vers.length >= 2) {
                    try {
                        String[] microparts;
                        int major = Integer.parseInt(vers[0]);
                        int minor = Integer.parseInt(vers[1]);
                        int micro = -1;
                        if (vers.length >= 3 && (microparts = vers[2].split("-", 0)).length > 0) {
                            try {
                                micro = Integer.parseInt(microparts[0]);
                            }
                            catch (NumberFormatException x) {
                                micro = -1;
                            }
                        }
                        if (major > 2 || major == 2 && (minor > 6 || minor == 6 && micro >= 27)) {
                            return DefaultSelectorProvider.createProvider("sun.nio.ch.EPollSelectorProvider");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return new PollSelectorProvider();
            }
            return DefaultSelectorProvider.createProvider("sun.nio.ch.EPollSelectorProvider");
        }
        return new PollSelectorProvider();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if ("true".equals(System.getProperty("com.sap.jvm.fallback.to.pollselectorprovider"))) {
                    fallbackToPollSelectorProvider = true;
                }
                return null;
            }
        });
    }
}

