/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.ArrayList;
import sun.nio.ch.AbstractPollSelectorImpl;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.security.action.GetPropertyAction;

class PollSelectorImpl
extends AbstractPollSelectorImpl {
    private static final boolean onOS400 = "OS400".equals(AccessController.doPrivileged(new GetPropertyAction("os.name")));
    private int fd0;
    private int fd1;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    PollSelectorImpl(SelectorProvider sp) {
        super(sp, 1, 1);
        long pipeFds = IOUtil.makePipe(false);
        this.fd0 = (int)(pipeFds >>> 32);
        this.fd1 = (int)pipeFds;
        try {
            this.pollWrapper = new PollArrayWrapper(10);
            this.pollWrapper.initInterrupt(this.fd0, this.fd1);
            this.channelArray = new SelectionKeyImpl[10];
        }
        catch (Throwable t) {
            try {
                FileDispatcherImpl.closeIntFD(this.fd0);
            }
            catch (IOException ioe0) {
                t.addSuppressed(ioe0);
            }
            try {
                FileDispatcherImpl.closeIntFD(this.fd1);
            }
            catch (IOException ioe1) {
                t.addSuppressed(ioe1);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long timeout) throws IOException {
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        ArrayList<SelectionKey> manipulatedKeys = null;
        if (onOS400) {
            manipulatedKeys = new ArrayList<SelectionKey>();
            for (Object ok : this.keys) {
                SelectionKey k;
                if (!(ok instanceof SelectionKey) || (k = (SelectionKey)ok).channel() == null || !k.isValid() || !(k.channel() instanceof SocketChannelImpl) || k.interestOps() != 0) continue;
                manipulatedKeys.add(k);
                k.interestOps(1);
            }
        }
        try {
            this.begin();
            this.pollWrapper.poll(this.totalChannels, 0, timeout);
        }
        finally {
            this.end();
        }
        if (onOS400) {
            for (SelectionKey k : manipulatedKeys) {
                k.interestOps(k.interestOps() & 0xFFFFFFFE);
            }
        }
        this.processDeregisterQueue();
        int numKeysUpdated = this.updateSelectedKeys();
        if (this.pollWrapper.getReventOps(0) != 0) {
            this.pollWrapper.putReventOps(0, 0);
            Object object = this.interruptLock;
            synchronized (object) {
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseInterrupt() throws IOException {
        Object object = this.interruptLock;
        synchronized (object) {
            this.interruptTriggered = true;
        }
        FileDispatcherImpl.closeIntFD(this.fd0);
        FileDispatcherImpl.closeIntFD(this.fd1);
        this.fd0 = -1;
        this.fd1 = -1;
        this.pollWrapper.release(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }
}

