/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.misc.JavaNetAccess;
import sun.misc.SharedSecrets;
import sun.net.ExtendedSocketOptions;
import sun.net.NetHooks;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;

class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private static JavaNetAccess jna;
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private boolean isReuseAddress;
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLPENDING = 3;
    private static final int ST_KILLED = 4;
    private int state = -1;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private boolean isInputOpen = true;
    private boolean isOutputOpen = true;
    private boolean readyToConnect = false;
    private Socket socket;

    SocketChannelImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider sp, FileDescriptor fd, boolean bound) throws IOException {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        this.state = 0;
        if (bound) {
            this.localAddress = Net.localAddress(fd);
        }
    }

    SocketChannelImpl(SelectorProvider sp, FileDescriptor fd, InetSocketAddress remote) throws IOException {
        super(sp);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        this.state = 2;
        this.localAddress = Net.localAddress(fd);
        this.remoteAddress = remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = SocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return Net.getRevealedLocalAddress(this.localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (name == StandardSocketOptions.IP_TOS) {
                StandardProtocolFamily family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
                Net.setSocketOption(this.fd, family, name, value);
                return this;
            }
            if (name == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                this.isReuseAddress = (Boolean)value;
                return this;
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (name == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                return (T)Boolean.valueOf(this.isReuseAddress);
            }
            if (name == StandardSocketOptions.IP_TOS) {
                StandardProtocolFamily family = Net.isIPv6Available() ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
                return (T)Net.getSocketOption(this.fd, family, name);
            }
            return (T)Net.getSocketOption(this.fd, Net.UNSPEC, name);
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return this.isInputOpen;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isOutputOpen) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writerCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.writerThread = 0L;
            if (this.state == 3) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int read(ByteBuffer buf) throws IOException {
        int n;
        int n2;
        block22: {
            if (buf == null) {
                throw new NullPointerException();
            }
            Object object = this.readLock;
            // MONITORENTER : object
            if (!this.ensureReadOpen()) {
                // MONITOREXIT : object
                return -1;
            }
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block22;
            int n3 = 0;
            // MONITOREXIT : object2
            this.readerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object3
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = IOUtil.read(this.fd, buf, -1L, nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.readerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isInputOpen) {
            // MONITOREXIT : object
            // MONITOREXIT : object
            return -1;
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long l;
        long n;
        block22: {
            if (offset < 0) throw new IndexOutOfBoundsException();
            if (length < 0) throw new IndexOutOfBoundsException();
            if (offset > dsts.length - length) {
                throw new IndexOutOfBoundsException();
            }
            Object object = this.readLock;
            // MONITORENTER : object
            if (!this.ensureReadOpen()) {
                // MONITOREXIT : object
                return -1L;
            }
            n = 0L;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block22;
            long l2 = 0L;
            // MONITOREXIT : object2
            this.readerCleanup();
            this.end(n > 0L || n == -2L);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object3
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n));
            // MONITOREXIT : object
            return l2;
        }
        try {
            this.readerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n = IOUtil.read(this.fd, dsts, offset, length, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(n);
        }
        catch (Throwable throwable) {
            this.readerCleanup();
            this.end(n > 0L || n == -2L);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n)) throw throwable;
            throw new AssertionError();
        }
        this.readerCleanup();
        this.end(n > 0L || n == -2L);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n <= 0L && !this.isInputOpen) {
            // MONITOREXIT : object
            // MONITOREXIT : object
            return -1L;
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n));
        // MONITOREXIT : object
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int write(ByteBuffer buf) throws IOException {
        int n;
        int n2;
        block21: {
            if (buf == null) {
                throw new NullPointerException();
            }
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block21;
            int n3 = 0;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = IOUtil.write(this.fd, buf, -1L, nd)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long l;
        long n;
        block21: {
            if (offset < 0) throw new IndexOutOfBoundsException();
            if (length < 0) throw new IndexOutOfBoundsException();
            if (offset > srcs.length - length) {
                throw new IndexOutOfBoundsException();
            }
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            n = 0L;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block21;
            long l2 = 0L;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(n > 0L || n == -2L);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n));
            // MONITOREXIT : object
            return l2;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n = IOUtil.write(this.fd, srcs, offset, length, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(n);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(n > 0L || n == -2L);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n > 0L || n == -2L);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n <= 0L && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n));
        // MONITOREXIT : object
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    int sendOutOfBandData(byte b) throws IOException {
        int n;
        int n2;
        block20: {
            Object object = this.writeLock;
            // MONITORENTER : object
            this.ensureWriteOpen();
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block20;
            int n3 = 0;
            // MONITOREXIT : object2
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.writerThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = SocketChannelImpl.sendOutOfBandData(this.fd, b)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.writerCleanup();
            this.end(n2 > 0 || n2 == -2);
            Object object = this.stateLock;
            // MONITORENTER : object
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.writerCleanup();
        this.end(n2 > 0 || n2 == -2);
        Object object = this.stateLock;
        // MONITORENTER : object
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        IOUtil.configureBlocking(this.fd, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (this.state == 1) {
                        throw new ConnectionPendingException();
                    }
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress isa = local == null ? new InetSocketAddress(0) : Net.checkAddress(local);
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkListen(isa.getPort());
                    }
                    NetHooks.beforeTcpBind(this.fd, isa.getAddress(), isa.getPort());
                    Net.bind(this.fd, isa.getAddress(), isa.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean connect(SocketAddress sa) throws IOException {
        Object object;
        boolean localPort = false;
        Object object2 = this.readLock;
        // MONITORENTER : object2
        Object object3 = this.writeLock;
        // MONITORENTER : object3
        this.ensureOpenAndUnconnected();
        InetSocketAddress isa = Net.checkAddress(sa);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
        }
        Object object4 = this.blockingLock();
        // MONITORENTER : object4
        int n = 0;
        try {
            block29: {
                this.begin();
                object = this.stateLock;
                // MONITORENTER : object
                if (this.isOpen()) break block29;
                boolean bl = false;
                // MONITOREXIT : object
                this.readerCleanup();
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object4
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return bl;
            }
            try {
                if (this.localAddress == null) {
                    NetHooks.beforeTcpConnect(this.fd, isa.getAddress(), isa.getPort());
                }
                this.readerThread = NativeThread.current();
                // MONITOREXIT : object
                do {
                    InetSocketAddress localSocketAddress;
                    InetAddress ia;
                    if ((ia = isa.getAddress()).isAnyLocalAddress()) {
                        ia = InetAddress.getLocalHost();
                    } else if (this.localAddress == null && (localSocketAddress = jna.getPreBindAddress(isa)) != null) {
                        this.bind(localSocketAddress);
                    }
                    n = Net.connect(this.fd, ia, isa.getPort());
                } while (n == -3 && this.isOpen());
            }
            catch (Throwable throwable) {
                this.readerCleanup();
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.readerCleanup();
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException x) {
            this.close();
            throw x;
        }
        object = this.stateLock;
        // MONITORENTER : object
        this.remoteAddress = isa;
        if (n > 0) {
            this.state = 2;
            if (this.isOpen()) {
                this.localAddress = Net.localAddress(this.fd);
            }
            // MONITOREXIT : object
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        if (!this.isBlocking()) {
            this.state = 1;
            return false;
        }
        assert (false);
        // MONITOREXIT : object
        // MONITOREXIT : object4
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean finishConnect() throws IOException {
        Object object;
        Object object2 = this.readLock;
        // MONITORENTER : object2
        Object object3 = this.writeLock;
        // MONITORENTER : object3
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.state == 2) {
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        if (this.state != 1) {
            throw new NoConnectionPendingException();
        }
        // MONITOREXIT : object4
        int n = 0;
        try {
            block40: {
                this.begin();
                object = this.blockingLock();
                // MONITORENTER : object
                Object object5 = this.stateLock;
                // MONITORENTER : object5
                if (this.isOpen()) break block40;
                boolean bl = false;
                // MONITOREXIT : object5
                // MONITOREXIT : object
                Object object6 = this.stateLock;
                // MONITORENTER : object6
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object6
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return bl;
            }
            try {
                this.readerThread = NativeThread.current();
                // MONITOREXIT : object5
                if (!this.isBlocking()) {
                    while ((n = SocketChannelImpl.checkConnect(this.fd, false, this.readyToConnect)) == -3 && this.isOpen()) {
                    }
                } else {
                    while ((n = SocketChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) == 0 || n == -3 && this.isOpen()) {
                    }
                }
                // MONITOREXIT : object
                object = this.stateLock;
            }
            catch (Throwable throwable) {
                Object object7 = this.stateLock;
                // MONITORENTER : object7
                this.readerThread = 0L;
                if (this.state == 3) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object7
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.readerThread = 0L;
            if (this.state == 3) {
                this.kill();
                n = 0;
            }
            // MONITOREXIT : object
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException x) {
            this.close();
            throw x;
        }
        if (n <= 0) {
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return false;
        }
        object = this.stateLock;
        // MONITORENTER : object
        this.state = 2;
        if (this.isOpen()) {
            this.localAddress = Net.localAddress(this.fd);
        }
        // MONITOREXIT : object
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (this.isInputOpen) {
                Net.shutdown(this.fd, 0);
                if (this.readerThread != 0L) {
                    NativeThread.signal(this.readerThread);
                }
                this.isInputOpen = false;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketChannel shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            if (this.isOutputOpen) {
                Net.shutdown(this.fd, 1);
                if (this.writerThread != 0L) {
                    NativeThread.signal(this.writerThread);
                }
                this.isOutputOpen = false;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isInputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isOutputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.isInputOpen = false;
            this.isOutputOpen = false;
            if (this.state != 4) {
                nd.preClose(this.fd);
            }
            if (this.readerThread != 0L) {
                NativeThread.signal(this.readerThread);
            }
            if (this.writerThread != 0L) {
                NativeThread.signal(this.writerThread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 4) {
                return;
            }
            if (this.state == -1) {
                this.state = 4;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.readerThread == 0L && this.writerThread == 0L) {
                nd.close(this.fd);
                this.state = 4;
            } else {
                this.state = 3;
            }
        }
    }

    public boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl sk) {
        int intOps = sk.nioInterestOps();
        int oldOps = sk.nioReadyOps();
        int newOps = initialOps;
        if ((ops & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((ops & (Net.POLLERR | Net.POLLHUP)) != 0) {
            newOps = intOps;
            sk.nioReadyOps(newOps);
            this.readyToConnect = true;
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & Net.POLLIN) != 0 && (intOps & 1) != 0 && this.state == 2) {
            newOps |= 1;
        }
        if ((ops & Net.POLLCONN) != 0 && (intOps & 8) != 0 && (this.state == 0 || this.state == 1)) {
            newOps |= 8;
            this.readyToConnect = true;
        }
        if ((ops & Net.POLLOUT) != 0 && (intOps & 4) != 0 && this.state == 2) {
            newOps |= 4;
        }
        sk.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, sk.nioReadyOps(), sk);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, 0, sk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    int poll(int events, long timeout) throws IOException {
        int n;
        block10: {
            int n2;
            if (!$assertionsDisabled) {
                if (!Thread.holdsLock(this.blockingLock())) throw new AssertionError();
                if (this.isBlocking()) {
                    throw new AssertionError();
                }
            }
            Object object = this.readLock;
            // MONITORENTER : object
            n = 0;
            try {
                this.begin();
                Object object2 = this.stateLock;
                // MONITORENTER : object2
                if (this.isOpen()) break block10;
                n2 = 0;
                // MONITOREXIT : object2
            }
            catch (Throwable throwable) {
                this.readerCleanup();
                this.end(n > 0);
                throw throwable;
            }
            this.readerCleanup();
            this.end(n > 0);
            // MONITOREXIT : object
            return n2;
        }
        this.readerThread = NativeThread.current();
        // MONITOREXIT : object2
        n = Net.poll(this.fd, events, timeout);
        this.readerCleanup();
        this.end(n > 0);
        return n;
    }

    @Override
    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        int newOps = 0;
        if ((ops & 1) != 0) {
            newOps |= Net.POLLIN;
        }
        if ((ops & 4) != 0) {
            newOps |= Net.POLLOUT;
        }
        if ((ops & 8) != 0) {
            newOps |= Net.POLLCONN;
        }
        sk.selector.putEventOps(sk, newOps);
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSuperclass().getName());
        sb.append('[');
        if (!this.isOpen()) {
            sb.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        sb.append("unconnected");
                        break;
                    }
                    case 1: {
                        sb.append("connection-pending");
                        break;
                    }
                    case 2: {
                        sb.append("connected");
                        if (!this.isInputOpen) {
                            sb.append(" ishut");
                        }
                        if (this.isOutputOpen) break;
                        sb.append(" oshut");
                    }
                }
                InetSocketAddress addr = this.localAddress();
                if (addr != null) {
                    sb.append(" local=");
                    sb.append(Net.getRevealedLocalAddressAsString(addr));
                }
                if (this.remoteAddress() != null) {
                    sb.append(" remote=");
                    sb.append(this.remoteAddress().toString());
                }
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    private static native int sendOutOfBandData(FileDescriptor var0, byte var1) throws IOException;

    static {
        jna = SharedSecrets.getJavaNetAccess();
        IOUtil.load();
        nd = new SocketDispatcher();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet set = new HashSet(8);
            set.add(StandardSocketOptions.SO_SNDBUF);
            set.add(StandardSocketOptions.SO_RCVBUF);
            set.add(StandardSocketOptions.SO_KEEPALIVE);
            set.add(StandardSocketOptions.SO_REUSEADDR);
            set.add(StandardSocketOptions.SO_LINGER);
            set.add(StandardSocketOptions.TCP_NODELAY);
            set.add(StandardSocketOptions.IP_TOS);
            set.add(ExtendedSocketOption.SO_OOBINLINE);
            set.addAll(ExtendedSocketOptions.clientSocketOptions());
            return Collections.unmodifiableSet(set);
        }
    }
}

