/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Objects;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;

class ISO_8859_1
extends Charset
implements HistoricallyNamedCharset {
    public ISO_8859_1() {
        super("ISO-8859-1", StandardCharsets.aliases_ISO_8859_1);
    }

    @Override
    public String historicalName() {
        return "ISO8859_1";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof US_ASCII || cs instanceof ISO_8859_1;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private byte repl = (byte)63;

        private Encoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return c <= '\u00ff';
        }

        @Override
        public boolean isLegalReplacement(byte[] repl) {
            return true;
        }

        private static int encodeISOArray(char[] sa, int sp, byte[] da, int dp, int len) {
            Encoder.encodeISOArrayCheck(sa, sp, da, dp, len);
            return Encoder.implEncodeISOArray(sa, sp, da, dp, len);
        }

        private static int implEncodeISOArray(char[] sa, int sp, byte[] da, int dp, int len) {
            char c;
            int i;
            for (i = 0; i < len && (c = sa[sp++]) <= '\u00ff'; ++i) {
                da[dp++] = (byte)c;
            }
            return i;
        }

        private static void encodeISOArrayCheck(char[] sa, int sp, byte[] da, int dp, int len) {
            if (len <= 0) {
                return;
            }
            Objects.requireNonNull(sa);
            Objects.requireNonNull(da);
            if (sp < 0 || sp >= sa.length) {
                throw new ArrayIndexOutOfBoundsException(sp);
            }
            if (dp < 0 || dp >= da.length) {
                throw new ArrayIndexOutOfBoundsException(dp);
            }
            int endIndexSP = sp + len - 1;
            if (endIndexSP < 0 || endIndexSP >= sa.length) {
                throw new ArrayIndexOutOfBoundsException(endIndexSP);
            }
            int endIndexDP = dp + len - 1;
            if (endIndexDP < 0 || endIndexDP >= da.length) {
                throw new ArrayIndexOutOfBoundsException(endIndexDP);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int soff = src.arrayOffset();
            int sp = soff + src.position();
            int sl = soff + src.limit();
            assert (sp <= sl);
            sp = sp <= sl ? sp : sl;
            byte[] da = dst.array();
            int doff = dst.arrayOffset();
            int dp = doff + dst.position();
            int dl = doff + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            int dlen = dl - dp;
            int slen = sl - sp;
            int len = dlen < slen ? dlen : slen;
            try {
                int ret = len <= 0 ? 0 : Encoder.encodeISOArray(sa, sp, da, dp, len);
                sp += ret;
                dp += ret;
                if (ret != len) {
                    if (this.sgp.parse(sa[sp], sa, sp, sl) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (len < slen) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - soff);
                dst.position(dp - doff);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    if (c <= '\u00ff') {
                        if (!dst.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)c);
                        ++mark;
                        continue;
                    }
                    if (this.sgp.parse(c, src) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        @Override
        protected void implReplaceWith(byte[] newReplacement) {
            this.repl = newReplacement[0];
        }

        @Override
        public int encode(char[] src, int sp, int len, byte[] dst) {
            int dp = 0;
            int slen = Math.min(len, dst.length);
            int sl = sp + slen;
            while (sp < sl) {
                char c;
                int ret = slen <= 0 ? 0 : Encoder.encodeISOArray(src, sp, dst, dp, slen);
                sp += ret;
                dp += ret;
                if (ret == slen) continue;
                if (Character.isHighSurrogate(c = src[sp++]) && sp < sl && Character.isLowSurrogate(src[sp])) {
                    if (len > dst.length) {
                        ++sl;
                        --len;
                    }
                    ++sp;
                }
                dst[dp++] = this.repl;
                slen = Math.min(sl - sp, dst.length - dp);
            }
            return dp;
        }
    }

    private static class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; ++sp) {
                    byte b = sa[sp];
                    if (dp >= dl) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = (char)(b & 0xFF);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    byte b = src.get();
                    if (!dst.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    dst.put((char)(b & 0xFF));
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        @Override
        public int decode(byte[] src, int sp, int len, char[] dst) {
            if (len > dst.length) {
                len = dst.length;
            }
            int dp = 0;
            while (dp < len) {
                dst[dp++] = (char)(src[sp++] & 0xFF);
            }
            return dp;
        }
    }
}

