/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class DefaultFileSystemProvider {
    private static FileSystemProvider INSTANCE = DefaultFileSystemProvider.create();

    private DefaultFileSystemProvider() {
    }

    private static FileSystemProvider createProvider(String cn) {
        Class<?> c;
        try {
            c = Class.forName(cn);
        }
        catch (ClassNotFoundException x) {
            throw new AssertionError((Object)x);
        }
        try {
            return (FileSystemProvider)c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException x) {
            throw new AssertionError((Object)x);
        }
    }

    static FileSystemProvider create() {
        String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (osname.equals("SunOS")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.SolarisFileSystemProvider");
        }
        if (osname.equals("Linux")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.LinuxFileSystemProvider");
        }
        if (osname.contains("OS X")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.MacOSXFileSystemProvider");
        }
        if (osname.equals("AIX") || osname.equals("OS400")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.AixFileSystemProvider");
        }
        if (osname.equals("HP-UX")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.HpuxFileSystemProvider");
        }
        throw new AssertionError((Object)"Platform not recognized");
    }

    public static FileSystemProvider instance() {
        return INSTANCE;
    }
}

