/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.FileDescriptor;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.FileChannelImpl;
import sun.nio.ch.SimpleAsynchronousFileChannelImpl;
import sun.nio.ch.ThreadPool;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixChannelFactory {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();

    protected UnixChannelFactory() {
    }

    static FileChannel newFileChannel(int fd, String path, boolean reading, boolean writing) {
        FileDescriptor fdObj = new FileDescriptor();
        fdAccess.set(fdObj, fd);
        return FileChannelImpl.open(fdObj, path, reading, writing, null);
    }

    static FileChannel newFileChannel(int dfd, UnixPath path, String pathForPermissionCheck, Set<? extends OpenOption> options, int mode) throws UnixException {
        Flags flags = Flags.toFlags(options);
        if (!flags.read && !flags.write) {
            if (flags.append) {
                flags.write = true;
            } else {
                flags.read = true;
            }
        }
        if (flags.read && flags.append) {
            throw new IllegalArgumentException("READ + APPEND not allowed");
        }
        if (flags.append && flags.truncateExisting) {
            throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING not allowed");
        }
        FileDescriptor fdObj = UnixChannelFactory.open(dfd, path, pathForPermissionCheck, flags, mode);
        return FileChannelImpl.open(fdObj, path.toString(), flags.read, flags.write, flags.append, null);
    }

    static FileChannel newFileChannel(UnixPath path, Set<? extends OpenOption> options, int mode) throws UnixException {
        return UnixChannelFactory.newFileChannel(-1, path, null, options, mode);
    }

    static AsynchronousFileChannel newAsynchronousFileChannel(UnixPath path, Set<? extends OpenOption> options, int mode, ThreadPool pool) throws UnixException {
        Flags flags = Flags.toFlags(options);
        if (!flags.read && !flags.write) {
            flags.read = true;
        }
        if (flags.append) {
            throw new UnsupportedOperationException("APPEND not allowed");
        }
        FileDescriptor fdObj = UnixChannelFactory.open(-1, path, null, flags, mode);
        return SimpleAsynchronousFileChannelImpl.open(fdObj, flags.read, flags.write, pool);
    }

    protected static FileDescriptor open(int dfd, UnixPath path, String pathForPermissionCheck, Flags flags, int mode) throws UnixException {
        int fd;
        SecurityManager sm;
        int oflags;
        if (flags.read && flags.write) {
            oflags = 2;
        } else {
            int n = oflags = flags.write ? 1 : 0;
        }
        if (flags.write) {
            if (flags.truncateExisting) {
                oflags |= 0x200;
            }
            if (flags.append) {
                oflags |= 0x400;
            }
            if (flags.createNew) {
                byte[] pathForSysCall = path.asByteArray();
                if (pathForSysCall[pathForSysCall.length - 1] == 46 && (pathForSysCall.length == 1 || pathForSysCall[pathForSysCall.length - 2] == 47)) {
                    throw new UnixException(17);
                }
                oflags |= 0xC0;
            } else if (flags.create) {
                oflags |= 0x40;
            }
        }
        boolean followLinks = true;
        if (!flags.createNew && (flags.noFollowLinks || flags.deleteOnClose)) {
            if (flags.deleteOnClose) {
                // empty if block
            }
            followLinks = false;
            oflags |= 0x20000;
        }
        if (flags.dsync) {
            oflags |= 0x1000;
        }
        if (flags.sync) {
            oflags |= 0x1000;
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (pathForPermissionCheck == null) {
                pathForPermissionCheck = path.getPathForPermissionCheck();
            }
            if (flags.read) {
                sm.checkRead(pathForPermissionCheck);
            }
            if (flags.write) {
                sm.checkWrite(pathForPermissionCheck);
            }
            if (flags.deleteOnClose) {
                sm.checkDelete(pathForPermissionCheck);
            }
        }
        try {
            fd = dfd >= 0 ? UnixNativeDispatcher.openat(dfd, path.asByteArray(), oflags, mode) : UnixNativeDispatcher.open(path, oflags, mode);
        }
        catch (UnixException x) {
            if (flags.createNew && x.errno() == 21) {
                x.setError(17);
            }
            if (!followLinks && x.errno() == 40) {
                x = new UnixException(x.getMessage() + " (NOFOLLOW_LINKS specified)");
            }
            throw x;
        }
        if (flags.deleteOnClose) {
            try {
                if (dfd >= 0) {
                    UnixNativeDispatcher.unlinkat(dfd, path.asByteArray(), 0);
                } else {
                    UnixNativeDispatcher.unlink(path);
                }
            }
            catch (UnixException x) {
                // empty catch block
            }
        }
        FileDescriptor fdObj = new FileDescriptor();
        fdAccess.set(fdObj, fd);
        return fdObj;
    }

    protected static class Flags {
        boolean read;
        boolean write;
        boolean append;
        boolean truncateExisting;
        boolean noFollowLinks;
        boolean create;
        boolean createNew;
        boolean deleteOnClose;
        boolean sync;
        boolean dsync;

        protected Flags() {
        }

        static Flags toFlags(Set<? extends OpenOption> options) {
            Flags flags = new Flags();
            block12: for (OpenOption openOption : options) {
                if (openOption instanceof StandardOpenOption) {
                    switch ((StandardOpenOption)openOption) {
                        case READ: {
                            flags.read = true;
                            continue block12;
                        }
                        case WRITE: {
                            flags.write = true;
                            continue block12;
                        }
                        case APPEND: {
                            flags.append = true;
                            continue block12;
                        }
                        case TRUNCATE_EXISTING: {
                            flags.truncateExisting = true;
                            continue block12;
                        }
                        case CREATE: {
                            flags.create = true;
                            continue block12;
                        }
                        case CREATE_NEW: {
                            flags.createNew = true;
                            continue block12;
                        }
                        case DELETE_ON_CLOSE: {
                            flags.deleteOnClose = true;
                            continue block12;
                        }
                        case SPARSE: {
                            continue block12;
                        }
                        case SYNC: {
                            flags.sync = true;
                            continue block12;
                        }
                        case DSYNC: {
                            flags.dsync = true;
                            continue block12;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                if (openOption == LinkOption.NOFOLLOW_LINKS) {
                    flags.noFollowLinks = true;
                    continue;
                }
                if (openOption == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException(openOption + " not supported");
            }
            return flags;
        }
    }
}

