/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedCopyOption;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.Cancellable;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixCopyFile {
    private UnixCopyFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyDirectory(UnixPath source, UnixFileAttributes attrs, UnixPath target, Flags flags) throws IOException {
        int dfd;
        block30: {
            try {
                UnixNativeDispatcher.mkdir(target, attrs.mode());
            }
            catch (UnixException x) {
                x.rethrowAsIOException(target);
            }
            if (!(flags.copyBasicAttributes || flags.copyPosixAttributes || flags.copyNonPosixAttributes)) {
                return;
            }
            dfd = -1;
            try {
                dfd = UnixNativeDispatcher.open(target, 0, 0);
            }
            catch (UnixException x) {
                if (!flags.copyNonPosixAttributes || !flags.failIfUnableToCopyNonPosix) break block30;
                try {
                    UnixNativeDispatcher.rmdir(target);
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
                x.rethrowAsIOException(target);
            }
        }
        boolean done = false;
        try {
            block33: {
                block31: {
                    if (flags.copyPosixAttributes) {
                        try {
                            if (dfd >= 0) {
                                UnixNativeDispatcher.fchown(dfd, attrs.uid(), attrs.gid());
                                UnixNativeDispatcher.fchmod(dfd, attrs.mode());
                            } else {
                                UnixNativeDispatcher.chown(target, attrs.uid(), attrs.gid());
                                UnixNativeDispatcher.chmod(target, attrs.mode());
                            }
                        }
                        catch (UnixException x) {
                            if (!flags.failIfUnableToCopyPosix) break block31;
                            x.rethrowAsIOException(target);
                        }
                    }
                }
                if (flags.copyNonPosixAttributes && dfd >= 0) {
                    int sfd;
                    block32: {
                        sfd = -1;
                        try {
                            sfd = UnixNativeDispatcher.open(source, 0, 0);
                        }
                        catch (UnixException x) {
                            if (!flags.failIfUnableToCopyNonPosix) break block32;
                            x.rethrowAsIOException(source);
                        }
                    }
                    if (sfd >= 0) {
                        source.getFileSystem().copyNonPosixAttributes(sfd, dfd);
                        UnixNativeDispatcher.close(sfd);
                    }
                }
                if (flags.copyBasicAttributes) {
                    try {
                        if (dfd >= 0 && UnixNativeDispatcher.futimesSupported()) {
                            UnixNativeDispatcher.futimes(dfd, attrs.lastAccessTime().to(TimeUnit.MICROSECONDS), attrs.lastModifiedTime().to(TimeUnit.MICROSECONDS), target);
                        } else {
                            UnixNativeDispatcher.utimes(target, attrs.lastAccessTime().to(TimeUnit.MICROSECONDS), attrs.lastModifiedTime().to(TimeUnit.MICROSECONDS));
                        }
                    }
                    catch (UnixException x) {
                        if (!flags.failIfUnableToCopyBasic) break block33;
                        x.rethrowAsIOException(target);
                    }
                }
            }
            done = true;
        }
        finally {
            if (dfd >= 0) {
                UnixNativeDispatcher.close(dfd);
            }
            if (!done) {
                try {
                    UnixNativeDispatcher.rmdir(target);
                }
                catch (UnixException unixException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(UnixPath source, UnixFileAttributes attrs, UnixPath target, Flags flags, long addressToPollForCancel) throws IOException {
        int fi = -1;
        try {
            fi = UnixNativeDispatcher.open(source, 0, 0);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(source);
        }
        try {
            int fo = -1;
            try {
                fo = UnixNativeDispatcher.open(target, 193, attrs.mode());
            }
            catch (UnixException x) {
                x.rethrowAsIOException(target);
            }
            boolean complete = false;
            try {
                block27: {
                    block26: {
                        try {
                            UnixCopyFile.transfer(fo, fi, addressToPollForCancel);
                        }
                        catch (UnixException x) {
                            x.rethrowAsIOException(source, target);
                        }
                        if (flags.copyPosixAttributes) {
                            try {
                                UnixNativeDispatcher.fchown(fo, attrs.uid(), attrs.gid());
                                UnixNativeDispatcher.fchmod(fo, attrs.mode());
                            }
                            catch (UnixException x) {
                                if (!flags.failIfUnableToCopyPosix) break block26;
                                x.rethrowAsIOException(target);
                            }
                        }
                    }
                    if (flags.copyNonPosixAttributes) {
                        source.getFileSystem().copyNonPosixAttributes(fi, fo);
                    }
                    if (flags.copyBasicAttributes) {
                        try {
                            if (UnixNativeDispatcher.futimesSupported()) {
                                UnixNativeDispatcher.futimes(fo, attrs.lastAccessTime().to(TimeUnit.MICROSECONDS), attrs.lastModifiedTime().to(TimeUnit.MICROSECONDS), target);
                            } else {
                                UnixNativeDispatcher.utimes(target, attrs.lastAccessTime().to(TimeUnit.MICROSECONDS), attrs.lastModifiedTime().to(TimeUnit.MICROSECONDS));
                            }
                        }
                        catch (UnixException x) {
                            if (!flags.failIfUnableToCopyBasic) break block27;
                            x.rethrowAsIOException(target);
                        }
                    }
                }
                complete = true;
            }
            finally {
                UnixNativeDispatcher.close(fo);
                if (!complete) {
                    try {
                        UnixNativeDispatcher.unlink(target);
                    }
                    catch (UnixException unixException) {}
                }
            }
        }
        finally {
            UnixNativeDispatcher.close(fi);
        }
    }

    private static void copyLink(UnixPath source, UnixFileAttributes attrs, UnixPath target, Flags flags) throws IOException {
        byte[] linktarget = null;
        try {
            linktarget = UnixNativeDispatcher.readlink(source);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(source);
        }
        try {
            UnixNativeDispatcher.symlink(linktarget, target);
            if (flags.copyPosixAttributes) {
                try {
                    UnixNativeDispatcher.lchown(target, attrs.uid(), attrs.gid());
                }
                catch (UnixException x) {}
            }
        }
        catch (UnixException x) {
            x.rethrowAsIOException(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySpecial(UnixPath source, UnixFileAttributes attrs, UnixPath target, Flags flags) throws IOException {
        try {
            UnixNativeDispatcher.mknod(target, attrs.mode(), attrs.rdev());
        }
        catch (UnixException x) {
            x.rethrowAsIOException(target);
        }
        boolean done = false;
        try {
            block17: {
                block16: {
                    if (flags.copyPosixAttributes) {
                        try {
                            UnixNativeDispatcher.chown(target, attrs.uid(), attrs.gid());
                            UnixNativeDispatcher.chmod(target, attrs.mode());
                        }
                        catch (UnixException x) {
                            if (!flags.failIfUnableToCopyPosix) break block16;
                            x.rethrowAsIOException(target);
                        }
                    }
                }
                if (flags.copyBasicAttributes) {
                    try {
                        UnixNativeDispatcher.utimes(target, attrs.lastAccessTime().to(TimeUnit.MICROSECONDS), attrs.lastModifiedTime().to(TimeUnit.MICROSECONDS));
                    }
                    catch (UnixException x) {
                        if (!flags.failIfUnableToCopyBasic) break block17;
                        x.rethrowAsIOException(target);
                    }
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                try {
                    UnixNativeDispatcher.unlink(target);
                }
                catch (UnixException unixException) {}
            }
        }
    }

    static void move(UnixPath source, UnixPath target, CopyOption ... options) throws IOException {
        boolean targetExists;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            source.checkWrite();
            target.checkWrite();
        }
        Flags flags = Flags.fromMoveOptions(options);
        if (flags.atomicMove) {
            try {
                UnixNativeDispatcher.rename(source, target);
            }
            catch (UnixException x) {
                if (x.errno() == 18) {
                    throw new AtomicMoveNotSupportedException(source.getPathForExceptionMessage(), target.getPathForExceptionMessage(), x.errorString());
                }
                x.rethrowAsIOException(source, target);
            }
            return;
        }
        UnixFileAttributes sourceAttrs = null;
        UnixFileAttributes targetAttrs = null;
        try {
            sourceAttrs = UnixFileAttributes.get(source, false);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(source);
        }
        try {
            targetAttrs = UnixFileAttributes.get(target, false);
        }
        catch (UnixException x) {
            // empty catch block
        }
        boolean bl = targetExists = targetAttrs != null;
        if (targetExists) {
            if (sourceAttrs.isSameFile(targetAttrs)) {
                return;
            }
            if (!flags.replaceExisting) {
                throw new FileAlreadyExistsException(target.getPathForExceptionMessage());
            }
            try {
                if (targetAttrs.isDirectory()) {
                    UnixNativeDispatcher.rmdir(target);
                } else {
                    UnixNativeDispatcher.unlink(target);
                }
            }
            catch (UnixException x) {
                if (targetAttrs.isDirectory() && (x.errno() == 17 || x.errno() == 39)) {
                    DirectoryNotEmptyException dex = new DirectoryNotEmptyException(target.getPathForExceptionMessage());
                    dex.initCause(x);
                    throw dex;
                }
                x.rethrowAsIOException(target);
            }
        }
        int renameErrno = -1;
        try {
            UnixNativeDispatcher.rename(source, target);
            return;
        }
        catch (UnixException x1) {
            renameErrno = x1.errno();
            if (x1.errno() != 18 && x1.errno() != 21) {
                x1.rethrowAsIOException(source, target);
            }
            if (sourceAttrs.isDirectory()) {
                UnixCopyFile.copyDirectory(source, sourceAttrs, target, flags);
            } else if (sourceAttrs.isSymbolicLink()) {
                UnixCopyFile.copyLink(source, sourceAttrs, target, flags);
            } else if (sourceAttrs.isDevice()) {
                UnixCopyFile.copySpecial(source, sourceAttrs, target, flags);
            } else {
                UnixCopyFile.copyFile(source, sourceAttrs, target, flags, 0L);
            }
            try {
                if (sourceAttrs.isDirectory()) {
                    UnixNativeDispatcher.rmdir(source);
                } else {
                    UnixNativeDispatcher.unlink(source);
                }
            }
            catch (UnixException x) {
                try {
                    if (sourceAttrs.isDirectory()) {
                        UnixNativeDispatcher.rmdir(target);
                    } else {
                        UnixNativeDispatcher.unlink(target);
                    }
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
                if (sourceAttrs.isDirectory() && (x.errno() == 17 || x.errno() == 39)) {
                    DirectoryNotEmptyException dex = renameErrno == -1 ? new DirectoryNotEmptyException(source.getPathForExceptionMessage()) : new DirectoryNotEmptyException(source.getPathForExceptionMessage() + ", previous rename error was " + renameErrno);
                    dex.initCause(x);
                    throw dex;
                }
                x.rethrowAsIOException(source);
            }
            return;
        }
    }

    static void copy(final UnixPath source, final UnixPath target, CopyOption ... options) throws IOException {
        boolean targetExists;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            source.checkRead();
            target.checkWrite();
        }
        final Flags flags = Flags.fromCopyOptions(options);
        UnixFileAttributes sourceAttrs = null;
        UnixFileAttributes targetAttrs = null;
        try {
            sourceAttrs = UnixFileAttributes.get(source, flags.followLinks);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(source);
        }
        if (sm != null && sourceAttrs.isSymbolicLink()) {
            sm.checkPermission(new LinkPermission("symbolic"));
        }
        try {
            targetAttrs = UnixFileAttributes.get(target, false);
        }
        catch (UnixException x) {
            // empty catch block
        }
        boolean bl = targetExists = targetAttrs != null;
        if (targetExists) {
            if (sourceAttrs.isSameFile(targetAttrs)) {
                return;
            }
            if (!flags.replaceExisting) {
                throw new FileAlreadyExistsException(target.getPathForExceptionMessage());
            }
            try {
                if (targetAttrs.isDirectory()) {
                    UnixNativeDispatcher.rmdir(target);
                } else {
                    UnixNativeDispatcher.unlink(target);
                }
            }
            catch (UnixException x) {
                if (targetAttrs.isDirectory() && (x.errno() == 17 || x.errno() == 39)) {
                    DirectoryNotEmptyException dex = new DirectoryNotEmptyException(target.getPathForExceptionMessage());
                    dex.initCause(x);
                    throw dex;
                }
                x.rethrowAsIOException(target);
            }
        }
        if (sourceAttrs.isDirectory()) {
            UnixCopyFile.copyDirectory(source, sourceAttrs, target, flags);
            return;
        }
        if (sourceAttrs.isSymbolicLink()) {
            UnixCopyFile.copyLink(source, sourceAttrs, target, flags);
            return;
        }
        if (!flags.interruptible) {
            UnixCopyFile.copyFile(source, sourceAttrs, target, flags, 0L);
            return;
        }
        final UnixFileAttributes attrsToCopy = sourceAttrs;
        Cancellable copyTask = new Cancellable(){

            @Override
            public void implRun() throws IOException {
                UnixCopyFile.copyFile(source, attrsToCopy, target, flags, this.addressToPollForCancel());
            }
        };
        try {
            Cancellable.runInterruptibly(copyTask);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
    }

    static native void transfer(int var0, int var1, long var2) throws UnixException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
    }

    private static class Flags {
        boolean replaceExisting;
        boolean atomicMove;
        boolean followLinks;
        boolean interruptible;
        boolean copyBasicAttributes;
        boolean copyPosixAttributes;
        boolean copyNonPosixAttributes;
        boolean failIfUnableToCopyBasic;
        boolean failIfUnableToCopyPosix;
        boolean failIfUnableToCopyNonPosix;

        private Flags() {
        }

        static Flags fromCopyOptions(CopyOption ... options) {
            Flags flags = new Flags();
            flags.followLinks = true;
            for (CopyOption option : options) {
                if (option == StandardCopyOption.REPLACE_EXISTING) {
                    flags.replaceExisting = true;
                    continue;
                }
                if (option == LinkOption.NOFOLLOW_LINKS) {
                    flags.followLinks = false;
                    continue;
                }
                if (option == StandardCopyOption.COPY_ATTRIBUTES) {
                    flags.copyBasicAttributes = true;
                    flags.copyPosixAttributes = true;
                    flags.copyNonPosixAttributes = true;
                    flags.failIfUnableToCopyBasic = true;
                    continue;
                }
                if (option == ExtendedCopyOption.INTERRUPTIBLE) {
                    flags.interruptible = true;
                    continue;
                }
                if (option == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException("Unsupported copy option");
            }
            return flags;
        }

        static Flags fromMoveOptions(CopyOption ... options) {
            Flags flags = new Flags();
            for (CopyOption option : options) {
                if (option == StandardCopyOption.ATOMIC_MOVE) {
                    flags.atomicMove = true;
                    continue;
                }
                if (option == StandardCopyOption.REPLACE_EXISTING) {
                    flags.replaceExisting = true;
                    continue;
                }
                if (option == LinkOption.NOFOLLOW_LINKS) continue;
                if (option == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException("Unsupported copy option");
            }
            flags.copyBasicAttributes = true;
            flags.copyPosixAttributes = true;
            flags.copyNonPosixAttributes = true;
            flags.failIfUnableToCopyBasic = true;
            return flags;
        }
    }
}

