/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.image.ByteInterleavedRaster;
import sun.print.CustomMediaSizeName;
import sun.print.DialogOnTop;
import sun.print.OpenBook;
import sun.print.PageableDoc;
import sun.print.PathGraphics;
import sun.print.PeekGraphics;
import sun.print.PrinterGraphicsConfig;
import sun.print.PrinterJobWrapper;
import sun.print.ProxyGraphics2D;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;
import sun.print.SunMinMaxPage;
import sun.print.SunPageSelection;
import sun.print.SunPrinterJobService;
import sun.security.action.GetPropertyAction;

public abstract class RasterPrinterJob
extends PrinterJob {
    protected static final int PRINTER = 0;
    protected static final int FILE = 1;
    protected static final int STREAM = 2;
    protected static final int MAX_UNKNOWN_PAGES = 9999;
    protected static final int PD_ALLPAGES = 0;
    protected static final int PD_SELECTION = 1;
    protected static final int PD_PAGENUMS = 2;
    protected static final int PD_NOSELECTION = 4;
    private static final int MAX_BAND_SIZE = 0x400000;
    private static final float DPI = 72.0f;
    private static final String FORCE_PIPE_PROP = "sun.java2d.print.pipeline";
    private static final String FORCE_RASTER = "raster";
    private static final String FORCE_PDL = "pdl";
    private static final String SHAPE_TEXT_PROP = "sun.java2d.print.shapetext";
    public static boolean forcePDL;
    public static boolean forceRaster;
    public static boolean shapeTextProp;
    private int cachedBandWidth = 0;
    private int cachedBandHeight = 0;
    private BufferedImage cachedBand = null;
    private int mNumCopies = 1;
    private boolean mCollate = false;
    private int mFirstPage = -1;
    private int mLastPage = -1;
    private Paper previousPaper;
    protected Pageable mDocument = new Book();
    private String mDocName = "Java Printing";
    protected boolean performingPrinting = false;
    protected boolean userCancelled = false;
    private FilePermission printToFilePermission;
    private ArrayList redrawList = new ArrayList();
    private int copiesAttr;
    private String jobNameAttr;
    private String userNameAttr;
    private PageRanges pageRangesAttr;
    protected Sides sidesAttr;
    protected String destinationAttr;
    protected boolean noJobSheet = false;
    protected int mDestType = 1;
    protected String mDestination = "";
    protected boolean collateAttReq = false;
    protected boolean landscapeRotates270 = false;
    protected PrintRequestAttributeSet attributes = null;
    protected PrintService myService;
    private static final String SUN_PRINT_RASTERPRINT_DEBUG = "sun.print.rasterprint.debug";
    public static boolean debugPrint;
    private int deviceWidth;
    private int deviceHeight;
    private AffineTransform defaultDeviceTransform;
    private PrinterGraphicsConfig pgConfig;
    private DialogOnTop onTop = null;
    private long parentWindowID = 0L;

    protected abstract double getXRes();

    protected abstract double getYRes();

    protected abstract double getPhysicalPrintableX(Paper var1);

    protected abstract double getPhysicalPrintableY(Paper var1);

    protected abstract double getPhysicalPrintableWidth(Paper var1);

    protected abstract double getPhysicalPrintableHeight(Paper var1);

    protected abstract double getPhysicalPageWidth(Paper var1);

    protected abstract double getPhysicalPageHeight(Paper var1);

    protected abstract void startPage(PageFormat var1, Printable var2, int var3, boolean var4) throws PrinterException;

    protected abstract void endPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected abstract void printBand(byte[] var1, int var2, int var3, int var4, int var5) throws PrinterException;

    public void saveState(AffineTransform at, Shape clip, Rectangle2D region, double sx, double sy) {
        GraphicsState gstate = new GraphicsState();
        gstate.theTransform = at;
        gstate.theClip = clip;
        gstate.region = region;
        gstate.sx = sx;
        gstate.sy = sy;
        this.redrawList.add(gstate);
    }

    protected static PrintService lookupDefaultPrintService() {
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        if (service != null && service.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && service.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
            return service;
        }
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (services.length > 0) {
            return services[0];
        }
        return null;
    }

    @Override
    public PrintService getPrintService() {
        if (this.myService == null) {
            PrintService[] svcs;
            PrintService svc = PrintServiceLookup.lookupDefaultPrintService();
            if (svc != null && svc.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE)) {
                try {
                    this.setPrintService(svc);
                    this.myService = svc;
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
            if (this.myService == null && (svcs = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)).length > 0) {
                try {
                    this.setPrintService(svcs[0]);
                    this.myService = svcs[0];
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        }
        return this.myService;
    }

    @Override
    public void setPrintService(PrintService service) throws PrinterException {
        PrinterStateReasons prnStateReasons;
        if (service == null) {
            throw new PrinterException("Service cannot be null");
        }
        if (!(service instanceof StreamPrintService) && service.getName() == null) {
            throw new PrinterException("Null PrintService name.");
        }
        PrinterState prnState = service.getAttribute(PrinterState.class);
        if (prnState == PrinterState.STOPPED && (prnStateReasons = service.getAttribute(PrinterStateReasons.class)) != null && prnStateReasons.containsKey(PrinterStateReason.SHUTDOWN)) {
            throw new PrinterException("PrintService is no longer available.");
        }
        if (!service.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || !service.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
            throw new PrinterException("Not a 2D print service: " + service);
        }
        this.myService = service;
    }

    private PageFormat attributeToPageFormat(PrintService service, PrintRequestAttributeSet attSet) {
        PageFormat page = this.defaultPage();
        if (service == null) {
            return page;
        }
        OrientationRequested orient = (OrientationRequested)attSet.get(OrientationRequested.class);
        if (orient == null) {
            orient = (OrientationRequested)service.getDefaultAttributeValue(OrientationRequested.class);
        }
        if (orient == OrientationRequested.REVERSE_LANDSCAPE) {
            page.setOrientation(2);
        } else if (orient == OrientationRequested.LANDSCAPE) {
            page.setOrientation(0);
        } else {
            page.setOrientation(1);
        }
        Media media = (Media)attSet.get(Media.class);
        MediaSize size = this.getMediaSize(media, service, page);
        Paper paper = new Paper();
        float[] dim = size.getSize(1);
        double w = Math.rint((double)dim[0] * 72.0 / 25400.0);
        double h = Math.rint((double)dim[1] * 72.0 / 25400.0);
        paper.setSize(w, h);
        MediaPrintableArea area = (MediaPrintableArea)attSet.get(MediaPrintableArea.class);
        if (area == null) {
            area = this.getDefaultPrintableArea(page, w, h);
        }
        double ix = Math.rint(area.getX(25400) * 72.0f);
        double iy = Math.rint(area.getY(25400) * 72.0f);
        double iw = Math.rint(area.getWidth(25400) * 72.0f);
        double ih = Math.rint(area.getHeight(25400) * 72.0f);
        paper.setImageableArea(ix, iy, iw, ih);
        page.setPaper(paper);
        return page;
    }

    protected MediaSize getMediaSize(Media media, PrintService service, PageFormat page) {
        MediaSize size;
        if (media == null) {
            media = (Media)service.getDefaultAttributeValue(Media.class);
        }
        if (!(media instanceof MediaSizeName)) {
            media = MediaSizeName.NA_LETTER;
        }
        return (size = MediaSize.getMediaSizeForName((MediaSizeName)media)) != null ? size : MediaSize.NA.LETTER;
    }

    protected MediaPrintableArea getDefaultPrintableArea(PageFormat page, double w, double h) {
        double ih;
        double iy;
        double iw;
        double ix;
        if (w >= 432.0) {
            ix = 72.0;
            iw = w - 144.0;
        } else {
            ix = w / 6.0;
            iw = w * 0.75;
        }
        if (h >= 432.0) {
            iy = 72.0;
            ih = h - 144.0;
        } else {
            iy = h / 6.0;
            ih = h * 0.75;
        }
        return new MediaPrintableArea((float)(ix / 72.0), (float)(iy / 72.0), (float)(iw / 72.0), (float)(ih / 72.0), 25400);
    }

    protected void updatePageAttributes(PrintService service, PageFormat page) {
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        this.updateAttributesWithPageFormat(service, page, this.attributes);
    }

    protected void updateAttributesWithPageFormat(PrintService service, PageFormat page, PrintRequestAttributeSet pageAttributes) {
        OrientationRequested orient;
        if (service == null || page == null || pageAttributes == null) {
            return;
        }
        float x = (float)Math.rint(page.getPaper().getWidth() * 25400.0 / 72.0) / 25400.0f;
        float y = (float)Math.rint(page.getPaper().getHeight() * 25400.0 / 72.0) / 25400.0f;
        Media[] mediaList = (Media[])service.getSupportedAttributeValues(Media.class, null, null);
        Media media = null;
        try {
            media = CustomMediaSizeName.findMedia(mediaList, x, y, 25400);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (media == null || !service.isAttributeValueSupported(media, null, null)) {
            media = (Media)service.getDefaultAttributeValue(Media.class);
        }
        switch (page.getOrientation()) {
            case 0: {
                orient = OrientationRequested.LANDSCAPE;
                break;
            }
            case 2: {
                orient = OrientationRequested.REVERSE_LANDSCAPE;
                break;
            }
            default: {
                orient = OrientationRequested.PORTRAIT;
            }
        }
        if (media != null) {
            pageAttributes.add(media);
        }
        pageAttributes.add(orient);
        float ix = (float)(page.getPaper().getImageableX() / 72.0);
        float iw = (float)(page.getPaper().getImageableWidth() / 72.0);
        float iy = (float)(page.getPaper().getImageableY() / 72.0);
        float ih = (float)(page.getPaper().getImageableHeight() / 72.0);
        if (ix < 0.0f) {
            ix = 0.0f;
        }
        if (iy < 0.0f) {
            iy = 0.0f;
        }
        try {
            pageAttributes.add(new MediaPrintableArea(ix, iy, iw, ih, 25400));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public PageFormat pageDialog(PageFormat page) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        final GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        PrintService service = (PrintService)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrintService service = RasterPrinterJob.this.getPrintService();
                if (service == null) {
                    ServiceDialog.showNoPrintService(gc);
                    return null;
                }
                return service;
            }
        });
        if (service == null) {
            return page;
        }
        this.updatePageAttributes(service, page);
        PageFormat newPage = null;
        DialogTypeSelection dts = (DialogTypeSelection)this.attributes.get(DialogTypeSelection.class);
        if (dts == DialogTypeSelection.NATIVE) {
            this.attributes.remove(DialogTypeSelection.class);
            newPage = this.pageDialog(this.attributes);
            this.attributes.add(DialogTypeSelection.NATIVE);
        } else {
            newPage = this.pageDialog(this.attributes);
        }
        if (newPage == null) {
            return page;
        }
        return newPage;
    }

    @Override
    public PageFormat pageDialog(PrintRequestAttributeSet attributes) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        DialogTypeSelection dlg = (DialogTypeSelection)attributes.get(DialogTypeSelection.class);
        if (dlg == DialogTypeSelection.NATIVE) {
            PrintService pservice = this.getPrintService();
            PageFormat pageFrmAttrib = this.attributeToPageFormat(pservice, attributes);
            this.setParentWindowID(attributes);
            PageFormat page = this.pageDialog(pageFrmAttrib);
            this.clearParentWindowID();
            if (page == pageFrmAttrib) {
                return null;
            }
            this.updateAttributesWithPageFormat(pservice, page, attributes);
            return page;
        }
        final GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle bounds = gc.getBounds();
        int x = bounds.x + bounds.width / 3;
        int y = bounds.y + bounds.height / 3;
        PrintService service = (PrintService)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrintService service = RasterPrinterJob.this.getPrintService();
                if (service == null) {
                    ServiceDialog.showNoPrintService(gc);
                    return null;
                }
                return service;
            }
        });
        if (service == null) {
            return null;
        }
        if (this.onTop != null) {
            attributes.add(this.onTop);
        }
        ServiceDialog pageDialog = new ServiceDialog(gc, x, y, service, (DocFlavor)DocFlavor.SERVICE_FORMATTED.PAGEABLE, attributes, (Frame)null);
        pageDialog.show();
        if (pageDialog.getStatus() == 1) {
            PrintRequestAttributeSet newas = pageDialog.getAttributes();
            Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
            if (attributes.containsKey(amCategory) && !newas.containsKey(amCategory)) {
                attributes.remove(amCategory);
            }
            attributes.addAll(newas);
            return this.attributeToPageFormat(service, attributes);
        }
        return null;
    }

    protected PageFormat getPageFormatFromAttributes() {
        Pageable pageable = null;
        if (this.attributes == null || this.attributes.isEmpty() || !((pageable = this.getPageable()) instanceof OpenBook)) {
            return null;
        }
        PageFormat newPf = this.attributeToPageFormat(this.getPrintService(), this.attributes);
        PageFormat oldPf = null;
        oldPf = pageable.getPageFormat(0);
        if (oldPf != null) {
            if (this.attributes.get(OrientationRequested.class) == null) {
                newPf.setOrientation(oldPf.getOrientation());
            }
            Paper newPaper = newPf.getPaper();
            Paper oldPaper = oldPf.getPaper();
            boolean oldPaperValWasSet = false;
            if (this.attributes.get(MediaSizeName.class) == null) {
                newPaper.setSize(oldPaper.getWidth(), oldPaper.getHeight());
                oldPaperValWasSet = true;
            }
            if (this.attributes.get(MediaPrintableArea.class) == null) {
                newPaper.setImageableArea(oldPaper.getImageableX(), oldPaper.getImageableY(), oldPaper.getImageableWidth(), oldPaper.getImageableHeight());
                oldPaperValWasSet = true;
            }
            if (oldPaperValWasSet) {
                newPf.setPaper(newPaper);
            }
        }
        return newPf;
    }

    @Override
    public boolean printDialog(PrintRequestAttributeSet attributes) throws HeadlessException {
        PrintService newService;
        PrintService[] services;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        DialogTypeSelection dlg = (DialogTypeSelection)attributes.get(DialogTypeSelection.class);
        if (dlg == DialogTypeSelection.NATIVE) {
            this.attributes = attributes;
            try {
                this.debug_println("calling setAttributes in printDialog");
                this.setAttributes(attributes);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            this.setParentWindowID(attributes);
            boolean ret = this.printDialog();
            this.clearParentWindowID();
            this.attributes = attributes;
            return ret;
        }
        final GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        PrintService service = (PrintService)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrintService service = RasterPrinterJob.this.getPrintService();
                if (service == null) {
                    ServiceDialog.showNoPrintService(gc);
                    return null;
                }
                return service;
            }
        });
        if (service == null) {
            return false;
        }
        StreamPrintServiceFactory[] spsFactories = null;
        if (service instanceof StreamPrintService) {
            spsFactories = RasterPrinterJob.lookupStreamPrintServices(null);
            services = new StreamPrintService[spsFactories.length];
            for (int i = 0; i < spsFactories.length; ++i) {
                services[i] = spsFactories[i].getPrintService(null);
            }
        } else {
            services = (PrintService[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PrintService[] services = PrinterJob.lookupPrintServices();
                    return services;
                }
            });
            if (services == null || services.length == 0) {
                services = new PrintService[]{service};
            }
        }
        Rectangle bounds = gc.getBounds();
        int x = bounds.x + bounds.width / 3;
        int y = bounds.y + bounds.height / 3;
        PrinterJobWrapper jobWrapper = new PrinterJobWrapper(this);
        attributes.add(jobWrapper);
        try {
            newService = ServiceUI.printDialog(gc, x, y, services, service, DocFlavor.SERVICE_FORMATTED.PAGEABLE, attributes);
        }
        catch (IllegalArgumentException iae) {
            newService = ServiceUI.printDialog(gc, x, y, services, services[0], DocFlavor.SERVICE_FORMATTED.PAGEABLE, attributes);
        }
        attributes.remove(PrinterJobWrapper.class);
        if (newService == null) {
            return false;
        }
        if (!service.equals(newService)) {
            try {
                this.setPrintService(newService);
            }
            catch (PrinterException e) {
                this.myService = newService;
            }
        }
        return true;
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        attributes.add(new Copies(this.getCopies()));
        attributes.add(new JobName(this.getJobName(), null));
        boolean doPrint = this.printDialog(attributes);
        if (doPrint) {
            Destination dest;
            Copies copies;
            JobName jobName = (JobName)attributes.get(JobName.class);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)attributes.get(Copies.class)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((dest = (Destination)attributes.get(Destination.class)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(dest.getURI()).getPath();
                }
                catch (Exception e) {
                    Destination defaultDest;
                    this.mDestination = "out.prn";
                    PrintService ps = this.getPrintService();
                    if (ps != null && (defaultDest = (Destination)ps.getDefaultAttributeValue(Destination.class)) != null) {
                        this.mDestination = new File(defaultDest.getURI()).getPath();
                    }
                }
            } else {
                this.mDestType = 0;
                PrintService ps = this.getPrintService();
                if (ps != null) {
                    this.mDestination = ps.getName();
                }
            }
        }
        return doPrint;
    }

    @Override
    public void setPrintable(Printable painter) {
        this.setPageable(new OpenBook(this.defaultPage(new PageFormat()), painter));
    }

    @Override
    public void setPrintable(Printable painter, PageFormat format) {
        this.setPageable(new OpenBook(format, painter));
        this.updatePageAttributes(this.getPrintService(), format);
    }

    @Override
    public void setPageable(Pageable document) throws NullPointerException {
        if (document == null) {
            throw new NullPointerException();
        }
        this.mDocument = document;
    }

    protected void initPrinter() {
    }

    protected boolean isSupportedValue(Attribute attrval, PrintRequestAttributeSet attrset) {
        PrintService ps = this.getPrintService();
        return attrval != null && ps != null && ps.isAttributeValueSupported(attrval, DocFlavor.SERVICE_FORMATTED.PAGEABLE, attrset);
    }

    protected void setAttributes(PrintRequestAttributeSet attributes) throws PrinterException {
        JobName jobName;
        JobSheets jobSheets;
        boolean fidelity;
        PrintService service;
        block29: {
            AttributeSet unsupported;
            this.setCollated(false);
            this.sidesAttr = null;
            this.pageRangesAttr = null;
            this.copiesAttr = 0;
            this.jobNameAttr = null;
            this.userNameAttr = null;
            this.destinationAttr = null;
            this.collateAttReq = false;
            service = this.getPrintService();
            if (attributes == null || service == null) {
                return;
            }
            fidelity = false;
            Fidelity attrFidelity = (Fidelity)attributes.get(Fidelity.class);
            if (attrFidelity != null && attrFidelity == Fidelity.FIDELITY_TRUE) {
                fidelity = true;
            }
            if (fidelity && (unsupported = service.getUnsupportedAttributes(DocFlavor.SERVICE_FORMATTED.PAGEABLE, attributes)) != null) {
                throw new PrinterException("Fidelity cannot be satisfied");
            }
            SheetCollate collateAttr = (SheetCollate)attributes.get(SheetCollate.class);
            if (this.isSupportedValue(collateAttr, attributes)) {
                this.setCollated(collateAttr == SheetCollate.COLLATED);
            }
            this.sidesAttr = (Sides)attributes.get(Sides.class);
            if (!this.isSupportedValue(this.sidesAttr, attributes)) {
                this.sidesAttr = Sides.ONE_SIDED;
            }
            this.pageRangesAttr = (PageRanges)attributes.get(PageRanges.class);
            if (!this.isSupportedValue(this.pageRangesAttr, attributes)) {
                this.pageRangesAttr = null;
            } else if ((SunPageSelection)attributes.get(SunPageSelection.class) == SunPageSelection.RANGE) {
                int[][] range = this.pageRangesAttr.getMembers();
                this.setPageRange(range[0][0] - 1, range[0][1] - 1);
            } else {
                this.setPageRange(-1, -1);
            }
            Copies copies = (Copies)attributes.get(Copies.class);
            if (this.isSupportedValue(copies, attributes) || !fidelity && copies != null) {
                this.copiesAttr = copies.getValue();
                this.setCopies(this.copiesAttr);
            } else {
                this.copiesAttr = this.getCopies();
            }
            Destination destination = (Destination)attributes.get(Destination.class);
            if (this.isSupportedValue(destination, attributes)) {
                try {
                    this.destinationAttr = "" + new File(destination.getURI().getSchemeSpecificPart());
                }
                catch (Exception e) {
                    Destination defaultDest = (Destination)service.getDefaultAttributeValue(Destination.class);
                    if (defaultDest == null) break block29;
                    this.destinationAttr = "" + new File(defaultDest.getURI().getSchemeSpecificPart());
                }
            }
        }
        if ((jobSheets = (JobSheets)attributes.get(JobSheets.class)) != null) {
            boolean bl = this.noJobSheet = jobSheets == JobSheets.NONE;
        }
        if (this.isSupportedValue(jobName = (JobName)attributes.get(JobName.class), attributes) || !fidelity && jobName != null) {
            this.jobNameAttr = jobName.getValue();
            this.setJobName(this.jobNameAttr);
        } else {
            this.jobNameAttr = this.getJobName();
        }
        RequestingUserName userName = (RequestingUserName)attributes.get(RequestingUserName.class);
        if (this.isSupportedValue(userName, attributes) || !fidelity && userName != null) {
            this.userNameAttr = userName.getValue();
        } else {
            try {
                this.userNameAttr = this.getUserName();
            }
            catch (SecurityException e) {
                this.userNameAttr = "";
            }
        }
        Media media = (Media)attributes.get(Media.class);
        OrientationRequested orientReq = (OrientationRequested)attributes.get(OrientationRequested.class);
        MediaPrintableArea mpa = (MediaPrintableArea)attributes.get(MediaPrintableArea.class);
        if ((orientReq != null || media != null || mpa != null) && this.getPageable() instanceof OpenBook) {
            MediaSizeName msn;
            MediaSize msz;
            Object mpaVals;
            Pageable pageable = this.getPageable();
            Printable printable = pageable.getPrintable(0);
            PageFormat pf = (PageFormat)pageable.getPageFormat(0).clone();
            Paper paper = pf.getPaper();
            if (mpa == null && media != null && service.isAttributeCategorySupported(MediaPrintableArea.class) && (mpaVals = service.getSupportedAttributeValues(MediaPrintableArea.class, null, attributes)) instanceof MediaPrintableArea[] && ((MediaPrintableArea[])mpaVals).length > 0) {
                mpa = ((MediaPrintableArea[])mpaVals)[0];
            }
            if (this.isSupportedValue(orientReq, attributes) || !fidelity && orientReq != null) {
                int orient = orientReq.equals(OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (orientReq.equals(OrientationRequested.LANDSCAPE) ? 0 : 1);
                pf.setOrientation(orient);
            }
            if ((this.isSupportedValue(media, attributes) || !fidelity && media != null) && media instanceof MediaSizeName && (msz = MediaSize.getMediaSizeForName(msn = (MediaSizeName)media)) != null) {
                float paperWid = msz.getX(25400) * 72.0f;
                float paperHgt = msz.getY(25400) * 72.0f;
                paper.setSize(paperWid, paperHgt);
                if (mpa == null) {
                    paper.setImageableArea(72.0, 72.0, (double)paperWid - 144.0, (double)paperHgt - 144.0);
                }
            }
            if (this.isSupportedValue(mpa, attributes) || !fidelity && mpa != null) {
                float[] printableArea = mpa.getPrintableArea(25400);
                for (int i = 0; i < printableArea.length; ++i) {
                    printableArea[i] = printableArea[i] * 72.0f;
                }
                paper.setImageableArea(printableArea[0], printableArea[1], printableArea[2], printableArea[3]);
            }
            pf.setPaper(paper);
            pf = this.validatePage(pf);
            this.setPrintable(printable, pf);
        } else {
            this.attributes = attributes;
        }
    }

    protected void spoolToService(PrintService psvc, PrintRequestAttributeSet attributes) throws PrinterException {
        if (psvc == null) {
            throw new PrinterException("No print service found.");
        }
        DocPrintJob job = psvc.createPrintJob();
        PageableDoc doc = new PageableDoc(this.getPageable());
        if (attributes == null) {
            attributes = new HashPrintRequestAttributeSet();
        }
        try {
            job.print(doc, attributes);
        }
        catch (PrintException e) {
            throw new PrinterException(e.toString());
        }
    }

    @Override
    public void print() throws PrinterException {
        this.print(this.attributes);
    }

    protected void debug_println(String str) {
        if (debugPrint) {
            System.out.println("RasterPrinterJob " + str + " " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(PrintRequestAttributeSet attributes) throws PrinterException {
        int totalPages2;
        PrinterStateReasons prnStateReasons;
        PrintService psvc = this.getPrintService();
        this.debug_println("psvc = " + psvc);
        if (psvc == null) {
            throw new PrinterException("No print service found.");
        }
        PrinterState prnState = psvc.getAttribute(PrinterState.class);
        if (prnState == PrinterState.STOPPED && (prnStateReasons = psvc.getAttribute(PrinterStateReasons.class)) != null && prnStateReasons.containsKey(PrinterStateReason.SHUTDOWN)) {
            throw new PrinterException("PrintService is no longer available.");
        }
        if (psvc.getAttribute(PrinterIsAcceptingJobs.class) == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
            throw new PrinterException("Printer is not accepting job.");
        }
        if (psvc instanceof SunPrinterJobService && ((SunPrinterJobService)((Object)psvc)).usesClass(this.getClass())) {
            this.setAttributes(attributes);
            if (this.destinationAttr != null) {
                this.validateDestination(this.destinationAttr);
            }
        } else {
            this.spoolToService(psvc, attributes);
            return;
        }
        this.initPrinter();
        int numCollatedCopies = this.getCollatedCopies();
        int numNonCollatedCopies = this.getNoncollatedCopies();
        this.debug_println("getCollatedCopies()  " + numCollatedCopies + " getNoncollatedCopies() " + numNonCollatedCopies);
        int numPages = this.mDocument.getNumberOfPages();
        if (numPages == 0) {
            return;
        }
        int firstPage = this.getFirstPage();
        int lastPage = this.getLastPage();
        if (lastPage == -1 && (totalPages2 = this.mDocument.getNumberOfPages()) != -1) {
            lastPage = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            SunPageSelection pages;
            RasterPrinterJob totalPages2 = this;
            synchronized (totalPages2) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            this.startDoc();
            if (this.isCancelled()) {
                this.cancelDoc();
            }
            boolean rangeIsSelected = true;
            if (attributes != null && (pages = (SunPageSelection)attributes.get(SunPageSelection.class)) != null && pages != SunPageSelection.RANGE) {
                rangeIsSelected = false;
            }
            this.debug_println("after startDoc rangeSelected? " + rangeIsSelected + " numNonCollatedCopies " + numNonCollatedCopies);
            block12: for (int collated = 0; collated < numCollatedCopies; ++collated) {
                int pageResult = 0;
                for (int i = firstPage; (i <= lastPage || lastPage == -1) && pageResult == 0; ++i) {
                    if (this.pageRangesAttr != null && rangeIsSelected) {
                        int nexti = this.pageRangesAttr.next(i);
                        if (nexti == -1) continue block12;
                        if (nexti != i + 1) continue;
                    }
                    for (int nonCollated = 0; nonCollated < numNonCollatedCopies && pageResult == 0; ++nonCollated) {
                        if (this.isCancelled()) {
                            this.cancelDoc();
                        }
                        this.debug_println("printPage " + i);
                        pageResult = this.printPage(this.mDocument, i);
                    }
                }
            }
            if (this.isCancelled()) {
                this.cancelDoc();
            }
        }
        finally {
            this.previousPaper = null;
            RasterPrinterJob rasterPrinterJob = this;
            synchronized (rasterPrinterJob) {
                if (this.performingPrinting) {
                    this.endDoc();
                }
                this.performingPrinting = false;
                this.notify();
            }
        }
    }

    protected void validateDestination(String dest) throws PrinterException {
        if (dest == null) {
            return;
        }
        File f = new File(dest);
        try {
            if (f.createNewFile()) {
                f.delete();
            }
        }
        catch (IOException ioe) {
            throw new PrinterException("Cannot write to file:" + dest);
        }
        catch (SecurityException ioe) {
            // empty catch block
        }
        File pFile = f.getParentFile();
        if (f.exists() && (!f.isFile() || !f.canWrite()) || pFile != null && (!pFile.exists() || pFile.exists() && !pFile.canWrite())) {
            throw new PrinterException("Cannot write to file:" + dest);
        }
    }

    protected void validatePaper(Paper origPaper, Paper newPaper) {
        if (origPaper == null || newPaper == null) {
            return;
        }
        double wid = origPaper.getWidth();
        double hgt = origPaper.getHeight();
        double ix = origPaper.getImageableX();
        double iy = origPaper.getImageableY();
        double iw = origPaper.getImageableWidth();
        double ih = origPaper.getImageableHeight();
        Paper defaultPaper = new Paper();
        wid = wid > 0.0 ? wid : defaultPaper.getWidth();
        hgt = hgt > 0.0 ? hgt : defaultPaper.getHeight();
        ix = ix > 0.0 ? ix : defaultPaper.getImageableX();
        iy = iy > 0.0 ? iy : defaultPaper.getImageableY();
        iw = iw > 0.0 ? iw : defaultPaper.getImageableWidth();
        double d = ih = ih > 0.0 ? ih : defaultPaper.getImageableHeight();
        if (iw > wid) {
            iw = wid;
        }
        if (ih > hgt) {
            ih = hgt;
        }
        if (ix + iw > wid) {
            ix = wid - iw;
        }
        if (iy + ih > hgt) {
            iy = hgt - ih;
        }
        newPaper.setSize(wid, hgt);
        newPaper.setImageableArea(ix, iy, iw, ih);
    }

    @Override
    public PageFormat defaultPage(PageFormat page) {
        MediaSize size;
        PageFormat newPage = (PageFormat)page.clone();
        newPage.setOrientation(1);
        Paper newPaper = new Paper();
        double ptsPerInch = 72.0;
        Media media = null;
        PrintService service = this.getPrintService();
        if (service != null && (media = (Media)service.getDefaultAttributeValue(Media.class)) instanceof MediaSizeName && (size = MediaSize.getMediaSizeForName((MediaSizeName)media)) != null) {
            double w = (double)size.getX(25400) * ptsPerInch;
            double h = (double)size.getY(25400) * ptsPerInch;
            newPaper.setSize(w, h);
            newPaper.setImageableArea(ptsPerInch, ptsPerInch, w - 2.0 * ptsPerInch, h - 2.0 * ptsPerInch);
            newPage.setPaper(newPaper);
            return newPage;
        }
        String defaultCountry = Locale.getDefault().getCountry();
        if (!(Locale.getDefault().equals(Locale.ENGLISH) || defaultCountry == null || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
            double mmPerInch = 25.4;
            double w = Math.rint(210.0 * ptsPerInch / mmPerInch);
            double h = Math.rint(297.0 * ptsPerInch / mmPerInch);
            newPaper.setSize(w, h);
            newPaper.setImageableArea(ptsPerInch, ptsPerInch, w - 2.0 * ptsPerInch, h - 2.0 * ptsPerInch);
        }
        newPage.setPaper(newPaper);
        return newPage;
    }

    @Override
    public PageFormat validatePage(PageFormat page) {
        PageFormat newPage = (PageFormat)page.clone();
        Paper newPaper = new Paper();
        this.validatePaper(newPage.getPaper(), newPaper);
        newPage.setPaper(newPaper);
        return newPage;
    }

    @Override
    public void setCopies(int copies) {
        this.mNumCopies = copies;
    }

    @Override
    public int getCopies() {
        return this.mNumCopies;
    }

    protected int getCopiesInt() {
        return this.copiesAttr > 0 ? this.copiesAttr : this.getCopies();
    }

    @Override
    public String getUserName() {
        return System.getProperty("user.name");
    }

    protected String getUserNameInt() {
        if (this.userNameAttr != null) {
            return this.userNameAttr;
        }
        try {
            return this.getUserName();
        }
        catch (SecurityException e) {
            return "";
        }
    }

    @Override
    public void setJobName(String jobName) {
        if (jobName == null) {
            throw new NullPointerException();
        }
        this.mDocName = jobName;
    }

    @Override
    public String getJobName() {
        return this.mDocName;
    }

    protected String getJobNameInt() {
        return this.jobNameAttr != null ? this.jobNameAttr : this.getJobName();
    }

    protected void setPageRange(int firstPage, int lastPage) {
        if (firstPage >= 0 && lastPage >= 0) {
            this.mFirstPage = firstPage;
            this.mLastPage = lastPage;
            if (this.mLastPage < this.mFirstPage) {
                this.mLastPage = this.mFirstPage;
            }
        } else {
            this.mFirstPage = -1;
            this.mLastPage = -1;
        }
    }

    protected int getFirstPage() {
        return this.mFirstPage == -1 ? 0 : this.mFirstPage;
    }

    protected int getLastPage() {
        return this.mLastPage;
    }

    protected void setCollated(boolean collate) {
        this.mCollate = collate;
        this.collateAttReq = true;
    }

    protected boolean isCollated() {
        return this.mCollate;
    }

    protected final int getSelectAttrib() {
        if (this.attributes != null) {
            SunPageSelection pages = (SunPageSelection)this.attributes.get(SunPageSelection.class);
            if (pages == SunPageSelection.RANGE) {
                return 2;
            }
            if (pages == SunPageSelection.SELECTION) {
                return 1;
            }
            if (pages == SunPageSelection.ALL) {
                return 0;
            }
        }
        return 4;
    }

    protected final int getFromPageAttrib() {
        PageRanges pageRangesAttr;
        if (this.attributes != null && (pageRangesAttr = (PageRanges)this.attributes.get(PageRanges.class)) != null) {
            int[][] range = pageRangesAttr.getMembers();
            return range[0][0];
        }
        return this.getMinPageAttrib();
    }

    protected final int getToPageAttrib() {
        PageRanges pageRangesAttr;
        if (this.attributes != null && (pageRangesAttr = (PageRanges)this.attributes.get(PageRanges.class)) != null) {
            int[][] range = pageRangesAttr.getMembers();
            return range[range.length - 1][1];
        }
        return this.getMaxPageAttrib();
    }

    protected final int getMinPageAttrib() {
        SunMinMaxPage s;
        if (this.attributes != null && (s = (SunMinMaxPage)this.attributes.get(SunMinMaxPage.class)) != null) {
            return s.getMin();
        }
        return 1;
    }

    protected final int getMaxPageAttrib() {
        SunMinMaxPage s;
        if (this.attributes != null && (s = (SunMinMaxPage)this.attributes.get(SunMinMaxPage.class)) != null) {
            return s.getMax();
        }
        Pageable pageable = this.getPageable();
        if (pageable != null) {
            int numPages = pageable.getNumberOfPages();
            if (numPages <= -1) {
                numPages = 9999;
            }
            return numPages == 0 ? 1 : numPages;
        }
        return Integer.MAX_VALUE;
    }

    protected abstract void startDoc() throws PrinterException;

    protected abstract void endDoc() throws PrinterException;

    protected abstract void abortDoc();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelDoc() throws PrinterAbortException {
        this.abortDoc();
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            this.userCancelled = false;
            this.performingPrinting = false;
            this.notify();
        }
        throw new PrinterAbortException();
    }

    protected int getCollatedCopies() {
        return this.isCollated() ? this.getCopiesInt() : 1;
    }

    protected int getNoncollatedCopies() {
        return this.isCollated() ? 1 : this.getCopiesInt();
    }

    synchronized void setGraphicsConfigInfo(AffineTransform at, double pw, double ph) {
        Point2D.Double pt = new Point2D.Double(pw, ph);
        at.transform(pt, pt);
        if (this.pgConfig == null || this.defaultDeviceTransform == null || !at.equals(this.defaultDeviceTransform) || this.deviceWidth != (int)pt.getX() || this.deviceHeight != (int)pt.getY()) {
            this.deviceWidth = (int)pt.getX();
            this.deviceHeight = (int)pt.getY();
            this.defaultDeviceTransform = at;
            this.pgConfig = null;
        }
    }

    synchronized PrinterGraphicsConfig getPrinterGraphicsConfig() {
        if (this.pgConfig != null) {
            return this.pgConfig;
        }
        String deviceID = "Printer Device";
        PrintService service = this.getPrintService();
        if (service != null) {
            deviceID = service.toString();
        }
        this.pgConfig = new PrinterGraphicsConfig(deviceID, this.defaultDeviceTransform, this.deviceWidth, this.deviceHeight);
        return this.pgConfig;
    }

    protected int printPage(Pageable document, int pageIndex) throws PrinterException {
        Printable painter;
        PageFormat page;
        PageFormat origPage;
        try {
            origPage = document.getPageFormat(pageIndex);
            page = (PageFormat)origPage.clone();
            painter = document.getPrintable(pageIndex);
        }
        catch (Exception e) {
            PrinterException pe = new PrinterException("Error getting page or printable.[ " + e + " ]");
            pe.initCause(e);
            throw pe;
        }
        Paper paper = page.getPaper();
        if (page.getOrientation() != 1 && this.landscapeRotates270) {
            double left = paper.getImageableX();
            double top = paper.getImageableY();
            double width = paper.getImageableWidth();
            double height = paper.getImageableHeight();
            paper.setImageableArea(paper.getWidth() - left - width, paper.getHeight() - top - height, width, height);
            page.setPaper(paper);
            if (page.getOrientation() == 0) {
                page.setOrientation(2);
            } else {
                page.setOrientation(0);
            }
        }
        double xScale = this.getXRes() / 72.0;
        double yScale = this.getYRes() / 72.0;
        Rectangle2D.Double deviceArea = new Rectangle2D.Double(paper.getImageableX() * xScale, paper.getImageableY() * yScale, paper.getImageableWidth() * xScale, paper.getImageableHeight() * yScale);
        AffineTransform uniformTransform = new AffineTransform();
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.scale(xScale, yScale);
        int bandWidth = (int)((RectangularShape)deviceArea).getWidth();
        if (bandWidth % 4 != 0) {
            bandWidth += 4 - bandWidth % 4;
        }
        if (bandWidth <= 0) {
            throw new PrinterException("Paper's imageable width is too small.");
        }
        int deviceAreaHeight = (int)((RectangularShape)deviceArea).getHeight();
        if (deviceAreaHeight <= 0) {
            throw new PrinterException("Paper's imageable height is too small.");
        }
        int bandHeight = 0x400000 / bandWidth / 3;
        int deviceLeft = (int)Math.rint(paper.getImageableX() * xScale);
        int deviceTop = (int)Math.rint(paper.getImageableY() * yScale);
        AffineTransform deviceTransform = new AffineTransform();
        deviceTransform.translate(-deviceLeft, deviceTop);
        deviceTransform.translate(0.0, bandHeight);
        deviceTransform.scale(1.0, -1.0);
        BufferedImage pBand = new BufferedImage(1, 1, 5);
        PeekGraphics peekGraphics = this.createPeekGraphics(pBand.createGraphics(), this);
        Rectangle2D.Double pageFormatArea = new Rectangle2D.Double(page.getImageableX(), page.getImageableY(), page.getImageableWidth(), page.getImageableHeight());
        peekGraphics.transform(scaleTransform);
        peekGraphics.translate(-this.getPhysicalPrintableX(paper) / xScale, -this.getPhysicalPrintableY(paper) / yScale);
        peekGraphics.transform(new AffineTransform(page.getMatrix()));
        this.initPrinterGraphics(peekGraphics, pageFormatArea);
        AffineTransform pgAt = peekGraphics.getTransform();
        this.setGraphicsConfigInfo(scaleTransform, paper.getWidth(), paper.getHeight());
        int pageResult = painter.print(peekGraphics, origPage, pageIndex);
        this.debug_println("pageResult " + pageResult);
        if (pageResult == 0) {
            this.debug_println("startPage " + pageIndex);
            Paper thisPaper = page.getPaper();
            boolean paperChanged = this.previousPaper == null || thisPaper.getWidth() != this.previousPaper.getWidth() || thisPaper.getHeight() != this.previousPaper.getHeight();
            this.previousPaper = thisPaper;
            this.startPage(page, painter, pageIndex, paperChanged);
            Graphics2D pathGraphics = this.createPathGraphics(peekGraphics, this, painter, page, pageIndex);
            if (pathGraphics != null) {
                pathGraphics.transform(scaleTransform);
                pathGraphics.translate(-this.getPhysicalPrintableX(paper) / xScale, -this.getPhysicalPrintableY(paper) / yScale);
                pathGraphics.transform(new AffineTransform(page.getMatrix()));
                this.initPrinterGraphics(pathGraphics, pageFormatArea);
                this.redrawList.clear();
                AffineTransform initialTx = pathGraphics.getTransform();
                painter.print(pathGraphics, origPage, pageIndex);
                for (int i = 0; i < this.redrawList.size(); ++i) {
                    GraphicsState gstate = (GraphicsState)this.redrawList.get(i);
                    pathGraphics.setTransform(initialTx);
                    ((PathGraphics)pathGraphics).redrawRegion(gstate.region, gstate.sx, gstate.sy, gstate.theClip, gstate.theTransform);
                }
            } else {
                BufferedImage band = this.cachedBand;
                if (this.cachedBand == null || bandWidth != this.cachedBandWidth || bandHeight != this.cachedBandHeight) {
                    this.cachedBand = band = new BufferedImage(bandWidth, bandHeight, 5);
                    this.cachedBandWidth = bandWidth;
                    this.cachedBandHeight = bandHeight;
                }
                Graphics2D bandGraphics = band.createGraphics();
                Rectangle2D.Double clipArea = new Rectangle2D.Double(0.0, 0.0, bandWidth, bandHeight);
                this.initPrinterGraphics(bandGraphics, clipArea);
                ProxyGraphics2D painterGraphics = new ProxyGraphics2D(bandGraphics, this);
                Graphics2D clearGraphics = band.createGraphics();
                clearGraphics.setColor(Color.white);
                ByteInterleavedRaster tile = (ByteInterleavedRaster)band.getRaster();
                byte[] data = tile.getDataStorage();
                int deviceBottom = deviceTop + deviceAreaHeight;
                int deviceAddressableX = (int)this.getPhysicalPrintableX(paper);
                int deviceAddressableY = (int)this.getPhysicalPrintableY(paper);
                for (int bandTop = 0; bandTop <= deviceAreaHeight; bandTop += bandHeight) {
                    int bandY;
                    clearGraphics.fillRect(0, 0, bandWidth, bandHeight);
                    bandGraphics.setTransform(uniformTransform);
                    bandGraphics.transform(deviceTransform);
                    deviceTransform.translate(0.0, -bandHeight);
                    bandGraphics.transform(scaleTransform);
                    bandGraphics.transform(new AffineTransform(page.getMatrix()));
                    Rectangle clip = bandGraphics.getClipBounds();
                    clip = pgAt.createTransformedShape(clip).getBounds();
                    if (clip != null && (!peekGraphics.hitsDrawingArea(clip) || bandWidth <= 0 || bandHeight <= 0)) continue;
                    int bandX = deviceLeft - deviceAddressableX;
                    if (bandX < 0) {
                        bandGraphics.translate((double)bandX / xScale, 0.0);
                        bandX = 0;
                    }
                    if ((bandY = deviceTop + bandTop - deviceAddressableY) < 0) {
                        bandGraphics.translate(0.0, (double)bandY / yScale);
                        bandY = 0;
                    }
                    painterGraphics.setDelegate((Graphics2D)bandGraphics.create());
                    painter.print(painterGraphics, origPage, pageIndex);
                    painterGraphics.dispose();
                    this.printBand(data, bandX, bandY, bandWidth, bandHeight);
                }
                clearGraphics.dispose();
                bandGraphics.dispose();
            }
            this.debug_println("calling endPage " + pageIndex);
            this.endPage(page, painter, pageIndex);
        }
        return pageResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            if (this.performingPrinting) {
                this.userCancelled = true;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        boolean cancelled = false;
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            cancelled = this.performingPrinting && this.userCancelled;
            this.notify();
        }
        return cancelled;
    }

    protected Pageable getPageable() {
        return this.mDocument;
    }

    protected Graphics2D createPathGraphics(PeekGraphics graphics, PrinterJob printerJob, Printable painter, PageFormat pageFormat, int pageIndex) {
        return null;
    }

    protected PeekGraphics createPeekGraphics(Graphics2D graphics, PrinterJob printerJob) {
        return new PeekGraphics(graphics, printerJob);
    }

    protected void initPrinterGraphics(Graphics2D g, Rectangle2D clip) {
        g.setClip(clip);
        g.setPaint(Color.black);
    }

    public boolean checkAllowedToPrintToFile() {
        try {
            this.throwPrintToFile();
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private void throwPrintToFile() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (this.printToFilePermission == null) {
                this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
            }
            security.checkPermission(this.printToFilePermission);
        }
    }

    protected String removeControlChars(String s) {
        char[] in_chars = s.toCharArray();
        int len = in_chars.length;
        char[] out_chars = new char[len];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            char c = in_chars[i];
            if (c <= '\r' && c >= '\t' && c != '\u000b' && c != '\f') continue;
            out_chars[pos++] = c;
        }
        if (pos == len) {
            return s;
        }
        return new String(out_chars, 0, pos);
    }

    private long getParentWindowID() {
        return this.parentWindowID;
    }

    private void clearParentWindowID() {
        this.parentWindowID = 0L;
        this.onTop = null;
    }

    private void setParentWindowID(PrintRequestAttributeSet attrs) {
        this.parentWindowID = 0L;
        this.onTop = (DialogOnTop)attrs.get(DialogOnTop.class);
        if (this.onTop != null) {
            this.parentWindowID = this.onTop.getID();
        }
    }

    static {
        String shapeTextStr;
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        String forceStr = AccessController.doPrivileged(new GetPropertyAction(FORCE_PIPE_PROP));
        if (forceStr != null) {
            if (forceStr.equalsIgnoreCase(FORCE_PDL)) {
                forcePDL = true;
            } else if (forceStr.equalsIgnoreCase(FORCE_RASTER)) {
                forceRaster = true;
            }
        }
        if ((shapeTextStr = AccessController.doPrivileged(new GetPropertyAction(SHAPE_TEXT_PROP))) != null) {
            shapeTextProp = true;
        }
        String debugStr = AccessController.doPrivileged(new GetPropertyAction(SUN_PRINT_RASTERPRINT_DEBUG));
        debugPrint = "true".equalsIgnoreCase(debugStr);
        debugPrint = false;
    }

    private class GraphicsState {
        Rectangle2D region;
        Shape theClip;
        AffineTransform theTransform;
        double sx;
        double sy;

        private GraphicsState() {
        }
    }
}

