/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.security.AccessController;
import sun.misc.ObjectInputFilter;
import sun.rmi.runtime.Log;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.Connection;
import sun.rmi.transport.ConnectionInputStream;
import sun.rmi.transport.ConnectionOutputStream;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Transport;
import sun.rmi.transport.tcp.TCPEndpoint;

public class StreamRemoteCall
implements RemoteCall {
    private ConnectionInputStream in = null;
    private ConnectionOutputStream out = null;
    private Connection conn;
    private ObjectInputFilter filter = null;
    private boolean resultStarted = false;
    private Exception serverException = null;

    public StreamRemoteCall(Connection c) {
        this.conn = c;
    }

    public StreamRemoteCall(Connection c, ObjID id, int op, long hash) throws RemoteException {
        try {
            this.conn = c;
            Transport.transportLog.log(Log.VERBOSE, "write remote call header...");
            this.conn.getOutputStream().write(80);
            this.getOutputStream();
            id.write(this.out);
            this.out.writeInt(op);
            this.out.writeLong(hash);
        }
        catch (IOException e) {
            throw new MarshalException("Error marshaling call header", e);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public ObjectOutput getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    private ObjectOutput getOutputStream(boolean resultStream) throws IOException {
        if (this.out == null) {
            Transport.transportLog.log(Log.VERBOSE, "getting output stream");
            this.out = new ConnectionOutputStream(this.conn, resultStream);
        }
        return this.out;
    }

    @Override
    public void releaseOutputStream() throws IOException {
        try {
            if (this.out != null) {
                try {
                    this.out.flush();
                }
                finally {
                    this.out.done();
                }
            }
            this.conn.releaseOutputStream();
        }
        finally {
            this.out = null;
        }
    }

    public void setObjectInputFilter(ObjectInputFilter filter) {
        if (this.in != null) {
            throw new IllegalStateException("set filter must occur before calling getInputStream");
        }
        this.filter = filter;
    }

    @Override
    public ObjectInput getInputStream() throws IOException {
        if (this.in == null) {
            Transport.transportLog.log(Log.VERBOSE, "getting input stream");
            this.in = new ConnectionInputStream(this.conn.getInputStream());
            if (this.filter != null) {
                AccessController.doPrivileged(() -> {
                    ObjectInputFilter.Config.setObjectInputFilter(this.in, this.filter);
                    return null;
                });
            }
        }
        return this.in;
    }

    @Override
    public void releaseInputStream() throws IOException {
        try {
            if (this.in != null) {
                try {
                    this.in.done();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.in.registerRefs();
                this.in.done(this.conn);
            }
            this.conn.releaseInputStream();
        }
        finally {
            this.in = null;
        }
    }

    public void discardPendingRefs() {
        this.in.discardRefs();
    }

    @Override
    public ObjectOutput getResultStream(boolean success) throws IOException {
        if (this.resultStarted) {
            throw new StreamCorruptedException("result already in progress");
        }
        this.resultStarted = true;
        DataOutputStream wr = new DataOutputStream(this.conn.getOutputStream());
        wr.writeByte(81);
        this.getOutputStream(true);
        if (success) {
            this.out.writeByte(1);
        } else {
            this.out.writeByte(2);
        }
        this.out.writeID();
        return this.out;
    }

    @Override
    public void executeCall() throws Exception {
        byte returnType;
        DGCAckHandler ackHandler = null;
        try {
            if (this.out != null) {
                ackHandler = this.out.getDGCAckHandler();
            }
            this.releaseOutputStream();
            DataInputStream rd = new DataInputStream(this.conn.getInputStream());
            byte op = rd.readByte();
            if (op != 81) {
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, "transport return code invalid: " + op);
                }
                throw new UnmarshalException("Transport return code invalid");
            }
            this.getInputStream();
            returnType = this.in.readByte();
            this.in.readID();
        }
        catch (UnmarshalException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UnmarshalException("Error unmarshaling return header", e);
        }
        finally {
            if (ackHandler != null) {
                ackHandler.release();
            }
        }
        switch (returnType) {
            case 1: {
                break;
            }
            case 2: {
                Object ex;
                try {
                    ex = this.in.readObject();
                }
                catch (Exception e) {
                    this.discardPendingRefs();
                    throw new UnmarshalException("Error unmarshaling return", e);
                }
                if (ex instanceof Exception) {
                    this.exceptionReceivedFromServer((Exception)ex);
                } else {
                    this.discardPendingRefs();
                    throw new UnmarshalException("Return type not Exception");
                }
            }
            default: {
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, "return code invalid: " + returnType);
                }
                throw new UnmarshalException("Return code invalid");
            }
        }
    }

    protected void exceptionReceivedFromServer(Exception ex) throws Exception {
        this.serverException = ex;
        StackTraceElement[] serverTrace = ex.getStackTrace();
        StackTraceElement[] clientTrace = new Throwable().getStackTrace();
        StackTraceElement[] combinedTrace = new StackTraceElement[serverTrace.length + clientTrace.length];
        System.arraycopy(serverTrace, 0, combinedTrace, 0, serverTrace.length);
        System.arraycopy(clientTrace, 0, combinedTrace, serverTrace.length, clientTrace.length);
        ex.setStackTrace(combinedTrace);
        if (UnicastRef.clientCallLog.isLoggable(Log.BRIEF)) {
            TCPEndpoint ep = (TCPEndpoint)this.conn.getChannel().getEndpoint();
            UnicastRef.clientCallLog.log(Log.BRIEF, "outbound call received exception: [" + ep.getHost() + ":" + ep.getPort() + "] exception: ", ex);
        }
        throw ex;
    }

    public Exception getServerException() {
        return this.serverException;
    }

    @Override
    public void done() throws IOException {
        this.releaseInputStream();
    }
}

