/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class NamedCurve
extends ECParameterSpec {
    private final String name;
    private final String oid;
    private final byte[] encoded;

    NamedCurve(String name, String oid, EllipticCurve curve, ECPoint g, BigInteger n, int h) {
        super(curve, g, n, h);
        this.name = name;
        this.oid = oid;
        DerOutputStream out = new DerOutputStream();
        try {
            out.putOID(new ObjectIdentifier(oid));
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error", e);
        }
        this.encoded = out.toByteArray();
    }

    public String getName() {
        return this.name;
    }

    byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public String getObjectId() {
        return this.oid;
    }

    public String toString() {
        return this.name + " (" + this.oid + ")";
    }
}

