/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.CodeSigner;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import sun.security.jca.Providers;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.JarConstraintsParameters;
import sun.security.util.ManifestDigester;

public class SignatureFileVerifier {
    private static final Debug debug = Debug.getInstance("jar");
    private ArrayList<CodeSigner[]> signerCache;
    private static final String ATTR_DIGEST = "-DIGEST-Manifest-Main-Attributes".toUpperCase(Locale.ENGLISH);
    private PKCS7 block;
    private byte[] sfBytes;
    private String name;
    private ManifestDigester md;
    private HashMap<String, MessageDigest> createdDigests;
    private boolean workaround = false;
    private CertificateFactory certificateFactory = null;
    private Map<String, Boolean> permittedAlgs = new HashMap<String, Boolean>();
    private JarConstraintsParameters params;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureFileVerifier(ArrayList<CodeSigner[]> signerCache, ManifestDigester md, String name, byte[] rawBytes) throws IOException, CertificateException {
        Object obj = null;
        try {
            obj = Providers.startJarVerification();
            this.block = new PKCS7(rawBytes);
            this.sfBytes = this.block.getContentInfo().getData();
            this.certificateFactory = CertificateFactory.getInstance("X509");
        }
        finally {
            Providers.stopJarVerification(obj);
        }
        this.name = name.substring(0, name.lastIndexOf(46)).toUpperCase(Locale.ENGLISH);
        this.md = md;
        this.signerCache = signerCache;
    }

    public boolean needSignatureFileBytes() {
        return this.sfBytes == null;
    }

    public boolean needSignatureFile(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public void setSignatureFile(byte[] sfBytes) {
        this.sfBytes = sfBytes;
    }

    public static boolean isBlockOrSF(String s) {
        return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA") || s.endsWith(".EC");
    }

    public static boolean isSigningRelated(String name) {
        if (!(name = name.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/")) {
            return false;
        }
        if ((name = name.substring(9)).indexOf(47) != -1) {
            return false;
        }
        if (SignatureFileVerifier.isBlockOrSF(name) || name.equals("MANIFEST.MF")) {
            return true;
        }
        if (name.startsWith("SIG-")) {
            int extIndex = name.lastIndexOf(46);
            if (extIndex != -1) {
                String ext = name.substring(extIndex + 1);
                if (ext.length() > 3 || ext.length() < 1) {
                    return false;
                }
                for (int index = 0; index < ext.length(); ++index) {
                    char cc = ext.charAt(index);
                    if (cc >= 'A' && cc <= 'Z' || cc >= '0' && cc <= '9') continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private MessageDigest getDigest(String algorithm) throws SignatureException {
        MessageDigest digest;
        if (this.createdDigests == null) {
            this.createdDigests = new HashMap();
        }
        if ((digest = this.createdDigests.get(algorithm)) == null) {
            try {
                digest = MessageDigest.getInstance(algorithm);
                this.createdDigests.put(algorithm, digest);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Hashtable<String, CodeSigner[]> signers, List<Object> manifestDigests, String manifestName) throws IOException, SignatureException, NoSuchAlgorithmException, JarException, CertificateException {
        Object obj = null;
        try {
            obj = Providers.startJarVerification();
            this.processImpl(signers, manifestDigests, manifestName);
        }
        finally {
            Providers.stopJarVerification(obj);
        }
    }

    private void processImpl(Hashtable<String, CodeSigner[]> signers, List<Object> manifestDigests, String manifestName) throws IOException, SignatureException, NoSuchAlgorithmException, JarException, CertificateException {
        Manifest sf = new Manifest();
        sf.read(new ByteArrayInputStream(this.sfBytes));
        String version = sf.getMainAttributes().getValue(Attributes.Name.SIGNATURE_VERSION);
        if (version == null || !version.equalsIgnoreCase("1.0")) {
            return;
        }
        SignerInfo[] infos = this.block.verify(this.sfBytes);
        if (infos == null) {
            throw new SecurityException("cannot verify signature block file " + this.name);
        }
        CodeSigner[] newSigners = this.getSigners(infos, this.block);
        if (newSigners == null) {
            return;
        }
        this.params = new JarConstraintsParameters(newSigners);
        Set<String> notDisabledAlgorithms = SignerInfo.verifyAlgorithms(infos, this.params, this.name + " PKCS7");
        for (String algorithm : notDisabledAlgorithms) {
            this.permittedAlgs.put(algorithm, Boolean.TRUE);
        }
        Iterator<Map.Entry<String, Attributes>> entries = sf.getEntries().entrySet().iterator();
        boolean manifestSigned = this.verifyManifestHash(sf, this.md, manifestDigests);
        if (!manifestSigned && !this.verifyManifestMainAttrs(sf, this.md)) {
            throw new SecurityException("Invalid signature file digest for Manifest main attributes");
        }
        while (entries.hasNext()) {
            Map.Entry<String, Attributes> e = entries.next();
            String name = e.getKey();
            if (manifestSigned || this.verifySection(e.getValue(), name, this.md)) {
                if (name.startsWith("./")) {
                    name = name.substring(2);
                }
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                this.updateSigners(newSigners, signers, name);
                if (debug == null) continue;
                debug.println("processSignature signed name = " + name);
                continue;
            }
            if (debug == null) continue;
            debug.println("processSignature unsigned name = " + name);
        }
        this.updateSigners(newSigners, signers, manifestName);
    }

    private boolean permittedCheck(String key, String algorithm) {
        Boolean permitted = this.permittedAlgs.get(algorithm);
        if (permitted == null) {
            try {
                this.params.setExtendedExceptionMsg(this.name + ".SF", key + " attribute");
                DisabledAlgorithmConstraints.jarConstraints().permits(algorithm, this.params, false);
            }
            catch (GeneralSecurityException e) {
                this.permittedAlgs.put(algorithm, Boolean.FALSE);
                this.permittedAlgs.put(key.toUpperCase(), Boolean.FALSE);
                if (debug != null) {
                    if (e.getMessage() != null) {
                        debug.println(key + ":  " + e.getMessage());
                    } else {
                        debug.println("Debug info only. " + key + ":  " + algorithm + " was disabled, no exception msg given.");
                        e.printStackTrace();
                    }
                }
                return false;
            }
            this.permittedAlgs.put(algorithm, Boolean.TRUE);
            return true;
        }
        return permitted;
    }

    String getWeakAlgorithms(String header) {
        String w = "";
        try {
            for (String key : this.permittedAlgs.keySet()) {
                if (!key.endsWith(header)) continue;
                w = w + key.substring(0, key.length() - header.length()) + " ";
            }
        }
        catch (RuntimeException e) {
            w = "Unknown Algorithm(s).  Error processing " + header + ".  " + e.getMessage();
        }
        if (w.isEmpty()) {
            return "Unknown Algorithm(s)";
        }
        return w;
    }

    private boolean verifyManifestHash(Manifest sf, ManifestDigester md, List<Object> manifestDigests) throws IOException, SignatureException {
        Attributes mattr = sf.getMainAttributes();
        boolean manifestSigned = false;
        boolean weakAlgs = true;
        boolean validEntry = false;
        for (Map.Entry<Object, Object> se : mattr.entrySet()) {
            String key = se.getKey().toString();
            if (!key.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST-MANIFEST")) continue;
            String algorithm = key.substring(0, key.length() - 16);
            validEntry = true;
            if (!this.permittedCheck(key, algorithm)) continue;
            weakAlgs = false;
            manifestDigests.add(key);
            manifestDigests.add(se.getValue());
            MessageDigest digest = this.getDigest(algorithm);
            if (digest == null) continue;
            byte[] computedHash = md.manifestDigest(digest);
            byte[] expectedHash = Base64.getMimeDecoder().decode((String)se.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest digest " + algorithm);
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(expectedHash));
                debug.println("  computed " + SignatureFileVerifier.toHex(computedHash));
                debug.println();
            }
            if (!MessageDigest.isEqual(computedHash, expectedHash)) continue;
            manifestSigned = true;
        }
        if (debug != null) {
            debug.println("PermittedAlgs mapping: ");
            for (String key : this.permittedAlgs.keySet()) {
                debug.println(key + " : " + this.permittedAlgs.get(key).toString());
            }
        }
        if (validEntry && weakAlgs) {
            throw new SignatureException("Manifest hash check failed (DIGEST-MANIFEST). Disabled algorithm(s) used: " + this.getWeakAlgorithms("-DIGEST-MANIFEST"));
        }
        return manifestSigned;
    }

    private boolean verifyManifestMainAttrs(Manifest sf, ManifestDigester md) throws IOException, SignatureException {
        Attributes mattr = sf.getMainAttributes();
        boolean attrsVerified = true;
        boolean weakAlgs = true;
        boolean validEntry = false;
        for (Map.Entry<Object, Object> se : mattr.entrySet()) {
            String key = se.getKey().toString();
            if (!key.toUpperCase(Locale.ENGLISH).endsWith(ATTR_DIGEST)) continue;
            String algorithm = key.substring(0, key.length() - ATTR_DIGEST.length());
            validEntry = true;
            if (!this.permittedCheck(key, algorithm)) continue;
            weakAlgs = false;
            MessageDigest digest = this.getDigest(algorithm);
            if (digest == null) continue;
            ManifestDigester.Entry mde = md.get("Manifest-Main-Attributes", false);
            if (mde == null) {
                throw new SignatureException("Manifest Main Attribute check failed due to missing main attributes entry");
            }
            byte[] computedHash = mde.digest(digest);
            byte[] expectedHash = Base64.getMimeDecoder().decode((String)se.getValue());
            if (debug != null) {
                debug.println("Signature File: Manifest Main Attributes digest " + digest.getAlgorithm());
                debug.println("  sigfile  " + SignatureFileVerifier.toHex(expectedHash));
                debug.println("  computed " + SignatureFileVerifier.toHex(computedHash));
                debug.println();
            }
            if (MessageDigest.isEqual(computedHash, expectedHash)) continue;
            attrsVerified = false;
            if (debug == null) break;
            debug.println("Verification of Manifest main attributes failed");
            debug.println();
            break;
        }
        if (debug != null) {
            debug.println("PermittedAlgs mapping: ");
            for (String key : this.permittedAlgs.keySet()) {
                debug.println(key + " : " + this.permittedAlgs.get(key).toString());
            }
        }
        if (validEntry && weakAlgs) {
            throw new SignatureException("Manifest Main Attribute check failed (" + ATTR_DIGEST + ").  Disabled algorithm(s) used: " + this.getWeakAlgorithms(ATTR_DIGEST));
        }
        return attrsVerified;
    }

    private boolean verifySection(Attributes sfAttr, String name, ManifestDigester md) throws IOException, SignatureException {
        boolean oneDigestVerified = false;
        ManifestDigester.Entry mde = md.get(name, this.block.isOldStyle());
        boolean weakAlgs = true;
        boolean validEntry = false;
        if (mde == null) {
            throw new SecurityException("no manifest section for signature file entry " + name);
        }
        if (sfAttr != null) {
            for (Map.Entry<Object, Object> se : sfAttr.entrySet()) {
                String key = se.getKey().toString();
                if (!key.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST")) continue;
                String algorithm = key.substring(0, key.length() - 7);
                validEntry = true;
                if (!this.permittedCheck(key, algorithm)) continue;
                weakAlgs = false;
                MessageDigest digest = this.getDigest(algorithm);
                if (digest == null) continue;
                boolean ok = false;
                byte[] expected = Base64.getMimeDecoder().decode((String)se.getValue());
                byte[] computed = this.workaround ? mde.digestWorkaround(digest) : mde.digest(digest);
                if (debug != null) {
                    debug.println("Signature Block File: " + name + " digest=" + digest.getAlgorithm());
                    debug.println("  expected " + SignatureFileVerifier.toHex(expected));
                    debug.println("  computed " + SignatureFileVerifier.toHex(computed));
                    debug.println();
                }
                if (MessageDigest.isEqual(computed, expected)) {
                    oneDigestVerified = true;
                    ok = true;
                } else if (!this.workaround && MessageDigest.isEqual(computed = mde.digestWorkaround(digest), expected)) {
                    if (debug != null) {
                        debug.println("  re-computed " + SignatureFileVerifier.toHex(computed));
                        debug.println();
                    }
                    this.workaround = true;
                    oneDigestVerified = true;
                    ok = true;
                }
                if (ok) continue;
                throw new SecurityException("invalid " + digest.getAlgorithm() + " signature file digest for " + name);
            }
        }
        if (debug != null) {
            debug.println("PermittedAlgs mapping: ");
            for (String key : this.permittedAlgs.keySet()) {
                debug.println(key + " : " + this.permittedAlgs.get(key).toString());
            }
        }
        if (validEntry && weakAlgs) {
            throw new SignatureException("Manifest Main Attribute check failed (DIGEST).  Disabled algorithm(s) used: " + this.getWeakAlgorithms("DIGEST"));
        }
        return oneDigestVerified;
    }

    private CodeSigner[] getSigners(SignerInfo[] infos, PKCS7 block) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        ArrayList<CodeSigner> signers = null;
        for (int i = 0; i < infos.length; ++i) {
            SignerInfo info = infos[i];
            ArrayList<X509Certificate> chain = info.getCertificateChain(block);
            CertPath certChain = this.certificateFactory.generateCertPath(chain);
            if (signers == null) {
                signers = new ArrayList<CodeSigner>();
            }
            signers.add(new CodeSigner(certChain, info.getTimestamp()));
            if (debug == null) continue;
            debug.println("Signature Block Certificate: " + chain.get(0));
        }
        if (signers != null) {
            return signers.toArray(new CodeSigner[signers.size()]);
        }
        return null;
    }

    static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hexc[data[i] >> 4 & 0xF]);
            sb.append(hexc[data[i] & 0xF]);
        }
        return sb.toString();
    }

    static boolean contains(CodeSigner[] set, CodeSigner signer) {
        for (int i = 0; i < set.length; ++i) {
            if (!set[i].equals(signer)) continue;
            return true;
        }
        return false;
    }

    static boolean isSubSet(CodeSigner[] subset, CodeSigner[] set) {
        if (set == subset) {
            return true;
        }
        for (int i = 0; i < subset.length; ++i) {
            if (SignatureFileVerifier.contains(set, subset[i])) continue;
            return false;
        }
        return true;
    }

    static boolean matches(CodeSigner[] signers, CodeSigner[] oldSigners, CodeSigner[] newSigners) {
        if (oldSigners == null && signers == newSigners) {
            return true;
        }
        if (oldSigners != null && !SignatureFileVerifier.isSubSet(oldSigners, signers)) {
            return false;
        }
        if (!SignatureFileVerifier.isSubSet(newSigners, signers)) {
            return false;
        }
        for (int i = 0; i < signers.length; ++i) {
            boolean found;
            boolean bl = found = oldSigners != null && SignatureFileVerifier.contains(oldSigners, signers[i]) || SignatureFileVerifier.contains(newSigners, signers[i]);
            if (found) continue;
            return false;
        }
        return true;
    }

    void updateSigners(CodeSigner[] newSigners, Hashtable<String, CodeSigner[]> signers, String name) {
        CodeSigner[] cachedSigners;
        CodeSigner[] oldSigners = signers.get(name);
        for (int i = this.signerCache.size() - 1; i != -1; --i) {
            cachedSigners = this.signerCache.get(i);
            if (!SignatureFileVerifier.matches(cachedSigners, oldSigners, newSigners)) continue;
            signers.put(name, cachedSigners);
            return;
        }
        if (oldSigners == null) {
            cachedSigners = newSigners;
        } else {
            cachedSigners = new CodeSigner[oldSigners.length + newSigners.length];
            System.arraycopy(oldSigners, 0, cachedSigners, 0, oldSigners.length);
            System.arraycopy(newSigners, 0, cachedSigners, oldSigners.length, newSigners.length);
        }
        this.signerCache.add(cachedSigners);
        signers.put(name, cachedSigners);
    }
}

