/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import sun.security.util.ChannelBindingException;

public class TlsChannelBinding {
    private final TlsChannelBindingType cbType;
    private final byte[] cbData;

    public static TlsChannelBindingType parseType(String cbType) throws ChannelBindingException {
        if (cbType != null) {
            if (cbType.equals(TlsChannelBindingType.TLS_SERVER_END_POINT.getName())) {
                return TlsChannelBindingType.TLS_SERVER_END_POINT;
            }
            throw new ChannelBindingException("Illegal value for channel binding type: " + cbType);
        }
        return null;
    }

    public static TlsChannelBinding create(X509Certificate serverCertificate) throws ChannelBindingException {
        try {
            byte[] prefix = TlsChannelBindingType.TLS_SERVER_END_POINT.getName().concat(":").getBytes();
            String hashAlg = serverCertificate.getSigAlgName().replace("SHA", "SHA-").toUpperCase();
            int ind = hashAlg.indexOf("WITH");
            if (ind > 0) {
                if ((hashAlg = hashAlg.substring(0, ind)).equals("MD5") || hashAlg.equals("SHA-1")) {
                    hashAlg = "SHA-256";
                }
            } else {
                hashAlg = "SHA-256";
            }
            MessageDigest md = MessageDigest.getInstance(hashAlg);
            byte[] hash = md.digest(serverCertificate.getEncoded());
            byte[] cbData = Arrays.copyOf(prefix, prefix.length + hash.length);
            System.arraycopy(hash, 0, cbData, prefix.length, hash.length);
            return new TlsChannelBinding(TlsChannelBindingType.TLS_SERVER_END_POINT, cbData);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new ChannelBindingException("Cannot create TLS channel binding data", e);
        }
    }

    private TlsChannelBinding(TlsChannelBindingType cbType, byte[] cbData) {
        this.cbType = cbType;
        this.cbData = cbData;
    }

    public TlsChannelBindingType getType() {
        return this.cbType;
    }

    public byte[] getData() {
        return this.cbData;
    }

    public static enum TlsChannelBindingType {
        TLS_UNIQUE("tls-unique"),
        TLS_SERVER_END_POINT("tls-server-end-point");

        private final String name;

        public String getName() {
            return this.name;
        }

        private TlsChannelBindingType(String name) {
            this.name = name;
        }
    }
}

