/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class IntegerPolynomial1305
extends IntegerPolynomial {
    protected static final int SUBTRAHEND = 5;
    protected static final int NUM_LIMBS = 5;
    private static final int POWER = 130;
    private static final int BITS_PER_LIMB = 26;
    private static final BigInteger MODULUS = TWO.pow(130).subtract(BigInteger.valueOf(5L));

    public IntegerPolynomial1305() {
        super(26, 5, 1, MODULUS);
    }

    @Override
    protected void mult(long[] a, long[] b, long[] r) {
        long c0 = a[0] * b[0];
        long c1 = a[0] * b[1] + a[1] * b[0];
        long c2 = a[0] * b[2] + a[1] * b[1] + a[2] * b[0];
        long c3 = a[0] * b[3] + a[1] * b[2] + a[2] * b[1] + a[3] * b[0];
        long c4 = a[0] * b[4] + a[1] * b[3] + a[2] * b[2] + a[3] * b[1] + a[4] * b[0];
        long c5 = a[1] * b[4] + a[2] * b[3] + a[3] * b[2] + a[4] * b[1];
        long c6 = a[2] * b[4] + a[3] * b[3] + a[4] * b[2];
        long c7 = a[3] * b[4] + a[4] * b[3];
        long c8 = a[4] * b[4];
        this.carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8);
    }

    private void carryReduce(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8) {
        r[2] = c2 + c7 * 5L;
        long carry3 = this.carryValue(c3 += c8 * 5L);
        r[3] = c3 - (carry3 << 26);
        long carry4 = this.carryValue(c4 += carry3);
        r[4] = c4 - (carry4 << 26);
        r[0] = c0 + (c5 += carry4) * 5L;
        r[1] = c1 + c6 * 5L;
        this.carry(r);
    }

    @Override
    protected void square(long[] a, long[] r) {
        long c0 = a[0] * a[0];
        long c1 = 2L * (a[0] * a[1]);
        long c2 = 2L * (a[0] * a[2]) + a[1] * a[1];
        long c3 = 2L * (a[0] * a[3] + a[1] * a[2]);
        long c4 = 2L * (a[0] * a[4] + a[1] * a[3]) + a[2] * a[2];
        long c5 = 2L * (a[1] * a[4] + a[2] * a[3]);
        long c6 = 2L * (a[2] * a[4]) + a[3] * a[3];
        long c7 = 2L * (a[3] * a[4]);
        long c8 = a[4] * a[4];
        this.carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8);
    }

    @Override
    protected void encode(ByteBuffer buf, int length, byte highByte, long[] result) {
        if (length == 16) {
            long low = buf.getLong();
            long high = buf.getLong();
            this.encode(high, low, highByte, result);
        } else {
            super.encode(buf, length, highByte, result);
        }
    }

    protected void encode(long high, long low, byte highByte, long[] result) {
        result[0] = low & 0x3FFFFFFL;
        result[1] = low >>> 26 & 0x3FFFFFFL;
        result[2] = (low >>> 52) + ((high & 0x3FFFL) << 12);
        result[3] = high >>> 14 & 0x3FFFFFFL;
        result[4] = (high >>> 40) + (long)(highByte << 24);
    }

    private void modReduceIn(long[] limbs, int index, long x) {
        long reducedValue = x * 5L;
        int n = index - 5;
        limbs[n] = limbs[n] + reducedValue;
    }

    @Override
    protected void finalCarryReduceLast(long[] limbs) {
        long carry = limbs[this.numLimbs - 1] >> this.bitsPerLimb;
        int n = this.numLimbs - 1;
        limbs[n] = limbs[n] - (carry << this.bitsPerLimb);
        this.modReduceIn(limbs, this.numLimbs, carry);
    }

    protected final void modReduce(long[] limbs, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.modReduceIn(limbs, i, limbs[i]);
            limbs[i] = 0L;
        }
    }

    protected void modReduce(long[] limbs) {
        this.modReduce(limbs, 5, 4);
    }

    @Override
    protected long carryValue(long x) {
        return x >> 26;
    }

    @Override
    protected void postEncodeCarry(long[] v) {
    }

    @Override
    protected void reduce(long[] limbs) {
        long carry3 = this.carryOut(limbs, 3);
        long new4 = carry3 + limbs[4];
        long carry4 = this.carryValue(new4);
        limbs[4] = new4 - (carry4 << 26);
        this.modReduceIn(limbs, 5, carry4);
        this.carry(limbs);
    }
}

