/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jcmd;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

class Arguments {
    private boolean listProcesses;
    private boolean listCounters;
    private boolean showUsage;
    private int pid;
    private String command;
    private String processSubstring;

    public boolean isListProcesses() {
        return this.listProcesses;
    }

    public boolean isListCounters() {
        return this.listCounters;
    }

    public boolean isShowUsage() {
        return this.showUsage;
    }

    public int getPid() {
        return this.pid;
    }

    public String getCommand() {
        return this.command;
    }

    public String getProcessSubstring() {
        return this.processSubstring;
    }

    public Arguments(String[] args) {
        block12: {
            this.listProcesses = false;
            this.listCounters = false;
            this.showUsage = false;
            this.pid = -1;
            this.command = null;
            if (args.length == 0 || args[0].equals("-l")) {
                this.listProcesses = true;
                return;
            }
            if (args[0].equals("-h") || args[0].equals("-help")) {
                this.showUsage = true;
                return;
            }
            try {
                this.pid = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                if (args[0].charAt(0) == '-') break block12;
                this.processSubstring = args[0];
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-f")) {
                if (args.length == i + 1) {
                    throw new IllegalArgumentException("No file specified for parameter -f");
                }
                if (args.length == i + 2) {
                    try {
                        this.readCommandFile(args[i + 1]);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Could not read from file specified with -f option: " + args[i + 1]);
                    }
                    return;
                }
                throw new IllegalArgumentException("Options after -f are not allowed");
            }
            if (args[i].equals("PerfCounter.print")) {
                this.listCounters = true;
                continue;
            }
            sb.append(args[i]).append(" ");
        }
        if (!this.listCounters && sb.length() == 0) {
            throw new IllegalArgumentException("No command specified");
        }
        this.command = sb.toString().trim();
    }

    private void readCommandFile(String path) throws IOException {
        try (BufferedReader bf = new BufferedReader(new FileReader(path));){
            String s;
            StringBuilder sb = new StringBuilder();
            while ((s = bf.readLine()) != null) {
                sb.append(s).append("\n");
            }
            this.command = sb.toString();
        }
    }

    public static void usage() {
        System.out.println("Usage: jcmd <pid | main class> <command ...|PerfCounter.print|-f file>");
        System.out.println("   or: jcmd -l                                                    ");
        System.out.println("   or: jcmd -h                                                    ");
        System.out.println("                                                                  ");
        System.out.println("  command must be a valid jcmd command for the selected jvm.      ");
        System.out.println("  Use the command \"help\" to see which commands are available.   ");
        System.out.println("  If the pid is 0, commands will be sent to all Java processes.   ");
        System.out.println("  The main class argument will be used to match (either partially ");
        System.out.println("  or fully) the class used to start Java.                         ");
        System.out.println("  If no options are given, lists Java processes (same as -p).     ");
        System.out.println("                                                                  ");
        System.out.println("  PerfCounter.print display the counters exposed by this process  ");
        System.out.println("  -f  read and execute commands from the file                     ");
        System.out.println("  -l  list JVM processes on the local machine                     ");
        System.out.println("  -h  this help                                                   ");
    }
}

