/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jcmd;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.attach.HotSpotVirtualMachine;
import sun.tools.jcmd.Arguments;
import sun.tools.jstat.JStatLogger;

public class JCmd {
    public static void main(String[] args) {
        List<VirtualMachineDescriptor> vmds;
        Arguments arg = null;
        try {
            arg = new Arguments(args);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Error parsing arguments: " + ex.getMessage() + "\n");
            Arguments.usage();
            System.exit(1);
        }
        if (arg.isShowUsage()) {
            Arguments.usage();
            System.exit(1);
        }
        if (arg.isListProcesses()) {
            List<VirtualMachineDescriptor> vmds2 = VirtualMachine.list();
            for (VirtualMachineDescriptor vmd : vmds2) {
                System.out.println(vmd.id() + " " + vmd.displayName());
            }
            System.exit(0);
        }
        ArrayList<String> pids = new ArrayList<String>();
        if (arg.getPid() == 0) {
            vmds = VirtualMachine.list();
            for (VirtualMachineDescriptor vmd : vmds) {
                if (JCmd.isJCmdProcess(vmd)) continue;
                pids.add(vmd.id());
            }
        } else if (arg.getProcessSubstring() != null) {
            vmds = VirtualMachine.list();
            for (VirtualMachineDescriptor vmd : vmds) {
                if (JCmd.isJCmdProcess(vmd)) continue;
                try {
                    String mainClass = JCmd.getMainClass(vmd);
                    if (mainClass == null || mainClass.indexOf(arg.getProcessSubstring()) == -1) continue;
                    pids.add(vmd.id());
                }
                catch (URISyntaxException | MonitorException e) {
                    if (e.getMessage() != null) {
                        System.err.println(e.getMessage());
                        continue;
                    }
                    Throwable cause = e.getCause();
                    if (cause != null && cause.getMessage() != null) {
                        System.err.println(cause.getMessage());
                        continue;
                    }
                    e.printStackTrace();
                }
            }
            if (pids.isEmpty()) {
                System.err.println("Could not find any processes matching : '" + arg.getProcessSubstring() + "'");
                System.exit(1);
            }
        } else if (arg.getPid() == -1) {
            System.err.println("Invalid pid specified");
            System.exit(1);
        } else {
            pids.add(arg.getPid() + "");
        }
        boolean success = true;
        for (String pid : pids) {
            System.out.println(pid + ":");
            if (arg.isListCounters()) {
                JCmd.listCounters(pid);
                continue;
            }
            try {
                JCmd.executeCommandForPid(pid, arg.getCommand());
            }
            catch (AttachOperationFailedException ex) {
                System.err.println(ex.getMessage());
                success = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                success = false;
            }
        }
        System.exit(success ? 0 : 1);
    }

    private static void executeCommandForPid(String pid, String command) throws AttachNotSupportedException, IOException, UnsupportedEncodingException {
        String[] lines;
        VirtualMachine vm = VirtualMachine.attach(pid);
        HotSpotVirtualMachine hvm = (HotSpotVirtualMachine)vm;
        for (String line : lines = command.split("\\n")) {
            if (line.trim().equals("stop")) break;
            try (InputStream in = hvm.executeJCmd(line);){
                int n;
                byte[] b = new byte[256];
                boolean messagePrinted = false;
                do {
                    if ((n = in.read(b)) <= 0) continue;
                    String s = new String(b, 0, n, "UTF-8");
                    System.out.print(s);
                    messagePrinted = true;
                } while (n > 0);
                if (messagePrinted) continue;
                System.out.println("Command executed successfully");
            }
        }
        vm.detach();
    }

    private static void listCounters(String pid) {
        VmIdentifier vmId = null;
        try {
            vmId = new VmIdentifier(pid);
        }
        catch (URISyntaxException e) {
            System.err.println("Malformed VM Identifier: " + pid);
            return;
        }
        try {
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmId);
            MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmId, -1);
            JStatLogger logger = new JStatLogger(monitoredVm);
            logger.printSnapShot("\\w*", new AscendingMonitorComparator(), false, true, System.out);
            monitoredHost.detach(monitoredVm);
        }
        catch (MonitorException ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isJCmdProcess(VirtualMachineDescriptor vmd) {
        try {
            String mainClass = JCmd.getMainClass(vmd);
            return mainClass != null && mainClass.equals(JCmd.class.getName());
        }
        catch (URISyntaxException | MonitorException ex) {
            return false;
        }
    }

    private static String getMainClass(VirtualMachineDescriptor vmd) throws URISyntaxException, MonitorException {
        try {
            String mainClass = null;
            VmIdentifier vmId = new VmIdentifier(vmd.id());
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmId);
            MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmId, -1);
            mainClass = MonitoredVmUtil.mainClass(monitoredVm, true);
            monitoredHost.detach(monitoredVm);
            return mainClass;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    static class AscendingMonitorComparator
    implements Comparator<Monitor> {
        AscendingMonitorComparator() {
        }

        @Override
        public int compare(Monitor m1, Monitor m2) {
            String name1 = m1.getName();
            String name2 = m2.getName();
            return name1.compareTo(name2);
        }
    }
}

