/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.HashMap;
import java.util.Set;

public abstract class Alignment {
    private static int nextOrdinal = 0;
    private static HashMap<String, Alignment> map = new HashMap();
    private static final String blanks = "                                                                                                                                                               ";
    private final String name;
    private final int value = nextOrdinal++;
    public static final Alignment CENTER = new Alignment("center"){

        @Override
        protected String align(String s, int width) {
            int length = s.length();
            if (length >= width) {
                return s;
            }
            int pad = width - length;
            int pad2 = pad / 2;
            int padr = pad % 2;
            if (pad2 == 0) {
                return s + Alignment.blanks.substring(0, padr);
            }
            return Alignment.blanks.substring(0, pad2) + s + Alignment.blanks.substring(0, pad2 + padr);
        }
    };
    public static final Alignment LEFT = new Alignment("left"){

        @Override
        protected String align(String s, int width) {
            int length = s.length();
            if (length >= width) {
                return s;
            }
            int pad = width - length;
            return s + Alignment.blanks.substring(0, pad);
        }
    };
    public static final Alignment RIGHT = new Alignment("right"){

        @Override
        protected String align(String s, int width) {
            int length = s.length();
            if (length >= width) {
                return s;
            }
            int pad = width - length;
            return Alignment.blanks.substring(0, pad) + s;
        }
    };

    protected abstract String align(String var1, int var2);

    public static Alignment toAlignment(String s) {
        return map.get(s);
    }

    public static Set keySet() {
        return map.keySet();
    }

    public String toString() {
        return this.name;
    }

    private Alignment(String name) {
        this.name = name;
        map.put(name, this);
    }
}

