/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.File;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.jstat.AscendingMonitorComparator;
import sun.tools.jstat.DescendingMonitorComparator;
import sun.tools.jstat.OptionFinder;
import sun.tools.jstat.OptionFormat;

public class Arguments {
    private static final boolean debug = Boolean.getBoolean("jstat.debug");
    private static final boolean showUnsupported = Boolean.getBoolean("jstat.showUnsupported");
    private static final String JVMSTAT_USERDIR = ".jvmstat";
    private static final String OPTIONS_FILENAME = "jstat_options";
    private static final String UNSUPPORTED_OPTIONS_FILENAME = "jstat_unsupported_options";
    private static final String ALL_NAMES = "\\w*";
    private Comparator<Monitor> comparator;
    private int headerRate;
    private boolean help;
    private boolean list;
    private boolean options;
    private boolean constants;
    private boolean constantsOnly;
    private boolean strings;
    private boolean timestamp;
    private boolean snap;
    private boolean verbose;
    private String specialOption;
    private String names;
    private OptionFormat optionFormat;
    private int count = -1;
    private int interval = -1;
    private String vmIdString;
    private VmIdentifier vmId;

    public static void printUsage(PrintStream ps) {
        ps.println("Usage: jstat -help|-options");
        ps.println("       jstat -<option> [-t] [-h<lines>] <vmid> [<interval> [<count>]]");
        ps.println();
        ps.println("Definitions:");
        ps.println("  <option>      An option reported by the -options option");
        ps.println("  <vmid>        Virtual Machine Identifier. A vmid takes the following form:");
        ps.println("                     <lvmid>[@<hostname>[:<port>]]");
        ps.println("                Where <lvmid> is the local vm identifier for the target");
        ps.println("                Java virtual machine, typically a process id; <hostname> is");
        ps.println("                the name of the host running the target Java virtual machine;");
        ps.println("                and <port> is the port number for the rmiregistry on the");
        ps.println("                target host. See the jvmstat documentation for a more complete");
        ps.println("                description of the Virtual Machine Identifier.");
        ps.println("  <lines>       Number of samples between header lines.");
        ps.println("  <interval>    Sampling interval. The following forms are allowed:");
        ps.println("                    <n>[\"ms\"|\"s\"]");
        ps.println("                Where <n> is an integer and the suffix specifies the units as ");
        ps.println("                milliseconds(\"ms\") or seconds(\"s\"). The default units are \"ms\".");
        ps.println("  <count>       Number of samples to take before terminating.");
        ps.println("  -J<flag>      Pass <flag> directly to the runtime system.");
    }

    private static int toMillis(String s) throws IllegalArgumentException {
        String[] unitStrings = new String[]{"ms", "s"};
        String unitString = null;
        String valueString = s;
        for (int i = 0; i < unitStrings.length; ++i) {
            int index = s.indexOf(unitStrings[i]);
            if (index <= 0) continue;
            unitString = s.substring(index);
            valueString = s.substring(0, index);
            break;
        }
        try {
            int value = Integer.parseInt(valueString);
            if (unitString == null || unitString.compareTo("ms") == 0) {
                return value;
            }
            if (unitString.compareTo("s") == 0) {
                return value * 1000;
            }
            throw new IllegalArgumentException("Unknow time unit: " + unitString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not convert interval: " + s);
        }
    }

    public Arguments(String[] args) throws IllegalArgumentException {
        int argc = 0;
        if (args.length < 1) {
            throw new IllegalArgumentException("invalid argument count");
        }
        if (args[0].compareTo("-?") == 0 || args[0].compareTo("-help") == 0) {
            this.help = true;
            return;
        }
        if (args[0].compareTo("-options") == 0) {
            this.options = true;
            return;
        }
        if (args[0].compareTo("-list") == 0) {
            this.list = true;
            if (args.length > 2) {
                throw new IllegalArgumentException("invalid argument count");
            }
            ++argc;
        }
        while (argc < args.length && args[argc].startsWith("-")) {
            String arg = args[argc];
            if (arg.compareTo("-a") == 0) {
                this.comparator = new AscendingMonitorComparator();
            } else if (arg.compareTo("-d") == 0) {
                this.comparator = new DescendingMonitorComparator();
            } else if (arg.compareTo("-t") == 0) {
                this.timestamp = true;
            } else if (arg.compareTo("-v") == 0) {
                this.verbose = true;
            } else if (arg.compareTo("-constants") == 0 || arg.compareTo("-c") == 0) {
                this.constants = true;
            } else if (arg.compareTo("-strings") == 0 || arg.compareTo("-s") == 0) {
                this.strings = true;
            } else if (arg.startsWith("-h")) {
                String value;
                if (arg.compareTo("-h") != 0) {
                    value = arg.substring(2);
                } else {
                    if (++argc >= args.length) {
                        throw new IllegalArgumentException("-h requires an integer argument");
                    }
                    value = args[argc];
                }
                try {
                    this.headerRate = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.headerRate = -1;
                }
                if (this.headerRate < 0) {
                    throw new IllegalArgumentException("illegal -h argument: " + value);
                }
            } else if (arg.startsWith("-name")) {
                if (arg.startsWith("-name=")) {
                    this.names = arg.substring(7);
                } else {
                    if (++argc >= args.length) {
                        throw new IllegalArgumentException("option argument expected");
                    }
                    this.names = args[argc];
                }
            } else {
                String lvmidStr = null;
                int at_index = args[argc].indexOf(64);
                lvmidStr = at_index < 0 ? args[argc] : args[argc].substring(0, at_index);
                try {
                    int vmid = Integer.parseInt(lvmidStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    if (argc == 0 && args[argc].compareTo("-snap") == 0) {
                        this.snap = true;
                    }
                    if (argc == 0) {
                        this.specialOption = args[argc].substring(1);
                    }
                    throw new IllegalArgumentException("illegal argument: " + args[argc]);
                }
            }
            ++argc;
        }
        if (this.specialOption == null && !this.list && !this.snap && this.names == null) {
            throw new IllegalArgumentException("-<option> required");
        }
        switch (args.length - argc) {
            case 3: {
                if (this.snap) {
                    throw new IllegalArgumentException("invalid argument count");
                }
                try {
                    this.count = Integer.parseInt(args[args.length - 1]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("illegal count value: " + args[args.length - 1]);
                }
                this.interval = Arguments.toMillis(args[args.length - 2]);
                this.vmIdString = args[args.length - 3];
                break;
            }
            case 2: {
                if (this.snap) {
                    throw new IllegalArgumentException("invalid argument count");
                }
                this.interval = Arguments.toMillis(args[args.length - 1]);
                this.vmIdString = args[args.length - 2];
                break;
            }
            case 1: {
                this.vmIdString = args[args.length - 1];
                break;
            }
            case 0: {
                if (this.list) break;
                throw new IllegalArgumentException("invalid argument count");
            }
            default: {
                throw new IllegalArgumentException("invalid argument count");
            }
        }
        if (this.count == -1 && this.interval == -1) {
            this.count = 1;
            this.interval = 0;
        }
        if (this.comparator == null) {
            this.comparator = new AscendingMonitorComparator();
        }
        this.names = this.names == null ? ALL_NAMES : this.names.replace(',', '|');
        try {
            Pattern e = Pattern.compile(this.names);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Bad name pattern: " + e.getMessage());
        }
        if (this.specialOption != null) {
            OptionFinder finder = new OptionFinder(this.optionsSources());
            this.optionFormat = finder.getOptionFormat(this.specialOption, this.timestamp);
            if (this.optionFormat == null) {
                throw new IllegalArgumentException("Unknown option: -" + this.specialOption);
            }
        }
        try {
            this.vmId = new VmIdentifier(this.vmIdString);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Malformed VM Identifier: " + this.vmIdString);
            iae.initCause(e);
            throw iae;
        }
    }

    public Comparator<Monitor> comparator() {
        return this.comparator;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isSnap() {
        return this.snap;
    }

    public boolean isOptions() {
        return this.options;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean printConstants() {
        return this.constants;
    }

    public boolean isConstantsOnly() {
        return this.constantsOnly;
    }

    public boolean printStrings() {
        return this.strings;
    }

    public boolean showUnsupported() {
        return showUnsupported;
    }

    public int headerRate() {
        return this.headerRate;
    }

    public String counterNames() {
        return this.names;
    }

    public VmIdentifier vmId() {
        return this.vmId;
    }

    public String vmIdString() {
        return this.vmIdString;
    }

    public int sampleInterval() {
        return this.interval;
    }

    public int sampleCount() {
        return this.count;
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public boolean isSpecialOption() {
        return this.specialOption != null;
    }

    public String specialOption() {
        return this.specialOption;
    }

    public OptionFormat optionFormat() {
        return this.optionFormat;
    }

    public List<URL> optionsSources() {
        ArrayList<URL> sources = new ArrayList<URL>();
        boolean i = false;
        String filename = OPTIONS_FILENAME;
        try {
            String userHome = System.getProperty("user.home");
            String userDir = userHome + "/" + JVMSTAT_USERDIR;
            File home = new File(userDir + "/" + filename);
            sources.add(home.toURI().toURL());
        }
        catch (Exception e) {
            if (debug) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            throw new IllegalArgumentException("Internal Error: Bad URL: " + e.getMessage());
        }
        URL u = this.getClass().getResource("resources/" + filename);
        assert (u != null);
        sources.add(u);
        if (showUnsupported) {
            u = this.getClass().getResource("resources/jstat_unsupported_options");
            assert (u != null);
            sources.add(u);
        }
        return sources;
    }
}

