/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import sun.tools.jstat.Alignment;
import sun.tools.jstat.Expression;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.ParserException;
import sun.tools.jstat.Scale;

public class ColumnFormat
extends OptionFormat {
    private int number;
    private int width;
    private Alignment align = Alignment.CENTER;
    private Scale scale = Scale.RAW;
    private String format;
    private String header;
    private Expression expression;
    private Object previousValue;

    public ColumnFormat(int number) {
        super("Column" + number);
        this.number = number;
    }

    public void validate() throws ParserException {
        if (this.expression == null) {
            throw new ParserException("Missing data statement in column " + this.number);
        }
        if (this.header == null) {
            throw new ParserException("Missing header statement in column " + this.number);
        }
        if (this.format == null) {
            this.format = "0";
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setAlignment(Alignment align) {
        this.align = align;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public String getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public Alignment getAlignment() {
        return this.align;
    }

    public Scale getScale() {
        return this.scale;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression e) {
        this.expression = e;
    }

    public void setPreviousValue(Object o) {
        this.previousValue = o;
    }

    public Object getPreviousValue() {
        return this.previousValue;
    }

    @Override
    public void printFormat(int indentLevel) {
        String indentAmount = "  ";
        StringBuilder indent = new StringBuilder("");
        for (int j = 0; j < indentLevel; ++j) {
            indent.append(indentAmount);
        }
        System.out.println(indent + this.name + " {");
        System.out.println(indent + indentAmount + "name=" + this.name + ";data=" + this.expression.toString() + ";header=" + this.header + ";format=" + this.format + ";width=" + this.width + ";scale=" + this.scale.toString() + ";align=" + this.align.toString());
        for (OptionFormat of : this.children) {
            of.printFormat(indentLevel + 1);
        }
        System.out.println(indent + "}");
    }

    public String getValue() {
        return null;
    }
}

