/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import sun.tools.jstat.Operator;

public class Expression {
    private static int nextOrdinal;
    private boolean debug = Boolean.getBoolean("Expression.debug");
    private Expression left;
    private Expression right;
    private Operator operator;
    private int ordinal = nextOrdinal++;

    Expression() {
        if (this.debug) {
            System.out.println("Expression " + this.ordinal + " created");
        }
    }

    void setLeft(Expression left) {
        if (this.debug) {
            System.out.println("Setting left on " + this.ordinal + " to " + left);
        }
        this.left = left;
    }

    Expression getLeft() {
        return this.left;
    }

    void setRight(Expression right) {
        if (this.debug) {
            System.out.println("Setting right on " + this.ordinal + " to " + right);
        }
        this.right = right;
    }

    Expression getRight() {
        return this.right;
    }

    void setOperator(Operator o) {
        if (this.debug) {
            System.out.println("Setting operator on " + this.ordinal + " to " + o);
        }
        this.operator = o;
    }

    Operator getOperator() {
        return this.operator;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('(');
        if (this.left != null) {
            b.append(this.left.toString());
        }
        if (this.operator != null) {
            b.append(this.operator.toString());
            if (this.right != null) {
                b.append(this.right.toString());
            }
        }
        b.append(')');
        return b.toString();
    }
}

