/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.HashMap;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitoredVm;
import sun.tools.jstat.Expression;
import sun.tools.jstat.ExpressionEvaluator;
import sun.tools.jstat.Identifier;
import sun.tools.jstat.Literal;
import sun.tools.jstat.Operator;

public class ExpressionExecuter
implements ExpressionEvaluator {
    private static final boolean debug = Boolean.getBoolean("ExpressionEvaluator.debug");
    private MonitoredVm vm;
    private HashMap<String, Object> map = new HashMap();

    ExpressionExecuter(MonitoredVm vm) {
        this.vm = vm;
    }

    @Override
    public Object evaluate(Expression e) {
        if (e == null) {
            return null;
        }
        if (debug) {
            System.out.println("Evaluating expression: " + e);
        }
        if (e instanceof Literal) {
            return ((Literal)e).getValue();
        }
        if (e instanceof Identifier) {
            Identifier id = (Identifier)e;
            if (this.map.containsKey(id.getName())) {
                return this.map.get(id.getName());
            }
            Monitor m = (Monitor)id.getValue();
            Object v = m.getValue();
            this.map.put(id.getName(), v);
            return v;
        }
        Expression l = e.getLeft();
        Expression r = e.getRight();
        Operator op = e.getOperator();
        if (op == null) {
            return this.evaluate(l);
        }
        Double lval = new Double(((Number)this.evaluate(l)).doubleValue());
        Double rval = new Double(((Number)this.evaluate(r)).doubleValue());
        double result = op.eval(lval, rval);
        if (debug) {
            System.out.println("Performed Operation: " + lval + op + rval + " = " + result);
        }
        return new Double(result);
    }
}

