/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.Units;
import sun.jvmstat.monitor.Variability;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostEvent;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;
import sun.tools.jstat.Arguments;
import sun.tools.jstat.JStatLogger;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.OptionLister;
import sun.tools.jstat.OptionOutputFormatter;
import sun.tools.jstat.OutputFormatter;
import sun.tools.jstat.RawOutputFormatter;

public class Jstat {
    private static Arguments arguments;

    public static void main(String[] args) {
        try {
            arguments = new Arguments(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Arguments.printUsage(System.err);
            System.exit(1);
        }
        if (arguments.isHelp()) {
            Arguments.printUsage(System.out);
            System.exit(0);
        }
        if (arguments.isOptions()) {
            OptionLister ol = new OptionLister(arguments.optionsSources());
            ol.print(System.out);
            System.exit(0);
        }
        try {
            if (arguments.isList()) {
                Jstat.logNames();
            } else if (arguments.isSnap()) {
                Jstat.logSnapShot();
            } else {
                Jstat.logSamples();
            }
        }
        catch (MonitorException e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            } else {
                Throwable cause = e.getCause();
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(cause.getMessage());
                } else {
                    e.printStackTrace();
                }
            }
            System.exit(1);
        }
        System.exit(0);
    }

    static void logNames() throws MonitorException {
        VmIdentifier vmId = arguments.vmId();
        int interval = arguments.sampleInterval();
        MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmId);
        MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmId, interval);
        JStatLogger logger = new JStatLogger(monitoredVm);
        logger.printNames(arguments.counterNames(), arguments.comparator(), arguments.showUnsupported(), System.out);
        monitoredHost.detach(monitoredVm);
    }

    static void logSnapShot() throws MonitorException {
        VmIdentifier vmId = arguments.vmId();
        int interval = arguments.sampleInterval();
        MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmId);
        MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmId, interval);
        JStatLogger logger = new JStatLogger(monitoredVm);
        logger.printSnapShot(arguments.counterNames(), arguments.comparator(), arguments.isVerbose(), arguments.showUnsupported(), System.out);
        monitoredHost.detach(monitoredVm);
    }

    static void logSamples() throws MonitorException {
        final VmIdentifier vmId = arguments.vmId();
        int interval = arguments.sampleInterval();
        final MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(vmId);
        MonitoredVm monitoredVm = monitoredHost.getMonitoredVm(vmId, interval);
        final JStatLogger logger = new JStatLogger(monitoredVm);
        OutputFormatter formatter = null;
        if (arguments.isSpecialOption()) {
            OptionFormat format = arguments.optionFormat();
            formatter = new OptionOutputFormatter(monitoredVm, format);
        } else {
            List<Monitor> logged = monitoredVm.findByPattern(arguments.counterNames());
            Collections.sort(logged, arguments.comparator());
            ArrayList<Monitor> constants = new ArrayList<Monitor>();
            Iterator<Monitor> i = logged.iterator();
            while (i.hasNext()) {
                Monitor m = i.next();
                if (!m.isSupported() && !arguments.showUnsupported()) {
                    i.remove();
                    continue;
                }
                if (m.getVariability() == Variability.CONSTANT) {
                    i.remove();
                    if (!arguments.printConstants()) continue;
                    constants.add(m);
                    continue;
                }
                if (m.getUnits() != Units.STRING || arguments.printStrings()) continue;
                i.remove();
            }
            if (!constants.isEmpty()) {
                logger.printList(constants, arguments.isVerbose(), arguments.showUnsupported(), System.out);
                if (!logged.isEmpty()) {
                    System.out.println();
                }
            }
            if (logged.isEmpty()) {
                monitoredHost.detach(monitoredVm);
                return;
            }
            formatter = new RawOutputFormatter(logged, arguments.printStrings());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.stopLogging();
            }
        });
        HostListener terminator = new HostListener(){

            @Override
            public void vmStatusChanged(VmStatusChangeEvent ev) {
                Integer lvmid = new Integer(vmId.getLocalVmId());
                if (ev.getTerminated().contains(lvmid)) {
                    logger.stopLogging();
                } else if (!ev.getActive().contains(lvmid)) {
                    logger.stopLogging();
                }
            }

            @Override
            public void disconnected(HostEvent ev) {
                if (monitoredHost == ev.getMonitoredHost()) {
                    logger.stopLogging();
                }
            }
        };
        if (vmId.getLocalVmId() != 0) {
            monitoredHost.addHostListener(terminator);
        }
        logger.logSamples(formatter, arguments.headerRate(), arguments.sampleInterval(), arguments.sampleCount(), System.out);
        if (terminator != null) {
            monitoredHost.removeHostListener(terminator);
        }
        monitoredHost.detach(monitoredVm);
    }
}

