/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.HashMap;
import java.util.Set;

public abstract class Operator {
    private static int nextOrdinal = 0;
    private static HashMap<String, Operator> map = new HashMap();
    private final String name;
    private final int ordinal = nextOrdinal++;
    public static final Operator PLUS = new Operator("+"){

        @Override
        protected double eval(double x, double y) {
            return x + y;
        }
    };
    public static final Operator MINUS = new Operator("-"){

        @Override
        protected double eval(double x, double y) {
            return x - y;
        }
    };
    public static final Operator DIVIDE = new Operator("/"){

        @Override
        protected double eval(double x, double y) {
            if (y == 0.0) {
                return Double.NaN;
            }
            return x / y;
        }
    };
    public static final Operator MULTIPLY = new Operator("*"){

        @Override
        protected double eval(double x, double y) {
            return x * y;
        }
    };

    private Operator(String name) {
        this.name = name;
        map.put(name, this);
    }

    protected abstract double eval(double var1, double var3);

    public String toString() {
        return this.name;
    }

    public static Operator toOperator(String s) {
        return map.get(s);
    }

    protected static Set keySet() {
        return map.keySet();
    }
}

