/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import sun.tools.jstat.ColumnFormat;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.Parser;
import sun.tools.jstat.ParserException;

public class OptionFinder {
    private static final boolean debug = false;
    List<URL> optionsSources;

    public OptionFinder(List<URL> optionsSources) {
        this.optionsSources = optionsSources;
    }

    public OptionFormat getOptionFormat(String option, boolean useTimestamp) {
        OptionFormat of = this.getOptionFormat(option, this.optionsSources);
        OptionFormat tof = null;
        if (of != null && useTimestamp && (tof = this.getOptionFormat("timestamp", this.optionsSources)) != null) {
            ColumnFormat cf = (ColumnFormat)tof.getSubFormat(0);
            of.insertSubFormat(0, cf);
        }
        return of;
    }

    protected OptionFormat getOptionFormat(String option, List<URL> sources) {
        OptionFormat of = null;
        for (URL u : sources) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream()));
                of = new Parser(r).parse(option);
                if (of == null) continue;
                break;
            }
            catch (IOException r) {
            }
            catch (ParserException e) {
                System.err.println(u + ": " + e.getMessage());
                System.err.println("Parsing of " + u + " aborted");
            }
        }
        return of;
    }
}

