/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.jvmstat.monitor.MonitorException;
import sun.tools.jstat.Closure;

public class OptionFormat {
    protected String name;
    protected List<OptionFormat> children;

    public OptionFormat(String name) {
        this.name = name;
        this.children = new ArrayList<OptionFormat>();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptionFormat)) {
            return false;
        }
        OptionFormat of = (OptionFormat)o;
        return this.name.compareTo(of.name) == 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void addSubFormat(OptionFormat f) {
        this.children.add(f);
    }

    public OptionFormat getSubFormat(int index) {
        return this.children.get(index);
    }

    public void insertSubFormat(int index, OptionFormat f) {
        this.children.add(index, f);
    }

    public String getName() {
        return this.name;
    }

    public void apply(Closure c) throws MonitorException {
        Iterator<OptionFormat> i = this.children.iterator();
        while (i.hasNext()) {
            OptionFormat o = i.next();
            c.visit(o, i.hasNext());
        }
        for (OptionFormat o : this.children) {
            o.apply(c);
        }
    }

    public void printFormat() {
        this.printFormat(0);
    }

    public void printFormat(int indentLevel) {
        String indentAmount = "  ";
        StringBuilder indent = new StringBuilder("");
        for (int j = 0; j < indentLevel; ++j) {
            indent.append(indentAmount);
        }
        System.out.println(indent + this.name + " {");
        for (OptionFormat of : this.children) {
            of.printFormat(indentLevel + 1);
        }
        System.out.println(indent + "}");
    }
}

