/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.Parser;
import sun.tools.jstat.ParserException;

public class OptionLister {
    private static final boolean debug = false;
    private List<URL> sources;

    public OptionLister(List<URL> sources) {
        this.sources = sources;
    }

    public void print(PrintStream ps) {
        Comparator<OptionFormat> c = new Comparator<OptionFormat>(){

            @Override
            public int compare(OptionFormat o1, OptionFormat o2) {
                OptionFormat of1 = o1;
                OptionFormat of2 = o2;
                return of1.getName().compareTo(of2.getName());
            }
        };
        TreeSet<OptionFormat> options = new TreeSet<OptionFormat>(c);
        for (URL u : this.sources) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream()));
                Set<OptionFormat> s = new Parser(r).parseOptions();
                options.addAll(s);
            }
            catch (IOException r) {
            }
            catch (ParserException e) {
                System.err.println(u + ": " + e.getMessage());
                System.err.println("Parsing of " + u + " aborted");
            }
        }
        for (OptionFormat of : options) {
            if (of.getName().compareTo("timestamp") == 0) continue;
            ps.println("-" + of.getName());
        }
    }
}

