/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.tools.jstat.ExpressionResolver;
import sun.tools.jstat.HeaderClosure;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.OutputFormatter;
import sun.tools.jstat.RowClosure;
import sun.tools.jstat.SymbolResolutionClosure;

public class OptionOutputFormatter
implements OutputFormatter {
    private OptionFormat format;
    private String header;
    private MonitoredVm vm;

    public OptionOutputFormatter(MonitoredVm vm, OptionFormat format) throws MonitorException {
        this.vm = vm;
        this.format = format;
        this.resolve();
    }

    private void resolve() throws MonitorException {
        ExpressionResolver ee = new ExpressionResolver(this.vm);
        SymbolResolutionClosure ec = new SymbolResolutionClosure(ee);
        this.format.apply(ec);
    }

    @Override
    public String getHeader() throws MonitorException {
        if (this.header == null) {
            HeaderClosure hc = new HeaderClosure();
            this.format.apply(hc);
            this.header = hc.getHeader();
        }
        return this.header;
    }

    @Override
    public String getRow() throws MonitorException {
        RowClosure rc = new RowClosure(this.vm);
        this.format.apply(rc);
        return rc.getRow();
    }
}

