/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashSet;
import java.util.Set;
import sun.tools.jstat.Alignment;
import sun.tools.jstat.ColumnFormat;
import sun.tools.jstat.Expression;
import sun.tools.jstat.Identifier;
import sun.tools.jstat.Literal;
import sun.tools.jstat.Operator;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.ParserException;
import sun.tools.jstat.Scale;
import sun.tools.jstat.SyntaxException;
import sun.tools.jstat.Token;

public class Parser {
    private static boolean pdebug = Boolean.getBoolean("jstat.parser.debug");
    private static boolean ldebug = Boolean.getBoolean("jstat.lex.debug");
    private static final char OPENBLOCK = '{';
    private static final char CLOSEBLOCK = '}';
    private static final char DOUBLEQUOTE = '\"';
    private static final char PERCENT_CHAR = '%';
    private static final char OPENPAREN = '(';
    private static final char CLOSEPAREN = ')';
    private static final char OPERATOR_PLUS = '+';
    private static final char OPERATOR_MINUS = '-';
    private static final char OPERATOR_MULTIPLY = '*';
    private static final char OPERATOR_DIVIDE = '/';
    private static final String OPTION = "option";
    private static final String COLUMN = "column";
    private static final String DATA = "data";
    private static final String HEADER = "header";
    private static final String WIDTH = "width";
    private static final String FORMAT = "format";
    private static final String ALIGN = "align";
    private static final String SCALE = "scale";
    private static final String START = "option";
    private static final Set scaleKeyWords = Scale.keySet();
    private static final Set alignKeyWords = Alignment.keySet();
    private static String[] otherKeyWords = new String[]{"option", "column", "data", "header", "width", "format", "align", "scale"};
    private static char[] infixOps = new char[]{'+', '-', '*', '/'};
    private static char[] delimiters = new char[]{'{', '}', '%', '(', ')'};
    private static Set<String> reservedWords;
    private StreamTokenizer st;
    private String filename;
    private Token lookahead;
    private Token previous;
    private int columnCount;
    private OptionFormat optionFormat;

    public Parser(String filename) throws FileNotFoundException {
        this.filename = filename;
        BufferedReader r = new BufferedReader(new FileReader(filename));
    }

    public Parser(Reader r) {
        int i;
        this.st = new StreamTokenizer(r);
        this.st.ordinaryChar(47);
        this.st.wordChars(95, 95);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        reservedWords = new HashSet<String>();
        for (i = 0; i < otherKeyWords.length; ++i) {
            reservedWords.add(otherKeyWords[i]);
        }
        for (i = 0; i < delimiters.length; ++i) {
            this.st.ordinaryChar(delimiters[i]);
        }
        for (i = 0; i < infixOps.length; ++i) {
            this.st.ordinaryChar(infixOps[i]);
        }
    }

    private void pushBack() {
        this.lookahead = this.previous;
        this.st.pushBack();
    }

    private void nextToken() throws ParserException, IOException {
        int t = this.st.nextToken();
        this.previous = this.lookahead;
        this.lookahead = new Token(this.st.ttype, this.st.sval, this.st.nval);
        this.log(ldebug, "lookahead = " + this.lookahead);
    }

    private Token matchOne(Set keyWords) throws ParserException, IOException {
        if (this.lookahead.ttype == -3 && keyWords.contains(this.lookahead.sval)) {
            Token t = this.lookahead;
            this.nextToken();
            return t;
        }
        throw new SyntaxException(this.st.lineno(), keyWords, this.lookahead);
    }

    private void match(int ttype, String token) throws ParserException, IOException {
        if (this.lookahead.ttype != ttype || this.lookahead.sval.compareTo(token) != 0) {
            throw new SyntaxException(this.st.lineno(), new Token(ttype, token), this.lookahead);
        }
        this.nextToken();
    }

    private void match(int ttype) throws ParserException, IOException {
        if (this.lookahead.ttype != ttype) {
            throw new SyntaxException(this.st.lineno(), new Token(ttype), this.lookahead);
        }
        this.nextToken();
    }

    private void match(char ttype) throws ParserException, IOException {
        if (this.lookahead.ttype != ttype) {
            throw new SyntaxException(this.st.lineno(), new Token(ttype), this.lookahead);
        }
        this.nextToken();
    }

    private void matchQuotedString() throws ParserException, IOException {
        this.match('\"');
    }

    private void matchNumber() throws ParserException, IOException {
        this.match(-2);
    }

    private void matchID() throws ParserException, IOException {
        this.match(-3);
    }

    private void match(String token) throws ParserException, IOException {
        this.match(-3, token);
    }

    private boolean isReservedWord(String word) {
        return reservedWords.contains(word);
    }

    private boolean isInfixOperator(char op) {
        for (int i = 0; i < infixOps.length; ++i) {
            if (op != infixOps[i]) continue;
            return true;
        }
        return false;
    }

    private void scaleStmt(ColumnFormat cf) throws ParserException, IOException {
        this.match(SCALE);
        Token t = this.matchOne(scaleKeyWords);
        cf.setScale(Scale.toScale(t.sval));
        String scaleString = t.sval;
        this.log(pdebug, "Parsed: scale -> " + scaleString);
    }

    private void alignStmt(ColumnFormat cf) throws ParserException, IOException {
        this.match(ALIGN);
        Token t = this.matchOne(alignKeyWords);
        cf.setAlignment(Alignment.toAlignment(t.sval));
        String alignString = t.sval;
        this.log(pdebug, "Parsed: align -> " + alignString);
    }

    private void headerStmt(ColumnFormat cf) throws ParserException, IOException {
        this.match(HEADER);
        String headerString = this.lookahead.sval;
        this.matchQuotedString();
        cf.setHeader(headerString);
        this.log(pdebug, "Parsed: header -> " + headerString);
    }

    private void widthStmt(ColumnFormat cf) throws ParserException, IOException {
        this.match(WIDTH);
        double width = this.lookahead.nval;
        this.matchNumber();
        cf.setWidth((int)width);
        this.log(pdebug, "Parsed: width -> " + width);
    }

    private void formatStmt(ColumnFormat cf) throws ParserException, IOException {
        this.match(FORMAT);
        String formatString = this.lookahead.sval;
        this.matchQuotedString();
        cf.setFormat(formatString);
        this.log(pdebug, "Parsed: format -> " + formatString);
    }

    private Expression primary() throws ParserException, IOException {
        Expression e = null;
        switch (this.lookahead.ttype) {
            case 40: {
                this.match('(');
                e = this.expression();
                this.match(')');
                break;
            }
            case -3: {
                String s = this.lookahead.sval;
                if (this.isReservedWord(s)) {
                    throw new SyntaxException(this.st.lineno(), "IDENTIFIER", "Reserved Word: " + this.lookahead.sval);
                }
                this.matchID();
                e = new Identifier(s);
                this.log(pdebug, "Parsed: ID -> " + s);
                break;
            }
            case -2: {
                double literal = this.lookahead.nval;
                this.matchNumber();
                e = new Literal(new Double(literal));
                this.log(pdebug, "Parsed: number -> " + literal);
                break;
            }
            default: {
                throw new SyntaxException(this.st.lineno(), "IDENTIFIER", this.lookahead);
            }
        }
        this.log(pdebug, "Parsed: primary -> " + e);
        return e;
    }

    private Expression unary() throws ParserException, IOException {
        Expression e = null;
        Operator op = null;
        while (true) {
            switch (this.lookahead.ttype) {
                case 43: {
                    this.match('+');
                    op = Operator.PLUS;
                    break;
                }
                case 45: {
                    this.match('-');
                    op = Operator.MINUS;
                    break;
                }
                default: {
                    e = this.primary();
                    this.log(pdebug, "Parsed: unary -> " + e);
                    return e;
                }
            }
            Expression e1 = new Expression();
            e1.setOperator(op);
            e1.setRight(e);
            this.log(pdebug, "Parsed: unary -> " + e1);
            e1.setLeft(new Literal(new Double(0.0)));
            e = e1;
        }
    }

    private Expression multExpression() throws ParserException, IOException {
        Expression e = this.unary();
        Operator op = null;
        while (true) {
            switch (this.lookahead.ttype) {
                case 42: {
                    this.match('*');
                    op = Operator.MULTIPLY;
                    break;
                }
                case 47: {
                    this.match('/');
                    op = Operator.DIVIDE;
                    break;
                }
                default: {
                    this.log(pdebug, "Parsed: multExpression -> " + e);
                    return e;
                }
            }
            Expression e1 = new Expression();
            e1.setOperator(op);
            e1.setLeft(e);
            e1.setRight(this.unary());
            e = e1;
            this.log(pdebug, "Parsed: multExpression -> " + e);
        }
    }

    private Expression addExpression() throws ParserException, IOException {
        Expression e = this.multExpression();
        Operator op = null;
        while (true) {
            switch (this.lookahead.ttype) {
                case 43: {
                    this.match('+');
                    op = Operator.PLUS;
                    break;
                }
                case 45: {
                    this.match('-');
                    op = Operator.MINUS;
                    break;
                }
                default: {
                    this.log(pdebug, "Parsed: addExpression -> " + e);
                    return e;
                }
            }
            Expression e1 = new Expression();
            e1.setOperator(op);
            e1.setLeft(e);
            e1.setRight(this.multExpression());
            e = e1;
            this.log(pdebug, "Parsed: addExpression -> " + e);
        }
    }

    private Expression expression() throws ParserException, IOException {
        Expression e = this.addExpression();
        this.log(pdebug, "Parsed: expression -> " + e);
        return e;
    }

    private void dataStmt(ColumnFormat cf) throws ParserException, IOException {
        this.match(DATA);
        Expression e = this.expression();
        cf.setExpression(e);
        this.log(pdebug, "Parsed: data -> " + e);
    }

    private void statementList(ColumnFormat cf) throws ParserException, IOException {
        while (true) {
            if (this.lookahead.ttype != -3) {
                return;
            }
            if (this.lookahead.sval.compareTo(DATA) == 0) {
                this.dataStmt(cf);
                continue;
            }
            if (this.lookahead.sval.compareTo(HEADER) == 0) {
                this.headerStmt(cf);
                continue;
            }
            if (this.lookahead.sval.compareTo(WIDTH) == 0) {
                this.widthStmt(cf);
                continue;
            }
            if (this.lookahead.sval.compareTo(FORMAT) == 0) {
                this.formatStmt(cf);
                continue;
            }
            if (this.lookahead.sval.compareTo(ALIGN) == 0) {
                this.alignStmt(cf);
                continue;
            }
            if (this.lookahead.sval.compareTo(SCALE) != 0) break;
            this.scaleStmt(cf);
        }
    }

    private void optionList(OptionFormat of) throws ParserException, IOException {
        while (this.lookahead.ttype == -3) {
            this.match(COLUMN);
            this.match('{');
            ColumnFormat cf = new ColumnFormat(this.columnCount++);
            this.statementList(cf);
            this.match('}');
            cf.validate();
            of.addSubFormat(cf);
        }
        return;
    }

    private OptionFormat optionStmt() throws ParserException, IOException {
        this.match("option");
        String optionName = this.lookahead.sval;
        this.matchID();
        this.match('{');
        OptionFormat of = new OptionFormat(optionName);
        this.optionList(of);
        this.match('}');
        return of;
    }

    public OptionFormat parse(String option) throws ParserException, IOException {
        this.nextToken();
        while (this.lookahead.ttype != -1) {
            if (this.lookahead.ttype != -3 || this.lookahead.sval.compareTo("option") != 0) {
                this.nextToken();
                continue;
            }
            this.match("option");
            if (this.lookahead.ttype == -3 && this.lookahead.sval.compareTo(option) == 0) {
                this.pushBack();
                return this.optionStmt();
            }
            this.nextToken();
        }
        return null;
    }

    public Set<OptionFormat> parseOptions() throws ParserException, IOException {
        HashSet<OptionFormat> options = new HashSet<OptionFormat>();
        this.nextToken();
        while (this.lookahead.ttype != -1) {
            if (this.lookahead.ttype != -3 || this.lookahead.sval.compareTo("option") != 0) {
                this.nextToken();
                continue;
            }
            OptionFormat of = this.optionStmt();
            options.add(of);
        }
        return options;
    }

    OptionFormat getOptionFormat() {
        return this.optionFormat;
    }

    private void log(boolean logging2, String s) {
        if (logging2) {
            System.out.println(s);
        }
    }
}

