/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.List;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.StringMonitor;
import sun.tools.jstat.OutputFormatter;

public class RawOutputFormatter
implements OutputFormatter {
    private List logged;
    private String header;
    private boolean printStrings;

    public RawOutputFormatter(List logged, boolean printStrings) {
        this.logged = logged;
        this.printStrings = printStrings;
    }

    @Override
    public String getHeader() throws MonitorException {
        if (this.header == null) {
            StringBuilder headerBuilder = new StringBuilder();
            for (Monitor m : this.logged) {
                headerBuilder.append(m.getName() + " ");
            }
            this.header = headerBuilder.toString();
        }
        return this.header;
    }

    @Override
    public String getRow() throws MonitorException {
        StringBuilder row = new StringBuilder();
        int count = 0;
        for (Monitor m : this.logged) {
            if (count++ > 0) {
                row.append(" ");
            }
            if (this.printStrings && m instanceof StringMonitor) {
                row.append("\"").append(m.getValue()).append("\"");
                continue;
            }
            row.append(m.getValue());
        }
        return row.toString();
    }
}

