/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.tools.jstat.Closure;
import sun.tools.jstat.ColumnFormat;
import sun.tools.jstat.Expression;
import sun.tools.jstat.ExpressionExecuter;

public class RowClosure
implements Closure {
    private MonitoredVm vm;
    private StringBuilder row = new StringBuilder();

    public RowClosure(MonitoredVm vm) {
        this.vm = vm;
    }

    @Override
    public void visit(Object o, boolean hasNext) throws MonitorException {
        if (!(o instanceof ColumnFormat)) {
            return;
        }
        ColumnFormat c = (ColumnFormat)o;
        String s = null;
        ExpressionExecuter ee = new ExpressionExecuter(this.vm);
        Expression e = c.getExpression();
        Object value = ee.evaluate(e);
        if (value instanceof String) {
            s = (String)value;
        } else if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            double scaledValue = c.getScale().scale(d);
            DecimalFormat df = new DecimalFormat(c.getFormat());
            DecimalFormatSymbols syms = df.getDecimalFormatSymbols();
            syms.setNaN("-");
            df.setDecimalFormatSymbols(syms);
            s = df.format(scaledValue);
        }
        c.setPreviousValue(value);
        s = c.getAlignment().align(s, c.getWidth());
        this.row.append(s);
        if (hasNext) {
            this.row.append(" ");
        }
    }

    public String getRow() {
        return this.row.toString();
    }
}

