/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.Set;
import sun.tools.jstat.ParserException;
import sun.tools.jstat.Token;

public class SyntaxException
extends ParserException {
    private String message;

    public SyntaxException(String message) {
        this.message = message;
    }

    public SyntaxException(int lineno, String expected, String found) {
        this.message = "Syntax error at line " + lineno + ": Expected " + expected + ", Found " + found;
    }

    public SyntaxException(int lineno, String expected, Token found) {
        this.message = "Syntax error at line " + lineno + ": Expected " + expected + ", Found " + found.toMessage();
    }

    public SyntaxException(int lineno, Token expected, Token found) {
        this.message = "Syntax error at line " + lineno + ": Expected " + expected.toMessage() + ", Found " + found.toMessage();
    }

    public SyntaxException(int lineno, Set expected, Token found) {
        StringBuilder msg = new StringBuilder();
        msg.append("Syntax error at line " + lineno + ": Expected one of '");
        boolean first = true;
        for (String keyWord : expected) {
            if (first) {
                msg.append(keyWord);
                first = false;
                continue;
            }
            msg.append("|" + keyWord);
        }
        msg.append("', Found " + found.toMessage());
        this.message = msg.toString();
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

