/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

public class Token {
    public String sval;
    public double nval;
    public int ttype;

    public Token(int ttype, String sval, double nval) {
        this.ttype = ttype;
        this.sval = sval;
        this.nval = nval;
    }

    public Token(int ttype, String sval) {
        this(ttype, sval, 0.0);
    }

    public Token(int ttype) {
        this(ttype, null, 0.0);
    }

    public String toMessage() {
        switch (this.ttype) {
            case 10: {
                return "\"EOL\"";
            }
            case -1: {
                return "\"EOF\"";
            }
            case -2: {
                return "NUMBER";
            }
            case -3: {
                if (this.sval == null) {
                    return "IDENTIFIER";
                }
                return "IDENTIFIER " + this.sval;
            }
        }
        if (this.ttype == 34) {
            String msg = "QUOTED STRING";
            if (this.sval != null) {
                msg = msg + " \"" + this.sval + "\"";
            }
            return msg;
        }
        return "CHARACTER '" + (char)this.ttype + "'";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.ttype) {
            case 10: {
                sb.append("ttype=TT_EOL");
                break;
            }
            case -1: {
                sb.append("ttype=TT_EOF");
                break;
            }
            case -2: {
                sb.append("ttype=TT_NUM,").append("nval=" + this.nval);
                break;
            }
            case -3: {
                if (this.sval == null) {
                    sb.append("ttype=TT_WORD:IDENTIFIER");
                    break;
                }
                sb.append("ttype=TT_WORD:").append("sval=" + this.sval);
                break;
            }
            default: {
                if (this.ttype == 34) {
                    sb.append("ttype=TT_STRING:").append("sval=" + this.sval);
                    break;
                }
                sb.append("ttype=TT_CHAR:").append((char)this.ttype);
            }
        }
        return sb.toString();
    }
}

