/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import sun.util.locale.LocaleEquivalentMaps;

public final class LocaleMatcher {
    public static List<Locale> filter(List<Locale.LanguageRange> priorityList, Collection<Locale> locales, Locale.FilteringMode mode) {
        if (priorityList.isEmpty() || locales.isEmpty()) {
            return new ArrayList<Locale>();
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (Locale locale : locales) {
            tags.add(locale.toLanguageTag());
        }
        List<String> filteredTags = LocaleMatcher.filterTags(priorityList, tags, mode);
        ArrayList<Locale> filteredLocales = new ArrayList<Locale>(filteredTags.size());
        for (String tag : filteredTags) {
            filteredLocales.add(Locale.forLanguageTag(tag));
        }
        return filteredLocales;
    }

    public static List<String> filterTags(List<Locale.LanguageRange> priorityList, Collection<String> tags, Locale.FilteringMode mode) {
        if (priorityList.isEmpty() || tags.isEmpty()) {
            return new ArrayList<String>();
        }
        if (mode == Locale.FilteringMode.EXTENDED_FILTERING) {
            return LocaleMatcher.filterExtended(priorityList, tags);
        }
        ArrayList<Locale.LanguageRange> list = new ArrayList<Locale.LanguageRange>();
        for (Locale.LanguageRange lr : priorityList) {
            String range = lr.getRange();
            if (range.startsWith("*-") || range.indexOf("-*") != -1) {
                if (mode == Locale.FilteringMode.AUTOSELECT_FILTERING) {
                    return LocaleMatcher.filterExtended(priorityList, tags);
                }
                if (mode == Locale.FilteringMode.MAP_EXTENDED_RANGES) {
                    range = range.charAt(0) == '*' ? "*" : range.replaceAll("-[*]", "");
                    list.add(new Locale.LanguageRange(range, lr.getWeight()));
                    continue;
                }
                if (mode != Locale.FilteringMode.REJECT_EXTENDED_RANGES) continue;
                throw new IllegalArgumentException("An extended range \"" + range + "\" found in REJECT_EXTENDED_RANGES mode.");
            }
            list.add(lr);
        }
        return LocaleMatcher.filterBasic(list, tags);
    }

    private static List<String> filterBasic(List<Locale.LanguageRange> priorityList, Collection<String> tags) {
        ArrayList<String> list = new ArrayList<String>();
        for (Locale.LanguageRange lr : priorityList) {
            String range = lr.getRange();
            if (range.equals("*")) {
                return new ArrayList<String>(tags);
            }
            for (String tag : tags) {
                if (!(tag = tag.toLowerCase()).startsWith(range)) continue;
                int len = range.length();
                if (tag.length() != len && tag.charAt(len) != '-' || list.contains(tag)) continue;
                list.add(tag);
            }
        }
        return list;
    }

    private static List<String> filterExtended(List<Locale.LanguageRange> priorityList, Collection<String> tags) {
        ArrayList<String> list = new ArrayList<String>();
        for (Locale.LanguageRange lr : priorityList) {
            String range = lr.getRange();
            if (range.equals("*")) {
                return new ArrayList<String>(tags);
            }
            String[] rangeSubtags = range.split("-");
            for (String tag : tags) {
                String[] tagSubtags = (tag = tag.toLowerCase()).split("-");
                if (!rangeSubtags[0].equals(tagSubtags[0]) && !rangeSubtags[0].equals("*")) continue;
                int rangeIndex = 1;
                int tagIndex = 1;
                while (rangeIndex < rangeSubtags.length && tagIndex < tagSubtags.length) {
                    if (rangeSubtags[rangeIndex].equals("*")) {
                        ++rangeIndex;
                        continue;
                    }
                    if (rangeSubtags[rangeIndex].equals(tagSubtags[tagIndex])) {
                        ++rangeIndex;
                        ++tagIndex;
                        continue;
                    }
                    if (tagSubtags[tagIndex].length() == 1 && !tagSubtags[tagIndex].equals("*")) break;
                    ++tagIndex;
                }
                if (rangeSubtags.length != rangeIndex || list.contains(tag)) continue;
                list.add(tag);
            }
        }
        return list;
    }

    public static Locale lookup(List<Locale.LanguageRange> priorityList, Collection<Locale> locales) {
        if (priorityList.isEmpty() || locales.isEmpty()) {
            return null;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (Locale locale : locales) {
            tags.add(locale.toLanguageTag());
        }
        String lookedUpTag = LocaleMatcher.lookupTag(priorityList, tags);
        if (lookedUpTag == null) {
            return null;
        }
        return Locale.forLanguageTag(lookedUpTag);
    }

    public static String lookupTag(List<Locale.LanguageRange> priorityList, Collection<String> tags) {
        if (priorityList.isEmpty() || tags.isEmpty()) {
            return null;
        }
        for (Locale.LanguageRange lr : priorityList) {
            String range = lr.getRange();
            if (range.equals("*")) continue;
            String rangeForRegex = range.replaceAll("\\x2A", "\\\\p{Alnum}*");
            while (!rangeForRegex.isEmpty()) {
                for (String tag : tags) {
                    if (!(tag = tag.toLowerCase()).matches(rangeForRegex)) continue;
                    return tag;
                }
                int index = rangeForRegex.lastIndexOf(45);
                if (index >= 0) {
                    if ((rangeForRegex = rangeForRegex.substring(0, index)).lastIndexOf(45) != rangeForRegex.length() - 2) continue;
                    rangeForRegex = rangeForRegex.substring(0, rangeForRegex.length() - 2);
                    continue;
                }
                rangeForRegex = "";
            }
        }
        return null;
    }

    public static List<Locale.LanguageRange> parse(String ranges) {
        if ((ranges = ranges.replaceAll(" ", "").toLowerCase()).startsWith("accept-language:")) {
            ranges = ranges.substring(16);
        }
        String[] langRanges = ranges.split(",");
        ArrayList<Locale.LanguageRange> list = new ArrayList<Locale.LanguageRange>(langRanges.length);
        ArrayList<String> tempList = new ArrayList<String>();
        int numOfRanges = 0;
        for (String range : langRanges) {
            String[] equivalents;
            double w;
            String r;
            int index = range.indexOf(";q=");
            if (index == -1) {
                r = range;
                w = 1.0;
            } else {
                r = range.substring(0, index);
                index += 3;
                try {
                    w = Double.parseDouble(range.substring(index));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("weight=\"" + range.substring(index) + "\" for language range \"" + r + "\"");
                }
                if (w < 0.0 || w > 1.0) {
                    throw new IllegalArgumentException("weight=" + w + " for language range \"" + r + "\". It must be between " + 0.0 + " and " + 1.0 + ".");
                }
            }
            if (tempList.contains(r)) continue;
            Locale.LanguageRange lr = new Locale.LanguageRange(r, w);
            index = numOfRanges;
            for (int j = 0; j < numOfRanges; ++j) {
                if (!(((Locale.LanguageRange)list.get(j)).getWeight() < w)) continue;
                index = j;
                break;
            }
            list.add(index, lr);
            ++numOfRanges;
            tempList.add(r);
            String equivalent = LocaleMatcher.getEquivalentForRegionAndVariant(r);
            if (equivalent != null && !tempList.contains(equivalent)) {
                list.add(index + 1, new Locale.LanguageRange(equivalent, w));
                ++numOfRanges;
                tempList.add(equivalent);
            }
            if ((equivalents = LocaleMatcher.getEquivalentsForLanguage(r)) == null) continue;
            for (String equiv : equivalents) {
                if (!tempList.contains(equiv)) {
                    list.add(index + 1, new Locale.LanguageRange(equiv, w));
                    ++numOfRanges;
                    tempList.add(equiv);
                }
                if ((equivalent = LocaleMatcher.getEquivalentForRegionAndVariant(equiv)) == null || tempList.contains(equivalent)) continue;
                list.add(index + 1, new Locale.LanguageRange(equivalent, w));
                ++numOfRanges;
                tempList.add(equivalent);
            }
        }
        return list;
    }

    private static String[] getEquivalentsForLanguage(String range) {
        String r = range;
        while (!r.isEmpty()) {
            if (LocaleEquivalentMaps.singleEquivMap.containsKey(r)) {
                String equiv = LocaleEquivalentMaps.singleEquivMap.get(r);
                return new String[]{range.replaceFirst(r, equiv)};
            }
            if (LocaleEquivalentMaps.multiEquivsMap.containsKey(r)) {
                String[] equivs = LocaleEquivalentMaps.multiEquivsMap.get(r);
                for (int i = 0; i < equivs.length; ++i) {
                    equivs[i] = range.replaceFirst(r, equivs[i]);
                }
                return equivs;
            }
            int index = r.lastIndexOf(45);
            if (index == -1) break;
            r = r.substring(0, index);
        }
        return null;
    }

    private static String getEquivalentForRegionAndVariant(String range) {
        int extensionKeyIndex = LocaleMatcher.getExtentionKeyIndex(range);
        for (String subtag : LocaleEquivalentMaps.regionVariantEquivMap.keySet()) {
            int index = range.indexOf(subtag);
            if (index == -1 || extensionKeyIndex != Integer.MIN_VALUE && index > extensionKeyIndex) continue;
            int len = index + subtag.length();
            if (range.length() != len && range.charAt(len) != '-') continue;
            return range.replaceFirst(subtag, LocaleEquivalentMaps.regionVariantEquivMap.get(subtag));
        }
        return null;
    }

    private static int getExtentionKeyIndex(String s) {
        char[] c = s.toCharArray();
        int index = Integer.MIN_VALUE;
        for (int i = 1; i < c.length; ++i) {
            if (c[i] != '-') continue;
            if (i - index == 2) {
                return index;
            }
            index = i;
        }
        return Integer.MIN_VALUE;
    }

    public static List<Locale.LanguageRange> mapEquivalents(List<Locale.LanguageRange> priorityList, Map<String, List<String>> map) {
        if (priorityList.isEmpty()) {
            return new ArrayList<Locale.LanguageRange>();
        }
        if (map == null || map.isEmpty()) {
            return new ArrayList<Locale.LanguageRange>(priorityList);
        }
        HashMap<String, String> keyMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            keyMap.put(key.toLowerCase(), key);
        }
        ArrayList<Locale.LanguageRange> list = new ArrayList<Locale.LanguageRange>();
        for (Locale.LanguageRange lr : priorityList) {
            String range;
            String r = range = lr.getRange();
            boolean hasEquivalent = false;
            while (!r.isEmpty()) {
                if (keyMap.containsKey(r)) {
                    hasEquivalent = true;
                    List<String> equivalents = map.get(keyMap.get(r));
                    if (equivalents == null) break;
                    int len = r.length();
                    for (String equivalent : equivalents) {
                        list.add(new Locale.LanguageRange(equivalent.toLowerCase() + range.substring(len), lr.getWeight()));
                    }
                    break;
                }
                int index = r.lastIndexOf(45);
                if (index == -1) break;
                r = r.substring(0, index);
            }
            if (hasEquivalent) continue;
            list.add(lr);
        }
        return list;
    }

    private LocaleMatcher() {
    }
}

