/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import sun.util.locale.Extension;
import sun.util.locale.LocaleUtils;

public class UnicodeLocaleExtension
extends Extension {
    public static final char SINGLETON = 'u';
    private final Set<String> attributes;
    private final Map<String, String> keywords;
    public static final UnicodeLocaleExtension CA_JAPANESE = new UnicodeLocaleExtension("ca", "japanese");
    public static final UnicodeLocaleExtension NU_THAI = new UnicodeLocaleExtension("nu", "thai");

    private UnicodeLocaleExtension(String key, String value) {
        super('u', key + "-" + value);
        this.attributes = Collections.emptySet();
        this.keywords = Collections.singletonMap(key, value);
    }

    UnicodeLocaleExtension(SortedSet<String> attributes, SortedMap<String, String> keywords) {
        super('u');
        this.attributes = attributes != null ? attributes : Collections.emptySet();
        this.keywords = keywords != null ? keywords : Collections.emptyMap();
        if (!this.attributes.isEmpty() || !this.keywords.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String string : this.attributes) {
                sb.append("-").append(string);
            }
            for (Map.Entry entry : this.keywords.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                sb.append("-").append(key);
                if (value.isEmpty()) continue;
                sb.append("-").append(value);
            }
            this.setValue(sb.substring(1));
        }
    }

    public Set<String> getUnicodeLocaleAttributes() {
        if (this.attributes == Collections.EMPTY_SET) {
            return this.attributes;
        }
        return Collections.unmodifiableSet(this.attributes);
    }

    public Set<String> getUnicodeLocaleKeys() {
        if (this.keywords == Collections.EMPTY_MAP) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.keywords.keySet());
    }

    public String getUnicodeLocaleType(String unicodeLocaleKey) {
        return this.keywords.get(unicodeLocaleKey);
    }

    public static boolean isSingletonChar(char c) {
        return 'u' == LocaleUtils.toLower(c);
    }

    public static boolean isAttribute(String s) {
        int len = s.length();
        return len >= 3 && len <= 8 && LocaleUtils.isAlphaNumericString(s);
    }

    public static boolean isKey(String s) {
        return s.length() == 2 && LocaleUtils.isAlphaNumericString(s);
    }

    public static boolean isTypeSubtag(String s) {
        int len = s.length();
        return len >= 3 && len <= 8 && LocaleUtils.isAlphaNumericString(s);
    }
}

