/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.locale.provider.BreakIteratorProviderImpl;
import sun.util.locale.provider.CalendarDataProviderImpl;
import sun.util.locale.provider.CalendarNameProviderImpl;
import sun.util.locale.provider.CalendarProviderImpl;
import sun.util.locale.provider.CollatorProviderImpl;
import sun.util.locale.provider.CurrencyNameProviderImpl;
import sun.util.locale.provider.DateFormatProviderImpl;
import sun.util.locale.provider.DateFormatSymbolsProviderImpl;
import sun.util.locale.provider.DecimalFormatSymbolsProviderImpl;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.locale.provider.LocaleDataMetaInfo;
import sun.util.locale.provider.LocaleNameProviderImpl;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.NumberFormatProviderImpl;
import sun.util.locale.provider.ResourceBundleBasedAdapter;
import sun.util.locale.provider.TimeZoneNameProviderImpl;
import sun.util.resources.LocaleData;
import sun.util.spi.CalendarProvider;

public class JRELocaleProviderAdapter
extends LocaleProviderAdapter
implements ResourceBundleBasedAdapter {
    private static final String LOCALE_DATA_JAR_NAME = "localedata.jar";
    private final ConcurrentMap<String, Set<String>> langtagSets = new ConcurrentHashMap<String, Set<String>>();
    private final ConcurrentMap<Locale, LocaleResources> localeResourcesMap = new ConcurrentHashMap<Locale, LocaleResources>();
    private volatile LocaleData localeData;
    private volatile BreakIteratorProvider breakIteratorProvider = null;
    private volatile CollatorProvider collatorProvider = null;
    private volatile DateFormatProvider dateFormatProvider = null;
    private volatile DateFormatSymbolsProvider dateFormatSymbolsProvider = null;
    private volatile DecimalFormatSymbolsProvider decimalFormatSymbolsProvider = null;
    private volatile NumberFormatProvider numberFormatProvider = null;
    private volatile CurrencyNameProvider currencyNameProvider = null;
    private volatile LocaleNameProvider localeNameProvider = null;
    private volatile TimeZoneNameProvider timeZoneNameProvider = null;
    private volatile CalendarDataProvider calendarDataProvider = null;
    private volatile CalendarNameProvider calendarNameProvider = null;
    private volatile CalendarProvider calendarProvider = null;
    private static volatile Boolean isNonENSupported = null;

    @Override
    public LocaleProviderAdapter.Type getAdapterType() {
        return LocaleProviderAdapter.Type.JRE;
    }

    @Override
    public <P extends LocaleServiceProvider> P getLocaleServiceProvider(Class<P> c) {
        switch (c.getSimpleName()) {
            case "BreakIteratorProvider": {
                return (P)this.getBreakIteratorProvider();
            }
            case "CollatorProvider": {
                return (P)this.getCollatorProvider();
            }
            case "DateFormatProvider": {
                return (P)this.getDateFormatProvider();
            }
            case "DateFormatSymbolsProvider": {
                return (P)this.getDateFormatSymbolsProvider();
            }
            case "DecimalFormatSymbolsProvider": {
                return (P)this.getDecimalFormatSymbolsProvider();
            }
            case "NumberFormatProvider": {
                return (P)this.getNumberFormatProvider();
            }
            case "CurrencyNameProvider": {
                return (P)this.getCurrencyNameProvider();
            }
            case "LocaleNameProvider": {
                return (P)this.getLocaleNameProvider();
            }
            case "TimeZoneNameProvider": {
                return (P)this.getTimeZoneNameProvider();
            }
            case "CalendarDataProvider": {
                return (P)this.getCalendarDataProvider();
            }
            case "CalendarNameProvider": {
                return (P)this.getCalendarNameProvider();
            }
            case "CalendarProvider": {
                return (P)this.getCalendarProvider();
            }
        }
        throw new InternalError("should not come down here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BreakIteratorProvider getBreakIteratorProvider() {
        if (this.breakIteratorProvider == null) {
            BreakIteratorProviderImpl provider = new BreakIteratorProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.breakIteratorProvider == null) {
                    this.breakIteratorProvider = provider;
                }
            }
        }
        return this.breakIteratorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollatorProvider getCollatorProvider() {
        if (this.collatorProvider == null) {
            CollatorProviderImpl provider = new CollatorProviderImpl(this.getAdapterType(), this.getLanguageTagSet("CollationData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.collatorProvider == null) {
                    this.collatorProvider = provider;
                }
            }
        }
        return this.collatorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateFormatProvider getDateFormatProvider() {
        if (this.dateFormatProvider == null) {
            DateFormatProviderImpl provider = new DateFormatProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.dateFormatProvider == null) {
                    this.dateFormatProvider = provider;
                }
            }
        }
        return this.dateFormatProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateFormatSymbolsProvider getDateFormatSymbolsProvider() {
        if (this.dateFormatSymbolsProvider == null) {
            DateFormatSymbolsProviderImpl provider = new DateFormatSymbolsProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.dateFormatSymbolsProvider == null) {
                    this.dateFormatSymbolsProvider = provider;
                }
            }
        }
        return this.dateFormatSymbolsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider() {
        if (this.decimalFormatSymbolsProvider == null) {
            DecimalFormatSymbolsProviderImpl provider = new DecimalFormatSymbolsProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.decimalFormatSymbolsProvider == null) {
                    this.decimalFormatSymbolsProvider = provider;
                }
            }
        }
        return this.decimalFormatSymbolsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NumberFormatProvider getNumberFormatProvider() {
        if (this.numberFormatProvider == null) {
            NumberFormatProviderImpl provider = new NumberFormatProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.numberFormatProvider == null) {
                    this.numberFormatProvider = provider;
                }
            }
        }
        return this.numberFormatProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CurrencyNameProvider getCurrencyNameProvider() {
        if (this.currencyNameProvider == null) {
            CurrencyNameProviderImpl provider = new CurrencyNameProviderImpl(this.getAdapterType(), this.getLanguageTagSet("CurrencyNames"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.currencyNameProvider == null) {
                    this.currencyNameProvider = provider;
                }
            }
        }
        return this.currencyNameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocaleNameProvider getLocaleNameProvider() {
        if (this.localeNameProvider == null) {
            LocaleNameProviderImpl provider = new LocaleNameProviderImpl(this.getAdapterType(), this.getLanguageTagSet("LocaleNames"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.localeNameProvider == null) {
                    this.localeNameProvider = provider;
                }
            }
        }
        return this.localeNameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeZoneNameProvider getTimeZoneNameProvider() {
        if (this.timeZoneNameProvider == null) {
            TimeZoneNameProviderImpl provider = new TimeZoneNameProviderImpl(this.getAdapterType(), this.getLanguageTagSet("TimeZoneNames"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.timeZoneNameProvider == null) {
                    this.timeZoneNameProvider = provider;
                }
            }
        }
        return this.timeZoneNameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalendarDataProvider getCalendarDataProvider() {
        if (this.calendarDataProvider == null) {
            CalendarDataProviderImpl provider = new CalendarDataProviderImpl(this.getAdapterType(), this.getLanguageTagSet("CalendarData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.calendarDataProvider == null) {
                    this.calendarDataProvider = provider;
                }
            }
        }
        return this.calendarDataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalendarNameProvider getCalendarNameProvider() {
        if (this.calendarNameProvider == null) {
            CalendarNameProviderImpl provider = new CalendarNameProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.calendarNameProvider == null) {
                    this.calendarNameProvider = provider;
                }
            }
        }
        return this.calendarNameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalendarProvider getCalendarProvider() {
        if (this.calendarProvider == null) {
            CalendarProviderImpl provider = new CalendarProviderImpl(this.getAdapterType(), this.getLanguageTagSet("CalendarData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.calendarProvider == null) {
                    this.calendarProvider = provider;
                }
            }
        }
        return this.calendarProvider;
    }

    @Override
    public LocaleResources getLocaleResources(Locale locale) {
        LocaleResources lrc;
        LocaleResources lr = (LocaleResources)this.localeResourcesMap.get(locale);
        if (lr == null && (lrc = this.localeResourcesMap.putIfAbsent(locale, lr = new LocaleResources(this, locale))) != null) {
            lr = lrc;
        }
        return lr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocaleData getLocaleData() {
        if (this.localeData == null) {
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.localeData == null) {
                    this.localeData = new LocaleData(this.getAdapterType());
                }
            }
        }
        return this.localeData;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return (Locale[])AvailableJRELocales.localeList.clone();
    }

    public Set<String> getLanguageTagSet(String category) {
        Set<String> ts;
        Set<String> tagset = (Set<String>)this.langtagSets.get(category);
        if (tagset == null && (ts = this.langtagSets.putIfAbsent(category, tagset = this.createLanguageTagSet(category))) != null) {
            tagset = ts;
        }
        return tagset;
    }

    protected Set<String> createLanguageTagSet(String category) {
        String supportedLocaleString = LocaleDataMetaInfo.getSupportedLocaleString(category);
        if (supportedLocaleString == null) {
            return Collections.emptySet();
        }
        HashSet<String> tagset = new HashSet<String>();
        StringTokenizer tokens = new StringTokenizer(supportedLocaleString);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals("|")) {
                if (!JRELocaleProviderAdapter.isNonENLangSupported()) break;
                continue;
            }
            tagset.add(token);
        }
        return tagset;
    }

    private static Locale[] createAvailableLocales() {
        String supportedLocaleString = LocaleDataMetaInfo.getSupportedLocaleString("AvailableLocales");
        if (supportedLocaleString.isEmpty()) {
            throw new InternalError("No available locales for JRE");
        }
        int barIndex = supportedLocaleString.indexOf(124);
        StringTokenizer localeStringTokenizer = JRELocaleProviderAdapter.isNonENLangSupported() ? new StringTokenizer(supportedLocaleString.substring(0, barIndex) + supportedLocaleString.substring(barIndex + 1)) : new StringTokenizer(supportedLocaleString.substring(0, barIndex));
        int length = localeStringTokenizer.countTokens();
        Locale[] locales = new Locale[length + 1];
        locales[0] = Locale.ROOT;
        block10: for (int i = 1; i <= length; ++i) {
            String currentToken;
            switch (currentToken = localeStringTokenizer.nextToken()) {
                case "ja-JP-JP": {
                    locales[i] = JRELocaleConstants.JA_JP_JP;
                    continue block10;
                }
                case "no-NO-NY": {
                    locales[i] = JRELocaleConstants.NO_NO_NY;
                    continue block10;
                }
                case "th-TH-TH": {
                    locales[i] = JRELocaleConstants.TH_TH_TH;
                    continue block10;
                }
                default: {
                    locales[i] = Locale.forLanguageTag(currentToken);
                }
            }
        }
        return locales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNonENLangSupported() {
        if (isNonENSupported != null) return isNonENSupported;
        Class<JRELocaleProviderAdapter> clazz = JRELocaleProviderAdapter.class;
        synchronized (JRELocaleProviderAdapter.class) {
            if (isNonENSupported != null) return isNonENSupported;
            String sep = File.separator;
            String localeDataJar = AccessController.doPrivileged(new GetPropertyAction("java.home")) + sep + "lib" + sep + "ext" + sep + LOCALE_DATA_JAR_NAME;
            final File f = new File(localeDataJar);
            isNonENSupported = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return f.exists();
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return isNonENSupported;
        }
    }

    static /* synthetic */ Locale[] access$100() {
        return JRELocaleProviderAdapter.createAvailableLocales();
    }

    private static class AvailableJRELocales {
        private static final Locale[] localeList = JRELocaleProviderAdapter.access$100();

        private AvailableJRELocales() {
        }
    }
}

