/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging;

import com.sap.jvm.debugging.types.ThreadHandle;

public class ThreadChanges {
    private static final ThreadHandle[] NO_THREADS = new ThreadHandle[0];
    private final ThreadHandle[] startedThreads;
    private final ThreadHandle[] stoppedThreads;
    private final ThreadHandle[] changedThreads;

    public ThreadChanges(ThreadHandle[] startedThreads, ThreadHandle[] stoppedThreads, ThreadHandle[] changedThreads) {
        this.startedThreads = startedThreads;
        this.stoppedThreads = stoppedThreads;
        this.changedThreads = changedThreads;
    }

    public static ThreadChanges createForStarted(ThreadHandle[] threads) {
        return new ThreadChanges(threads, NO_THREADS, NO_THREADS);
    }

    public static ThreadChanges createForStopped(ThreadHandle[] threads) {
        return new ThreadChanges(NO_THREADS, threads, NO_THREADS);
    }

    public static ThreadChanges createForChanged(ThreadHandle[] threads) {
        return new ThreadChanges(NO_THREADS, NO_THREADS, threads);
    }

    public ThreadHandle[] getStartedThreads() {
        return this.startedThreads;
    }

    public ThreadHandle[] getStoppedThreads() {
        return this.stoppedThreads;
    }

    public ThreadHandle[] getChangedThreads() {
        return this.changedThreads;
    }
}

